/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.jpdl.par;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.jbpm.graph.def.ProcessDefinition;
import org.jbpm.instantiation.ClassLoaderUtil;
import org.jbpm.jpdl.par.ProcessArchiveParser;
import org.jbpm.jpdl.xml.Problem;

public class ProcessArchive {
    static final int BUFFERSIZE = 4096;
    static List processArchiveParsers = ProcessArchive.getProcessArchiveParsers();
    String name = "";
    Map entries = new HashMap();
    List problems = new ArrayList();

    public ProcessArchive(ZipInputStream zipInputStream) throws IOException {
        ZipEntry zipEntry = zipInputStream.getNextEntry();
        while (zipEntry != null) {
            String entryName = zipEntry.getName();
            byte[] bytes = ProcessArchive.readBytes(zipInputStream);
            if (bytes != null) {
                this.entries.put(entryName, bytes);
            }
            zipEntry = zipInputStream.getNextEntry();
        }
    }

    public ProcessDefinition parseProcessDefinition() {
        ProcessDefinition processDefinition = ProcessDefinition.createNewProcessDefinition();
        for (ProcessArchiveParser processArchiveParser : processArchiveParsers) {
            processDefinition = processArchiveParser.readFromArchive(this, processDefinition);
        }
        return processDefinition;
    }

    public String toString() {
        return "process-archive(" + this.name + ")";
    }

    public Map getEntries() {
        return this.entries;
    }

    public byte[] getEntry(String entryName) {
        return (byte[])this.entries.get(entryName);
    }

    public InputStream getEntryInputStream(String entryName) {
        return new ByteArrayInputStream(this.getEntry(entryName));
    }

    public byte[] removeEntry(String entryName) {
        return (byte[])this.entries.remove(entryName);
    }

    public InputStream removeEntryInputStream(String entryName) {
        return new ByteArrayInputStream(this.removeEntry(entryName));
    }

    public void addProblem(Problem problem) {
        this.problems.add(problem);
    }

    public void addError(String description) {
        this.addProblem(new Problem(2, description));
    }

    public void addError(String description, Throwable exception) {
        this.addProblem(new Problem(2, description, exception));
    }

    public void addWarning(String description) {
        this.addProblem(new Problem(3, description));
    }

    public List getProblems() {
        return this.problems;
    }

    public void resetProblems() {
        this.problems = new ArrayList();
    }

    static byte[] readBytes(InputStream inputStream) throws IOException {
        byte[] bytes = null;
        if (inputStream == null) {
            throw new NullPointerException("inputStream is null in ProcessArchive.readBytes()");
        }
        byte[] buffer = new byte[4096];
        int bytesRead = 0;
        while ((bytesRead = inputStream.read(buffer)) != -1) {
            if (bytes != null) {
                byte[] oldBytes = bytes;
                bytes = new byte[oldBytes.length + bytesRead];
                System.arraycopy(oldBytes, 0, bytes, 0, oldBytes.length);
                System.arraycopy(buffer, 0, bytes, oldBytes.length, bytesRead);
                continue;
            }
            bytes = new byte[bytesRead];
            System.arraycopy(buffer, 0, bytes, 0, bytesRead);
        }
        return bytes;
    }

    private static List getProcessArchiveParsers() {
        ArrayList<ProcessArchiveParser> processArchiveParsers = new ArrayList<ProcessArchiveParser>();
        try {
            InputStream parsersStream = ClassLoaderUtil.getStream("jbpm.parsers.xml", "org/jbpm/jpdl/par");
            Document document = new SAXReader().read(parsersStream);
            Iterator iter = document.getRootElement().elementIterator("parser");
            while (iter.hasNext()) {
                Element element = (Element)iter.next();
                String className = element.attributeValue("class");
                ProcessArchiveParser processArchiveParser = (ProcessArchiveParser)ClassLoaderUtil.loadClass(className).newInstance();
                processArchiveParsers.add(processArchiveParser);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("couldn't parse process archive parsers (jbpm.parsers.xml)", e);
        }
        return processArchiveParsers;
    }
}

