/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.jpdl.par;

import java.io.File;
import java.io.FileInputStream;
import java.util.zip.ZipInputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jbpm.db.JbpmSession;
import org.jbpm.db.JbpmSessionFactory;
import org.jbpm.graph.def.ProcessDefinition;

public class ProcessArchiveDeployer {
    JbpmSessionFactory jbpmSessionFactory = null;
    private static final Log log = LogFactory.getLog(ProcessArchiveDeployer.class);

    public ProcessArchiveDeployer() {
        this.jbpmSessionFactory = JbpmSessionFactory.buildJbpmSessionFactory();
    }

    public ProcessArchiveDeployer(JbpmSessionFactory jbpmSessionFactory) {
        this.jbpmSessionFactory = jbpmSessionFactory;
    }

    public static void deployResource(String parResource) {
        ProcessArchiveDeployer.deployResource(parResource, JbpmSessionFactory.getInstance());
    }

    public static void deployResource(String parResource, JbpmSessionFactory jbpmSessionFactory) {
        ProcessDefinition processDefinition = ProcessDefinition.parseParResource(parResource);
        ProcessArchiveDeployer.deployProcessDefinition(processDefinition, jbpmSessionFactory);
    }

    public static void deployZipInputStream(ZipInputStream zipInputStream) {
        ProcessArchiveDeployer.deployZipInputStream(zipInputStream, JbpmSessionFactory.getInstance());
    }

    public static void deployZipInputStream(ZipInputStream zipInputStream, JbpmSessionFactory jbpmSessionFactory) {
        ProcessDefinition processDefinition = ProcessDefinition.parseParZipInputStream(zipInputStream);
        ProcessArchiveDeployer.deployProcessDefinition(processDefinition, jbpmSessionFactory);
    }

    public static void deployProcessDefinition(ProcessDefinition processDefinition) {
        ProcessArchiveDeployer.deployProcessDefinition(processDefinition, JbpmSessionFactory.getInstance());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deployProcessDefinition(ProcessDefinition processDefinition, JbpmSessionFactory jbpmSessionFactory) {
        JbpmSession jbpmSession = jbpmSessionFactory.openJbpmSession();
        try {
            log.debug((Object)("starting transaction to deploy process " + processDefinition));
            jbpmSession.beginTransaction();
            String processDefinitionName = processDefinition.getName();
            if (processDefinitionName != null) {
                ProcessDefinition previousLatestVersion = jbpmSession.getGraphSession().findLatestProcessDefinition(processDefinitionName);
                if (previousLatestVersion != null) {
                    processDefinition.setVersion(previousLatestVersion.getVersion() + 1);
                } else {
                    processDefinition.setVersion(1);
                }
            }
            jbpmSession.getGraphSession().saveProcessDefinition(processDefinition);
            log.debug((Object)"flushing...");
            jbpmSession.getSession().flush();
            log.debug((Object)("committing transaction to deploy process " + processDefinition));
            jbpmSession.commitTransaction();
        }
        finally {
            jbpmSession.close();
        }
    }

    public static void main(String[] args) {
        if (args != null && args.length > 0) {
            for (int i = 0; i < args.length; ++i) {
                try {
                    ProcessArchiveDeployer.deployZipInputStream(new ZipInputStream(new FileInputStream(new File(args[i]))));
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

