/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.scheduler.exe;

import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jbpm.graph.def.Action;
import org.jbpm.graph.def.GraphElement;
import org.jbpm.graph.exe.ExecutionContext;
import org.jbpm.graph.exe.ProcessInstance;
import org.jbpm.graph.exe.Token;
import org.jbpm.taskmgmt.exe.TaskInstance;

public class Timer
implements Serializable {
    private static final long serialVersionUID = 1L;
    long id = 0L;
    String name = null;
    Date dueDate = null;
    String repeat = null;
    String transitionName = null;
    Action action = null;
    Token token = null;
    ProcessInstance processInstance = null;
    TaskInstance taskInstance = null;
    GraphElement graphElement = null;
    String exception = null;
    private static DateFormat dateFormat = new SimpleDateFormat("HH:mm:ss,SSS");
    private static final Log log = LogFactory.getLog(Timer.class);

    Timer() {
    }

    public Timer(Token token) {
        this.token = token;
        this.processInstance = token.getProcessInstance();
    }

    public void execute() {
        block9: {
            ExecutionContext executionContext = new ExecutionContext(this.token);
            if (this.taskInstance != null) {
                executionContext.setTaskInstance(this.taskInstance);
            }
            if (this.graphElement != null) {
                this.graphElement.fireAndPropagateEvent("timer", executionContext);
            }
            if (this.action != null) {
                try {
                    log.debug((Object)("executing timer '" + this + "'"));
                    this.action.execute(executionContext);
                }
                catch (Throwable actionException) {
                    log.warn((Object)"timer action threw exception", actionException);
                    Throwable t = actionException;
                    try {
                        if (this.graphElement != null) {
                            this.graphElement.raiseException(actionException, executionContext);
                            log.debug((Object)("timer exception got handled by '" + this.graphElement + "'"));
                            t = null;
                        }
                    }
                    catch (Throwable rethrowOrDelegationException) {
                        t = rethrowOrDelegationException;
                    }
                    if (t == null) break block9;
                    log.error((Object)"unhandled timer exception", t);
                    StringWriter sw = new StringWriter();
                    actionException.printStackTrace(new PrintWriter(sw));
                    this.exception = sw.toString();
                    if (this.exception.length() <= 4000) break block9;
                    this.exception = this.exception.substring(0, 4000);
                }
            }
        }
        if (this.transitionName != null && this.exception == null && this.token.getNode().hasLeavingTransition(this.transitionName)) {
            this.token.signal(this.transitionName);
        }
    }

    public boolean isDue() {
        return this.dueDate.getTime() <= System.currentTimeMillis();
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("timer(");
        buffer.append(this.name);
        if (this.action != null && this.action.getActionDelegation() != null && this.action.getActionDelegation().getClassName() != null) {
            buffer.append(",");
            buffer.append(this.action.getActionDelegation().getClassName());
        }
        if (this.dueDate != null) {
            buffer.append(",");
            buffer.append(dateFormat.format(this.dueDate));
        }
        buffer.append(")");
        return buffer.toString();
    }

    public Date getDueDate() {
        return this.dueDate;
    }

    public void setDueDate(Date dueDate) {
        this.dueDate = dueDate;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getRepeat() {
        return this.repeat;
    }

    public void setRepeat(String repeatDuration) {
        this.repeat = repeatDuration;
    }

    public Token getToken() {
        return this.token;
    }

    public void setToken(Token token) {
        this.token = token;
    }

    public String getTransitionName() {
        return this.transitionName;
    }

    public void setTransitionName(String transitionName) {
        this.transitionName = transitionName;
    }

    public long getId() {
        return this.id;
    }

    public GraphElement getGraphElement() {
        return this.graphElement;
    }

    public void setGraphElement(GraphElement graphElement) {
        this.graphElement = graphElement;
    }

    public Action getAction() {
        return this.action;
    }

    public void setAction(Action action) {
        this.action = action;
    }

    public String getException() {
        return this.exception;
    }

    public TaskInstance getTaskInstance() {
        return this.taskInstance;
    }

    public void setTaskInstance(TaskInstance taskInstance) {
        this.taskInstance = taskInstance;
    }
}

