/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.scheduler.impl;

import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jbpm.calendar.BusinessCalendar;
import org.jbpm.calendar.Duration;
import org.jbpm.db.JbpmSession;
import org.jbpm.db.JbpmSessionFactory;
import org.jbpm.db.SchedulerSession;
import org.jbpm.scheduler.exe.Timer;
import org.jbpm.scheduler.impl.SchedulerListener;

public class SchedulerThread
extends Thread {
    static JbpmSessionFactory jbpmSessionFactory = JbpmSessionFactory.getInstance();
    static BusinessCalendar businessCalendar = new BusinessCalendar();
    List listeners = new ArrayList();
    boolean keepRunning = true;
    long interval = 5000L;
    private static final Log log = LogFactory.getLog(SchedulerThread.class);

    public SchedulerThread() {
        super("jbpm scheduler");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (this.keepRunning) {
            long millisToWait = this.interval;
            try {
                millisToWait = this.executeTimers();
                if (millisToWait < 0L) {
                    millisToWait = this.interval;
                }
                millisToWait = Math.min(millisToWait, this.interval);
            }
            catch (RuntimeException e) {
                log.info((Object)"runtime exception while executing timers", (Throwable)e);
            }
            finally {
                try {
                    Thread.sleep(millisToWait);
                }
                catch (InterruptedException e) {
                    log.info((Object)"waiting for timers got interuppted");
                }
            }
        }
        log.info((Object)"ending scheduler thread");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long executeTimers() {
        long millisTillNextTimerIsDue = -1L;
        boolean isDueDateInPast = true;
        JbpmSession jbpmSession = jbpmSessionFactory.openJbpmSessionAndBeginTransaction();
        try {
            SchedulerSession schedulerSession = new SchedulerSession(jbpmSession);
            log.debug((Object)"checking for timers");
            Iterator iter = schedulerSession.findTimersByDueDate();
            while (iter.hasNext() && isDueDateInPast) {
                Timer timer = (Timer)iter.next();
                log.debug((Object)("found timer " + timer));
                if (timer.isDue()) {
                    log.debug((Object)("executing timer '" + timer + "'"));
                    timer.execute();
                    this.notifyListeners(timer);
                    if (timer.getException() != null) {
                        schedulerSession.saveTimer(timer);
                        continue;
                    }
                    if (timer.getRepeat() != null) {
                        Date dueDate = timer.getDueDate();
                        while (dueDate.getTime() <= System.currentTimeMillis()) {
                            dueDate = businessCalendar.add(dueDate, new Duration(timer.getRepeat()));
                        }
                        timer.setDueDate(dueDate);
                        log.debug((Object)("saving updated timer for repetition '" + timer + "' in '" + (dueDate.getTime() - System.currentTimeMillis()) + "' millis"));
                        schedulerSession.saveTimer(timer);
                        continue;
                    }
                    log.debug((Object)("deleting timer '" + timer + "'"));
                    schedulerSession.deleteTimer(timer);
                    continue;
                }
                isDueDateInPast = false;
                millisTillNextTimerIsDue = timer.getDueDate().getTime() - System.currentTimeMillis();
            }
        }
        finally {
            jbpmSession.commitTransactionAndClose();
        }
        return millisTillNextTimerIsDue;
    }

    public void addListener(SchedulerListener listener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList();
        }
        this.listeners.add(listener);
    }

    public void removeListener(SchedulerListener listener) {
        this.listeners.remove(listener);
        if (this.listeners.isEmpty()) {
            this.listeners = null;
        }
    }

    private void notifyListeners(Timer timer) {
        if (this.listeners != null) {
            Date now = new Date();
            for (SchedulerListener timerRunnerListener : new ArrayList(this.listeners)) {
                timerRunnerListener.timerExecuted(now, timer);
            }
        }
    }

    public void setInterval(long interval) {
        this.interval = interval;
    }
}

