/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.taskmgmt.def;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jbpm.context.def.VariableAccess;
import org.jbpm.context.exe.ContextInstance;
import org.jbpm.graph.exe.ProcessInstance;
import org.jbpm.graph.exe.Token;
import org.jbpm.instantiation.Delegation;
import org.jbpm.taskmgmt.def.TaskControllerHandler;
import org.jbpm.taskmgmt.exe.TaskFormParameter;
import org.jbpm.taskmgmt.exe.TaskInstance;

public class TaskController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private long id = 0L;
    private Delegation taskControllerDelegation = null;
    private List variableAccesses = null;

    public List getTaskFormParameters(TaskInstance taskInstance) {
        List<TaskFormParameter> taskFormParameters = null;
        if (this.taskControllerDelegation != null) {
            TaskControllerHandler taskControllerHandler = (TaskControllerHandler)this.taskControllerDelegation.instantiate();
            taskFormParameters = taskControllerHandler.getTaskFormParameters(taskInstance);
        } else {
            taskFormParameters = new ArrayList();
            Token token = taskInstance.getToken();
            ProcessInstance processInstance = token.getProcessInstance();
            ContextInstance contextInstance = (ContextInstance)processInstance.getInstance(ContextInstance.class);
            for (VariableAccess variableAccess : this.variableAccesses) {
                if (!variableAccess.isReadable()) continue;
                Object value = contextInstance.getVariable(variableAccess.getVariableName(), token);
                taskFormParameters.add(new TaskFormParameter(variableAccess, value));
            }
        }
        return taskFormParameters;
    }

    public void submitParameters(Map parameters, TaskInstance taskInstance) {
        if (this.taskControllerDelegation != null) {
            TaskControllerHandler taskControllerHandler = (TaskControllerHandler)this.taskControllerDelegation.instantiate();
            taskControllerHandler.submitParameters(parameters, taskInstance);
        } else {
            Token token = taskInstance.getToken();
            ProcessInstance processInstance = token.getProcessInstance();
            ContextInstance contextInstance = (ContextInstance)processInstance.getInstance(ContextInstance.class);
            String missingParameters = null;
            for (VariableAccess variableAccess : this.variableAccesses) {
                String parameterName = variableAccess.getMappedName();
                if (variableAccess.isRequired() && parameters.get(parameterName) == null) {
                    missingParameters = missingParameters == null ? parameterName : missingParameters + ", " + parameterName;
                }
                if (!variableAccess.isWritable() || parameters.get(parameterName) == null) continue;
                contextInstance.setVariable(variableAccess.getVariableName(), parameters.get(parameterName), token);
            }
            if (missingParameters != null) {
                throw new IllegalArgumentException("missing parameters: " + missingParameters);
            }
        }
    }

    public boolean hasVariableAccess(String variableName) {
        if (this.variableAccesses != null) {
            for (VariableAccess variableAccess : this.variableAccesses) {
                if (!variableAccess.getVariableName().equals(variableName)) continue;
                return true;
            }
        }
        return false;
    }

    public List getVariableAccesses() {
        return this.variableAccesses;
    }

    public Delegation getTaskControllerDelegation() {
        return this.taskControllerDelegation;
    }

    public void setTaskControllerDelegation(Delegation taskControllerDelegation) {
        this.taskControllerDelegation = taskControllerDelegation;
    }

    public long getId() {
        return this.id;
    }

    public void setVariableAccesses(List variableAccesses) {
        this.variableAccesses = variableAccesses;
    }
}

