/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.taskmgmt.exe;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.jbpm.JbpmConfiguration;
import org.jbpm.db.JbpmSession;
import org.jbpm.graph.def.DelegationException;
import org.jbpm.graph.def.GraphElement;
import org.jbpm.graph.exe.ExecutionContext;
import org.jbpm.graph.exe.Token;
import org.jbpm.instantiation.ClassLoaderUtil;
import org.jbpm.instantiation.Delegation;
import org.jbpm.module.exe.ModuleInstance;
import org.jbpm.security.Authentication;
import org.jbpm.taskmgmt.def.AssignmentHandler;
import org.jbpm.taskmgmt.def.Swimlane;
import org.jbpm.taskmgmt.def.Task;
import org.jbpm.taskmgmt.def.TaskMgmtDefinition;
import org.jbpm.taskmgmt.exe.Assignable;
import org.jbpm.taskmgmt.exe.SwimlaneInstance;
import org.jbpm.taskmgmt.exe.TaskInstance;
import org.jbpm.taskmgmt.log.TaskCreateLog;

public class TaskMgmtInstance
extends ModuleInstance {
    private static final long serialVersionUID = 1L;
    private TaskMgmtDefinition taskMgmtDefinition = null;
    private Map swimlaneInstances = null;
    private Set taskInstances = null;
    private static Class taskInstanceClass = null;

    public TaskMgmtInstance() {
    }

    public TaskMgmtInstance(TaskMgmtDefinition taskMgmtDefinition) {
        this.taskMgmtDefinition = taskMgmtDefinition;
    }

    public static Class getTaskInstanceClass() {
        if (taskInstanceClass == null) {
            String taskInstanceClassName = JbpmConfiguration.getString("jbpm.task.instance.class");
            taskInstanceClass = ClassLoaderUtil.loadClass(taskInstanceClassName);
        }
        return taskInstanceClass;
    }

    public TaskInstance createTaskInstance() {
        return this.createTaskInstance(null, (ExecutionContext)null);
    }

    public TaskInstance createTaskInstance(Task task) {
        return this.createTaskInstance(task, (ExecutionContext)null);
    }

    public TaskInstance createTaskInstance(Token token) {
        return this.createTaskInstance(null, new ExecutionContext(token));
    }

    public TaskInstance createTaskInstance(Task task, Token token) {
        return this.createTaskInstance(task, new ExecutionContext(token));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TaskInstance createTaskInstance(Task task, ExecutionContext executionContext) {
        JbpmSession currentSession;
        TaskInstance taskInstance = null;
        taskInstance = this.instantiateNewTaskInstance();
        this.addTaskInstance(taskInstance);
        if (task != null) {
            taskInstance.setTask(task);
        }
        if ((currentSession = JbpmSession.getCurrentJbpmSession()) != null) {
            currentSession.getSession().save((Object)taskInstance);
        }
        if (executionContext != null) {
            Token token = executionContext.getToken();
            taskInstance.setToken(token);
            try {
                executionContext.setTask(task);
                executionContext.setTaskInstance(taskInstance);
                executionContext.setEventSource(task);
                if (task != null) {
                    taskInstance.assign(executionContext);
                }
                taskInstance.create(executionContext);
            }
            finally {
                executionContext.setTask(null);
                executionContext.setTaskInstance(null);
                executionContext.setEventSource(null);
            }
            token.addLog(new TaskCreateLog(taskInstance, taskInstance.getActorId()));
        } else {
            taskInstance.create();
        }
        return taskInstance;
    }

    public SwimlaneInstance getInitializedSwimlaneInstance(ExecutionContext executionContext, Swimlane swimlane) {
        SwimlaneInstance swimlaneInstance;
        if (this.swimlaneInstances == null) {
            this.swimlaneInstances = new HashMap();
        }
        if ((swimlaneInstance = (SwimlaneInstance)this.swimlaneInstances.get(swimlane.getName())) == null) {
            swimlaneInstance = new SwimlaneInstance(swimlane);
            this.addSwimlaneInstance(swimlaneInstance);
            this.invokeAssignmentHandler(swimlane.getAssignmentDelegation(), swimlaneInstance, executionContext);
        }
        return swimlaneInstance;
    }

    public void invokeAssignmentHandler(Delegation assignmentDelegation, Assignable assignable, ExecutionContext executionContext) {
        try {
            if (assignmentDelegation != null) {
                AssignmentHandler assignmentHandler = (AssignmentHandler)assignmentDelegation.instantiate();
                assignmentHandler.assign(assignable, executionContext);
            }
        }
        catch (Exception exception) {
            GraphElement graphElement = executionContext.getEventSource();
            if (graphElement != null) {
                graphElement.raiseException(exception, executionContext);
            }
            throw new DelegationException(exception, executionContext);
        }
    }

    public TaskInstance createStartTaskInstance() {
        TaskInstance taskInstance = null;
        Task startTask = this.taskMgmtDefinition.getStartTask();
        Token rootToken = this.processInstance.getRootToken();
        ExecutionContext executionContext = new ExecutionContext(rootToken);
        taskInstance = this.createTaskInstance(startTask, executionContext);
        taskInstance.setActorId(Authentication.getAuthenticatedActorId());
        return taskInstance;
    }

    private TaskInstance instantiateNewTaskInstance() {
        TaskInstance newTaskInstance = null;
        try {
            newTaskInstance = (TaskInstance)TaskMgmtInstance.getTaskInstanceClass().newInstance();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("couldn't instantiate task instance '" + taskInstanceClass.getName() + "'", e);
        }
        return newTaskInstance;
    }

    public boolean hasBlockingTaskInstances(Token token) {
        boolean hasBlockingTasks = false;
        if (this.taskInstances != null) {
            Iterator iter = this.taskInstances.iterator();
            while (iter.hasNext() && !hasBlockingTasks) {
                TaskInstance taskInstance = (TaskInstance)iter.next();
                if (taskInstance.hasEnded() || !taskInstance.isBlocking() || taskInstance.getToken() != token) continue;
                hasBlockingTasks = true;
            }
        }
        return hasBlockingTasks;
    }

    public boolean hasUnfinishedTasks(Token token) {
        return this.getUnfinishedTasks(token).size() > 0;
    }

    public Collection getUnfinishedTasks(Token token) {
        ArrayList<TaskInstance> unfinishedTasks = new ArrayList<TaskInstance>();
        if (this.taskInstances != null) {
            for (TaskInstance task : this.taskInstances) {
                if (task.hasEnded() || token != task.getToken()) continue;
                unfinishedTasks.add(task);
            }
        }
        return unfinishedTasks;
    }

    public boolean hasSignallingTasks(ExecutionContext executionContext) {
        return this.getSignallingTasks(executionContext).size() > 0;
    }

    public Collection getSignallingTasks(ExecutionContext executionContext) {
        ArrayList<TaskInstance> signallingTasks = new ArrayList<TaskInstance>();
        if (this.taskInstances != null) {
            for (TaskInstance taskInstance : this.taskInstances) {
                if (!taskInstance.isSignalling() || executionContext.getToken() != taskInstance.getToken()) continue;
                signallingTasks.add(taskInstance);
            }
        }
        return signallingTasks;
    }

    public Collection getTaskInstances() {
        return this.taskInstances;
    }

    public void addTaskInstance(TaskInstance taskInstance) {
        if (this.taskInstances == null) {
            this.taskInstances = new HashSet();
        }
        this.taskInstances.add(taskInstance);
        taskInstance.setTaskMgmtInstance(this);
    }

    public void removeTaskInstance(TaskInstance taskInstance) {
        if (this.taskInstances != null) {
            this.taskInstances.remove(taskInstance);
        }
    }

    public Map getSwimlaneInstances() {
        return this.swimlaneInstances;
    }

    public void addSwimlaneInstance(SwimlaneInstance swimlaneInstance) {
        if (this.swimlaneInstances == null) {
            this.swimlaneInstances = new HashMap();
        }
        this.swimlaneInstances.put(swimlaneInstance.getName(), swimlaneInstance);
        swimlaneInstance.setTaskMgmtInstance(this);
    }

    public SwimlaneInstance getSwimlaneInstance(String swimlaneName) {
        return this.swimlaneInstances != null ? this.swimlaneInstances.get(swimlaneName) : null;
    }

    public TaskMgmtDefinition getTaskMgmtDefinition() {
        return this.taskMgmtDefinition;
    }
}

