/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.templates.velocity.impl;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Serializable;
import org.apache.commons.collections.ExtendedProperties;
import org.apache.commons.lang.StringUtils;
import org.apache.velocity.exception.ParseErrorException;
import org.apache.velocity.exception.ResourceNotFoundException;
import org.apache.velocity.runtime.resource.Resource;
import org.apache.velocity.runtime.resource.ResourceFactory;
import org.apache.velocity.runtime.resource.loader.ResourceLoader;
import org.exoplatform.container.xml.PortalContainerInfo;
import org.exoplatform.services.cache.CacheService;
import org.exoplatform.services.cache.ExoCache;
import org.exoplatform.services.templates.velocity.ResourceLoaderPlugin;
import org.exoplatform.services.workflow.WorkflowServiceContainer;
import org.exoplatform.services.workflow.impl.jbpm.WorkflowServiceContainerImpl;
import org.jbpm.db.JbpmSession;
import org.jbpm.db.TaskMgmtSession;
import org.jbpm.file.def.FileDefinition;
import org.jbpm.graph.def.ProcessDefinition;
import org.jbpm.taskmgmt.exe.TaskInstance;

public class PARResourceLoaderImpl
extends ResourceLoaderPlugin {
    protected ExoCache parcache_;
    private WorkflowServiceContainerImpl service_;
    private PortalContainerInfo containerInfo_;

    public PARResourceLoaderImpl(WorkflowServiceContainer workflowService, CacheService cacheService, PortalContainerInfo containerInfo) throws Exception {
        this.parcache_ = cacheService.getCacheInstance(PARResourceLoaderImpl.class.getName());
        this.service_ = (WorkflowServiceContainerImpl)workflowService;
        this.containerInfo_ = containerInfo;
    }

    public void init(ExtendedProperties configuration) {
    }

    public synchronized InputStream getResourceStream(String fileLocation) throws ResourceNotFoundException {
        JbpmSession session = this.service_.openSession();
        TaskMgmtSession taskSession = session.getTaskMgmtSession();
        String[] infos = StringUtils.split((String)fileLocation, (String)":");
        if (infos.length == 2) {
            TaskInstance taskInstance = taskSession.loadTaskInstance(new Long(infos[0]).longValue());
            ProcessDefinition processDef = taskInstance.getTask().getProcessDefinition();
            FileDefinition fD = processDef.getFileDefinition();
            byte[] file = fD.getBytes(infos[1]);
            return new ByteArrayInputStream(file);
        }
        throw new ResourceNotFoundException("Cannot retrieve data in process " + fileLocation + "Make sure you have a valid location");
    }

    public boolean isSourceModified(Resource resource) {
        return false;
    }

    public long getLastModified(Resource resource) {
        return 0L;
    }

    public Resource getResource(String resourceName, int resourceType, String encoding) throws ResourceNotFoundException, ParseErrorException, Exception {
        String portalName = this.containerInfo_.getContainerName();
        String key = portalName + resourceName;
        Resource resource = (Resource)this.parcache_.get((Serializable)((Object)key));
        if (resource != null) {
            return resource;
        }
        String path = resourceName.substring(4, resourceName.length());
        resource = ResourceFactory.getResource((String)path, (int)resourceType);
        resource.setRuntimeServices(this.rsvc);
        resource.setName(path);
        resource.setEncoding(encoding);
        resource.setResourceLoader((ResourceLoader)this);
        resource.process();
        this.parcache_.put((Serializable)((Object)key), (Object)resource);
        return resource;
    }

    public boolean canLoadResource(String s) {
        return s.startsWith("par:");
    }
}

