/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.workflow.impl.jbpm;

import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.RootContainer;
import org.exoplatform.services.workflow.WorkflowFilterService;
import org.exoplatform.services.workflow.WorkflowServiceContainer;
import org.exoplatform.services.workflow.impl.jbpm.WorkflowServiceContainerImpl;
import org.jbpm.security.authenticator.JbpmDefaultAuthenticator;

public class WorkflowFilterServiceImpl
implements WorkflowFilterService {
    private String portalName_;
    private boolean exceptionOccurred;

    public void init(FilterConfig filterConfig) throws ServletException {
        this.portalName_ = filterConfig.getServletContext().getServletContextName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        PortalContainer pcontainer = RootContainer.getInstance().getPortalContainer(this.portalName_);
        WorkflowServiceContainerImpl workflowService = (WorkflowServiceContainerImpl)pcontainer.getComponentInstanceOfType(WorkflowServiceContainer.class);
        String remoteUser = null;
        try {
            remoteUser = ((HttpServletRequest)servletRequest).getRemoteUser();
            if (remoteUser != null) {
                JbpmDefaultAuthenticator.pushAuthenticatedActorId((String)remoteUser);
            }
            filterChain.doFilter(servletRequest, servletResponse);
            this.exceptionOccurred = false;
        }
        finally {
            if (remoteUser != null) {
                JbpmDefaultAuthenticator.popAuthenticatedActorId();
            }
            if (this.exceptionOccurred) {
                workflowService.rollback();
            } else {
                workflowService.closeSession();
            }
        }
    }

    public void destroy() {
    }
}

