/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.workflow.impl.jbpm;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.jar.JarInputStream;
import java.util.zip.ZipInputStream;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.component.ComponentLifecycle;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.database.HibernateService;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.Membership;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.workflow.Process;
import org.exoplatform.services.workflow.ProcessInstance;
import org.exoplatform.services.workflow.ProcessesConfig;
import org.exoplatform.services.workflow.Task;
import org.exoplatform.services.workflow.Timer;
import org.exoplatform.services.workflow.WorkflowFormsService;
import org.exoplatform.services.workflow.WorkflowServiceContainer;
import org.exoplatform.services.workflow.impl.jbpm.ProcessData;
import org.exoplatform.services.workflow.impl.jbpm.ProcessInstanceData;
import org.exoplatform.services.workflow.impl.jbpm.TaskData;
import org.exoplatform.services.workflow.impl.jbpm.TimerData;
import org.hibernate.cfg.Configuration;
import org.jbpm.context.exe.ContextInstance;
import org.jbpm.db.GraphSession;
import org.jbpm.db.JbpmSchema;
import org.jbpm.db.JbpmSession;
import org.jbpm.db.JbpmSessionFactory;
import org.jbpm.graph.def.ProcessDefinition;
import org.jbpm.jpdl.par.ProcessArchiveDeployer;
import org.jbpm.taskmgmt.exe.TaskInstance;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkflowServiceContainerImpl
implements WorkflowServiceContainer,
ComponentLifecycle {
    private ConfigurationManager configurationManager_;
    private ProcessesConfig config_;
    private JbpmSessionFactory sessionFactory_;
    private OrganizationService orgService_;
    private ThreadLocal threadLocal_;
    private String hibernateServiceName_;

    public WorkflowServiceContainerImpl(OrganizationService orgService, ConfigurationManager conf, InitParams params) throws Exception {
        this.hibernateServiceName_ = params.getValueParam("hibernate.service").getValue();
        this.config_ = (ProcessesConfig)params.getObjectParamValues(ProcessesConfig.class).get(0);
        this.configurationManager_ = conf;
        this.threadLocal_ = new ThreadLocal();
        this.orgService_ = orgService;
    }

    public void initComponent(ExoContainer container) throws Exception {
        HibernateService hservice = null;
        hservice = this.hibernateServiceName_ == null || this.hibernateServiceName_.length() == 0 || "default".equals(this.hibernateServiceName_) ? (HibernateService)container.getComponentInstanceOfType(HibernateService.class) : (HibernateService)container.getComponentInstance((Object)this.hibernateServiceName_);
        Configuration hconf = hservice.getHibernateConfiguration();
        this.sessionFactory_ = JbpmSessionFactory.buildJbpmSessionFactory((Configuration)hconf);
        JbpmSchema schema = this.sessionFactory_.getJbpmSchema();
        if (!schema.hasJbpmTables()) {
            schema.createSchema();
        }
        this.init();
    }

    public void startComponent(ExoContainer arg0) throws Exception {
    }

    public void stopComponent(ExoContainer arg0) throws Exception {
    }

    public void destroyComponent(ExoContainer arg0) throws Exception {
    }

    public JbpmSessionFactory getJbpmSessionFactory() {
        return this.sessionFactory_;
    }

    public JbpmSession openSession() {
        JbpmSession currentSession = (JbpmSession)this.threadLocal_.get();
        if (currentSession == null) {
            currentSession = this.sessionFactory_.openJbpmSessionAndBeginTransaction();
            this.threadLocal_.set(currentSession);
        }
        return currentSession;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() {
        JbpmSession session = this.openSession();
        try {
            if (!session.getGraphSession().findAllProcessDefinitions().isEmpty()) {
                return;
            }
            HashSet predefinedProcesses = this.config_.getPredefinedProcess();
            String processLoc = this.config_.getProcessLocation();
            for (String parFile : predefinedProcesses) {
                try {
                    InputStream iS = this.configurationManager_.getInputStream(processLoc + parFile);
                    ProcessArchiveDeployer.deployZipInputStream((ZipInputStream)new ZipInputStream(iS), (JbpmSessionFactory)this.sessionFactory_);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        finally {
            this.closeSession();
        }
    }

    public void closeSession(JbpmSession session) {
        if (session == null) {
            return;
        }
        try {
            session.commitTransactionAndClose();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.threadLocal_.set(null);
    }

    public void closeSession() {
        JbpmSession s = (JbpmSession)this.threadLocal_.get();
        if (s != null) {
            s.commitTransactionAndClose();
        }
        this.threadLocal_.set(null);
    }

    public void rollback() {
        JbpmSession s = (JbpmSession)this.threadLocal_.get();
        if (s != null) {
            s.rollbackTransactionAndClose();
        }
        this.threadLocal_.set(null);
    }

    public void rollback(JbpmSession session) {
        if (session == null) {
            return;
        }
        try {
            session.rollbackTransactionAndClose();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.threadLocal_.set(null);
    }

    public List<Task> getAllTasks(String user) throws Exception {
        ArrayList<Task> allTasks = new ArrayList<Task>();
        allTasks.addAll(this.getUserTaskList(user));
        allTasks.addAll(this.getGroupTaskList(user));
        return allTasks;
    }

    public List<Task> getUserTaskList(String user) {
        JbpmSession session = this.openSession();
        List taskInstances = session.getTaskMgmtSession().findTaskInstances(user);
        return WorkflowServiceContainerImpl.wrapTasks(taskInstances);
    }

    public List<Task> getGroupTaskList(String user) throws Exception {
        ArrayList<Task> groupTasks = new ArrayList<Task>();
        String key = null;
        Collection groups = this.orgService_.getGroupHandler().findGroupsOfUser(user);
        JbpmSession session = this.openSession();
        for (Group group : groups) {
            Collection memberships = this.orgService_.getMembershipHandler().findMembershipsByUserAndGroup(user, group.getId());
            for (Membership membership : memberships) {
                key = membership.getMembershipType() + ":" + group.getId();
                List tasks = session.getTaskMgmtSession().findTaskInstances(key);
                if (tasks.size() <= 0) continue;
                groupTasks.addAll(WorkflowServiceContainerImpl.wrapTasks(tasks));
            }
            key = "*:" + group.getId();
            List tasks = session.getTaskMgmtSession().findTaskInstances(key);
            if (tasks.size() <= 0) continue;
            groupTasks.addAll(WorkflowServiceContainerImpl.wrapTasks(tasks));
        }
        return groupTasks;
    }

    private static List<Task> wrapTasks(List tasks) {
        ArrayList<Task> wrappedTokens = new ArrayList<Task>();
        for (TaskInstance task : tasks) {
            wrappedTokens.add(new TaskData(task));
        }
        return wrappedTokens;
    }

    public List<Process> getProcesses() {
        ArrayList<Process> processes = new ArrayList<Process>();
        JbpmSession session = this.openSession();
        List definitions = session.getGraphSession().findAllProcessDefinitions();
        for (ProcessDefinition def : definitions) {
            processes.add(new ProcessData(def));
        }
        return processes;
    }

    public boolean hasStartTask(String processId) {
        JbpmSession session = this.openSession();
        ProcessDefinition processDef = session.getGraphSession().loadProcessDefinition(Long.parseLong(processId));
        return processDef.getTaskMgmtDefinition().getStartTask() != null;
    }

    public void startProcess(String processId) {
        JbpmSession session = this.openSession();
        ProcessDefinition processDef = session.getGraphSession().loadProcessDefinition(Long.parseLong(processId));
        org.jbpm.graph.exe.ProcessInstance processInstance = new org.jbpm.graph.exe.ProcessInstance(processDef);
        processInstance.signal();
        session.getGraphSession().saveProcessInstance(processInstance);
    }

    public void startProcess(String remoteUser, String processId, Map variables) {
        JbpmSession session = this.openSession();
        GraphSession graphSession = session.getGraphSession();
        ProcessDefinition processDef = graphSession.loadProcessDefinition(Long.parseLong(processId));
        org.jbpm.graph.exe.ProcessInstance instance = new org.jbpm.graph.exe.ProcessInstance(processDef);
        ContextInstance contextInstance = instance.getContextInstance();
        variables.put("initiator", remoteUser);
        contextInstance.addVariables(variables);
        TaskInstance taskInstance = instance.getTaskMgmtInstance().createStartTaskInstance();
        taskInstance.setActorId(remoteUser);
        taskInstance.end();
        graphSession.saveProcessInstance(instance);
    }

    public void startProcessFromName(String remoteUser, String processName, Map variables) {
        JbpmSession session = this.openSession();
        GraphSession graphSession = session.getGraphSession();
        ProcessDefinition processDef = graphSession.findLatestProcessDefinition(processName);
        org.jbpm.graph.exe.ProcessInstance instance = new org.jbpm.graph.exe.ProcessInstance(processDef);
        ContextInstance contextInstance = instance.getContextInstance();
        contextInstance.addVariables(variables);
        TaskInstance taskInstance = instance.getTaskMgmtInstance().createStartTaskInstance();
        taskInstance.setActorId(remoteUser);
        taskInstance.end();
        graphSession.saveProcessInstance(instance);
    }

    public List<ProcessInstance> getProcessInstances(String processId) {
        ArrayList<ProcessInstance> processInstances = new ArrayList<ProcessInstance>();
        JbpmSession session = this.openSession();
        List jbpmProcessInstances = session.getGraphSession().findProcessInstances(new Long(processId).longValue());
        for (org.jbpm.graph.exe.ProcessInstance processInstance : jbpmProcessInstances) {
            processInstances.add(new ProcessInstanceData(processInstance));
        }
        return processInstances;
    }

    public List<Task> getTasks(String processInstanceId) {
        ArrayList<Task> tasks = new ArrayList<Task>();
        JbpmSession session = this.openSession();
        org.jbpm.graph.exe.ProcessInstance processInstance = session.getGraphSession().loadProcessInstance(new Long(processInstanceId).longValue());
        Collection taskInstances = processInstance.getTaskMgmtInstance().getTaskInstances();
        for (TaskInstance task : taskInstances) {
            tasks.add(new TaskData(task));
        }
        return tasks;
    }

    public Process getProcess(String processId) {
        JbpmSession session = this.openSession();
        ProcessDefinition processDef = session.getGraphSession().loadProcessDefinition(Long.parseLong(processId));
        return new ProcessData(processDef);
    }

    public Task getTask(String taskId) {
        JbpmSession session = this.openSession();
        TaskInstance task = session.getTaskMgmtSession().loadTaskInstance(Long.parseLong(taskId));
        return new TaskData(task);
    }

    public ProcessInstance getProcessInstance(String processInstance) {
        JbpmSession session = this.openSession();
        org.jbpm.graph.exe.ProcessInstance jbpmProcessInstance = session.getGraphSession().loadProcessInstance(Long.parseLong(processInstance));
        return new ProcessInstanceData(jbpmProcessInstance);
    }

    public Map getVariables(String processInstanceId, String taskId) {
        JbpmSession session = this.openSession();
        org.jbpm.graph.exe.ProcessInstance jbpmProcessInstance = session.getGraphSession().loadProcessInstance(Long.parseLong(processInstanceId));
        return jbpmProcessInstance.getContextInstance().getVariables();
    }

    public void endTask(String taskId, Map variables) {
        JbpmSession session = this.openSession();
        TaskInstance taskInstance = session.getTaskMgmtSession().loadTaskInstance(Long.parseLong(taskId));
        org.jbpm.graph.exe.ProcessInstance processInstance = taskInstance.getToken().getProcessInstance();
        ContextInstance contextInstance = processInstance.getContextInstance();
        contextInstance.addVariables(variables);
        taskInstance.end();
        session.getGraphSession().saveProcessInstance(processInstance);
    }

    public void endTask(String taskId, Map variables, String transition) {
        JbpmSession session = this.openSession();
        TaskInstance taskInstance = session.getTaskMgmtSession().loadTaskInstance(Long.parseLong(taskId));
        org.jbpm.graph.exe.ProcessInstance processInstance = taskInstance.getToken().getProcessInstance();
        ContextInstance contextInstance = processInstance.getContextInstance();
        contextInstance.addVariables(variables);
        taskInstance.end(transition);
        session.getGraphSession().saveProcessInstance(processInstance);
    }

    public List<Timer> getTimers() {
        ArrayList<Timer> timers = new ArrayList<Timer>();
        JbpmSession session = this.openSession();
        Iterator jbpmTimers = session.getSchedulerSession().findTimersByDueDate();
        while (jbpmTimers.hasNext()) {
            org.jbpm.scheduler.exe.Timer jbpmTimer = (org.jbpm.scheduler.exe.Timer)jbpmTimers.next();
            timers.add(new TimerData(jbpmTimer));
        }
        return timers;
    }

    public void deployProcess(InputStream iS) throws IOException {
        JbpmSession session = this.openSession();
        session.getContextSession();
        ProcessArchiveDeployer.deployZipInputStream((ZipInputStream)new JarInputStream(iS), (JbpmSessionFactory)session.getJbpmSessionFactory());
    }

    public void deleteProcess(String processId) {
        JbpmSession session = this.openSession();
        session.getGraphSession().deleteProcessDefinition(Long.parseLong(processId));
        WorkflowFormsService formsService = (WorkflowFormsService)PortalContainer.getInstance().getComponentInstanceOfType(WorkflowFormsService.class);
        formsService.removeForms(processId);
    }

    public void deleteProcessInstance(String processInstanceId) {
        JbpmSession session = this.openSession();
        session.getGraphSession().deleteProcessInstance(Long.parseLong(processInstanceId));
    }
}

