/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.applications.ooplugin;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.HashMap;
import org.exoplatform.applications.ooplugin.LocalFileSystem;
import org.exoplatform.applications.ooplugin.Log;
import org.exoplatform.frameworks.webdavclient.WebDavContext;

public class WebDavConfig {
    public static final String WHOST = "Host";
    public static final String WPORT = "Port";
    public static final String WSERVLET = "Servlet";
    public static final String WWORKSPACE = "WorkSpace";
    public static final String WUSER = "User";
    public static final String WPASS = "Pass";
    private String host = "localhost";
    private int port = 8080;
    private String servlet = "/jcr-webdav/repository";
    private String workSpace = "production";
    private String user_id = "admin";
    private String user_pass = "admin";
    private String configFileName = LocalFileSystem.getDocumentsPath() + File.separatorChar + "exoplugin.config";

    public WebDavConfig() {
        this.loadConfig();
    }

    public WebDavContext getContext() {
        return new WebDavContext(this.host, this.port, this.servlet + "/" + this.workSpace, this.user_id, this.user_pass);
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getServlet() {
        return this.servlet;
    }

    public void setServlet(String servlet) {
        this.servlet = servlet;
    }

    public String getWorkSpace() {
        return this.workSpace;
    }

    public void setWorkSpace(String workSpace) {
        this.workSpace = workSpace;
    }

    public String getUserId() {
        return this.user_id;
    }

    public void setUserId(String user_id) {
        this.user_id = user_id;
    }

    public String getUserPass() {
        return this.user_pass;
    }

    public void setUserPath(String user_pass) {
        this.user_pass = user_pass;
    }

    public void saveConfig() throws Exception {
        String outParams = "Host=" + this.host + "\r\n";
        outParams = outParams + "Port=" + this.port + "\r\n";
        outParams = outParams + "Servlet=" + this.servlet + "\r\n";
        outParams = outParams + "WorkSpace=" + this.workSpace + "\r\n";
        outParams = outParams + "User=" + this.user_id + "\r\n";
        outParams = outParams + "Pass=" + this.user_pass + "\r\n";
        File outConfigFile = new File(this.configFileName);
        outConfigFile.createNewFile();
        FileOutputStream outStream = new FileOutputStream(outConfigFile);
        outStream.write(outParams.getBytes());
        outStream.close();
    }

    public void loadConfig() {
        try {
            File configFile = new File(this.configFileName);
            if (!configFile.exists()) {
                Log.info("Config file not exist!!!!!! USE DEFAULT@@@@");
                return;
            }
            FileInputStream inStream = new FileInputStream(configFile);
            byte[] data = new byte[inStream.available()];
            inStream.read(data);
            String confParams = new String(data);
            String[] params = confParams.split("\r\n");
            HashMap<String, String> hParams = new HashMap<String, String>();
            for (int i = 0; i < params.length; ++i) {
                String[] curParams = params[i].split("=");
                hParams.put(curParams[0], curParams[1]);
            }
            this.host = (String)hParams.get(WHOST);
            this.port = new Integer((String)hParams.get(WPORT));
            this.servlet = (String)hParams.get(WSERVLET);
            this.workSpace = (String)hParams.get(WWORKSPACE);
            this.user_id = (String)hParams.get(WUSER);
            this.user_pass = (String)hParams.get(WPASS);
        }
        catch (Exception exc) {
            Log.info("Unhandled exception. " + exc.getMessage(), exc);
        }
    }
}

