/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.frameworks.webdavclient;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.Socket;
import java.util.ArrayList;
import org.exoplatform.frameworks.webdavclient.Log;
import org.exoplatform.frameworks.webdavclient.TextUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpClient {
    private boolean enableTrace = false;
    private String server = "";
    private int port = 0;
    private Socket clientSocket = null;
    private PrintStream outPrintStream = null;
    private OutputStream outStream = null;
    private InputStream inputStream = null;
    private String httpCommand = "GET";
    private String httpRequestStr = "";
    private ArrayList requestHeaders = new ArrayList();
    private String httpRequestBodyStr;
    private byte[] httpRequestBodyBytes;
    private InputStream httpRequestBodyStream;
    private String mainHeader = "";
    private ArrayList responseHeaders = new ArrayList();
    private byte[] contentBytes = null;

    public void EnableTrace() {
        this.enableTrace = true;
    }

    public void a() {
    }

    public HttpClient(String server, int port) {
        this.server = server;
        this.port = port;
    }

    public void conect() throws Exception {
        this.clientSocket = new Socket(this.server, this.port);
        this.outStream = this.clientSocket.getOutputStream();
        this.outPrintStream = new PrintStream(this.clientSocket.getOutputStream());
        this.inputStream = this.clientSocket.getInputStream();
    }

    public void setHttpCommand(String httpCommand) {
        this.httpCommand = httpCommand;
    }

    public void setRequestPath(String httpRequestStr) {
        this.httpRequestStr = httpRequestStr;
    }

    public void setRequestHeader(String headerName, String headerValue) throws Exception {
        int existedIndex = -1;
        for (int i = 0; i < this.requestHeaders.size(); ++i) {
            String curHeader = (String)this.requestHeaders.get(i);
            String[] curHeaderValues = curHeader.split(": ");
            if (!curHeaderValues[0].toUpperCase().equals(headerName.toUpperCase())) continue;
            existedIndex = i;
            break;
        }
        if (existedIndex >= 0) {
            this.requestHeaders.remove(existedIndex);
        }
        String newHeader = headerName + ": " + headerValue;
        Log.info("Set header: [" + newHeader + "]");
        this.requestHeaders.add(newHeader);
    }

    public void setRequestBody(String httpRequestBodyStr) {
        this.httpRequestBodyStr = httpRequestBodyStr;
    }

    public void setRequestBody(byte[] httpRequestBodyBytes) {
        this.httpRequestBodyBytes = httpRequestBodyBytes;
    }

    public void setRequestStream(InputStream httpRequestBodyStream) {
        this.httpRequestBodyStream = httpRequestBodyStream;
    }

    public void zeroRequestBody() {
        this.httpRequestBodyStr = null;
    }

    public void sendRequest(String request) {
        this.outPrintStream.print(request);
    }

    public String getMainHeader() {
        return this.mainHeader;
    }

    public int getContentLength() throws Exception {
        for (int i = 0; i < this.responseHeaders.size(); ++i) {
            String curHeader = (String)this.responseHeaders.get(i);
            if (!curHeader.startsWith("Content-Length")) continue;
            String[] params = curHeader.split(":");
            String lenValue = params[1];
            lenValue = lenValue.trim();
            return new Integer(lenValue);
        }
        return 0;
    }

    public ArrayList<String> getResponseHeadersNames() {
        ArrayList<String> result = new ArrayList<String>();
        for (int i = 0; i < this.responseHeaders.size(); ++i) {
            String curHeader = (String)this.responseHeaders.get(i);
            result.add(curHeader.split(":")[0]);
        }
        return result;
    }

    public String getResponseHeader(String headerName) {
        for (int i = 0; i < this.responseHeaders.size(); ++i) {
            String curHeader = (String)this.responseHeaders.get(i);
            if (!curHeader.startsWith(headerName + ": ")) continue;
            return curHeader.substring(curHeader.indexOf(": ") + 2);
        }
        return "";
    }

    public int getReplyCode() throws Exception {
        int replyCode = 0;
        String[] mPathes = this.mainHeader.split(" ");
        replyCode = new Integer(mPathes[1]);
        return replyCode;
    }

    public String getResponseBody() {
        String contentString = "";
        for (int i = 0; i < this.contentBytes.length; ++i) {
            contentString = contentString + (char)this.contentBytes[i];
        }
        return contentString;
    }

    public byte[] getResponseBytes() {
        return this.contentBytes;
    }

    public InputStream getResponseStream() {
        return new ByteArrayInputStream(this.contentBytes);
    }

    public int execute() throws Exception {
        ByteArrayOutputStream outStream;
        block22: {
            String nextHeader;
            block21: {
                String escapedHttpPath = TextUtils.Escape(this.httpRequestStr, '%', true);
                String httpLine = this.httpCommand + " " + escapedHttpPath + " " + "HTTP/1.1";
                this.outPrintStream.println(httpLine);
                if (this.enableTrace) {
                    Log.info(httpLine);
                }
                long reqContLength = 0L;
                if (this.httpRequestBodyStream == null) {
                    if (this.httpRequestBodyStr != null) {
                        reqContLength = this.httpRequestBodyStr.length();
                    } else if (this.httpRequestBodyBytes != null) {
                        reqContLength = this.httpRequestBodyBytes.length;
                    }
                    this.setRequestHeader("Content-Length", "" + reqContLength);
                }
                this.setRequestHeader("Host", String.format("%s:%s", this.server, this.port));
                this.setRequestHeader("User-Agent", "Exo-Http Client v.1.0.beta.");
                for (int i = 0; i < this.requestHeaders.size(); ++i) {
                    String curHeader = (String)this.requestHeaders.get(i);
                    this.outPrintStream.println(curHeader);
                    if (!this.enableTrace) continue;
                    Log.info(curHeader);
                }
                this.outPrintStream.println();
                if (this.httpRequestBodyStream != null) {
                    byte[] buff = new byte[4096];
                    long readData = 0L;
                    while (true) {
                        int readed = this.httpRequestBodyStream.read(buff);
                        readData += (long)readed;
                        if (readed < 0) {
                            Log.info("OOOOOOO: " + readData);
                            break block21;
                        }
                        this.outStream.write(buff, 0, readed);
                    }
                }
                if (reqContLength != 0L) {
                    if (this.httpRequestBodyStr != null) {
                        this.outPrintStream.print(this.httpRequestBodyStr);
                    } else {
                        this.outStream.write(this.httpRequestBodyBytes);
                    }
                }
            }
            this.mainHeader = this.readLine();
            while (!(nextHeader = this.readLine()).equals("")) {
                this.responseHeaders.add(nextHeader);
            }
            outStream = new ByteArrayOutputStream();
            try {
                int readed;
                int contentLength = this.getContentLength();
                if (contentLength == 0 || "HEAD".equals(this.httpCommand)) break block22;
                byte[] buffer = new byte[16384];
                for (int received = 0; received < contentLength; received += readed) {
                    int needToRead = buffer.length;
                    if (needToRead > contentLength - received) {
                        needToRead = contentLength - received;
                    }
                    if ((readed = this.inputStream.read(buffer, 0, needToRead)) >= 0) {
                        if (readed == 0) {
                            Thread.sleep(100L);
                        }
                        outStream.write(buffer, 0, readed);
                        continue;
                    }
                    break;
                }
            }
            catch (Exception exc) {
                Log.info("Unhandled exception. " + exc.getMessage(), exc);
            }
        }
        this.contentBytes = outStream.toByteArray();
        try {
            this.clientSocket.close();
        }
        catch (Exception exc) {
            // empty catch block
        }
        return this.getReplyCode();
    }

    protected String readLine() throws Exception {
        byte[] buffer = new byte[4096];
        int bufPos = 0;
        int prevByte = 0;
        int received;
        while ((received = this.inputStream.read()) >= 0) {
            buffer[bufPos] = (byte)received;
            ++bufPos;
            if (prevByte == 13 && received == 10) {
                String resultLine = "";
                for (int i = 0; i < bufPos - 2; ++i) {
                    resultLine = resultLine + (char)buffer[i];
                }
                return resultLine;
            }
            prevByte = (byte)received;
        }
        return null;
    }
}

