/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.frameworks.webdavclient.commands;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.codec.binary.Base64;
import org.exoplatform.frameworks.webdavclient.HttpClient;
import org.exoplatform.frameworks.webdavclient.Log;
import org.exoplatform.frameworks.webdavclient.WebDavContext;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.ls.LSOutput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DavCommand {
    public static final String AUTH_BASIC = "Basic";
    protected String commandName;
    protected WebDavContext context = null;
    protected String resourcePath;
    protected int depth = 1;
    private int rangeStart = -1;
    private int rangeEnd = -1;
    protected HttpClient client;
    protected byte[] requestDataBytes = null;
    protected InputStream inStream = null;
    protected byte[] responseDataBytes = null;
    private boolean enableXml = true;

    public DavCommand(WebDavContext context) throws Exception {
        this.context = context;
        this.client = new HttpClient(context.getHost(), context.getPort());
        this.client.setRequestHeader("Connection", "TE");
        this.client.setRequestHeader("TE", "trailers, deflate, gzip, compress");
        this.client.setRequestHeader("Depth", "1");
        this.client.setRequestHeader("Translate", "f");
        this.client.setRequestHeader("Accept-Encoding", "deflate, gzip, x-gzip, compress, x-compress");
    }

    public void setResourcePath(String resourcePath) {
        this.resourcePath = resourcePath;
    }

    public void setDepth(int depth) {
        this.depth = depth;
    }

    public void setRange(int rangeStart) {
        this.rangeStart = rangeStart;
    }

    public void setRange(int rangeStart, int rangeEnd) {
        this.rangeStart = rangeStart;
        this.rangeEnd = rangeEnd;
    }

    public void setRequestDataBuffer(byte[] requestDataBytes) {
        this.requestDataBytes = requestDataBytes;
    }

    public void setRequestInputStream(InputStream inStream, long streamLength) throws Exception {
        this.inStream = inStream;
        this.client.setRequestHeader("Content-Length", "" + streamLength);
    }

    public void setXmlEnabled(boolean enableXml) {
        this.enableXml = enableXml;
    }

    public void setLockToken(String lockToken) throws Exception {
        this.client.setRequestHeader("Lock-Token", "<" + lockToken + ">");
    }

    public String getResponseHeader(String headerName) {
        return this.client.getResponseHeader(headerName);
    }

    public ArrayList<String> getResponseHeadersNames() {
        return this.client.getResponseHeadersNames();
    }

    public byte[] getResponseDataBuffer() {
        return this.client.getResponseBytes();
    }

    private static Document getDomDocument() throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        return builder.newDocument();
    }

    public int execute() throws Exception {
        Document xmlDocument;
        Element rootElement;
        if (this.enableXml && (rootElement = this.toXml(xmlDocument = DavCommand.getDomDocument())) != null) {
            this.serializeElement(rootElement);
        }
        if (this.inStream != null) {
            this.client.setRequestStream(this.inStream);
        } else if (this.requestDataBytes != null) {
            this.client.setRequestBody(this.requestDataBytes);
        }
        this.client.setHttpCommand(this.commandName);
        String path = this.context.getServletPath();
        if (this.resourcePath != null) {
            path = path + this.resourcePath;
        }
        this.client.setRequestPath(path);
        if (this.context.getUserId() != null) {
            String userId = this.context.getUserId();
            String userPass = this.context.getUserPass();
            byte[] encoded = Base64.encodeBase64(new String(userId + ":" + userPass).getBytes());
            String encodedAuth = new String(encoded);
            this.client.setRequestHeader("Authorization", "Basic " + encodedAuth);
        }
        this.client.setRequestHeader("Depth", String.format("%d", this.depth));
        if (this.rangeStart >= 0) {
            String rangeHeader = "bytes=" + this.rangeStart + "-";
            if (this.rangeEnd >= 0) {
                rangeHeader = rangeHeader + this.rangeEnd;
            }
            this.client.setRequestHeader("Range", rangeHeader);
        }
        this.client.conect();
        int status = this.client.execute();
        this.finalExecute();
        return status;
    }

    public abstract void finalExecute();

    public abstract Element toXml(Document var1);

    private void serializeElement(Element element) throws Exception {
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        DOMSource source = new DOMSource(element.getOwnerDocument());
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        StreamResult resultStream = new StreamResult(outStream);
        transformer.transform(source, resultStream);
        this.requestDataBytes = outStream.toByteArray();
        Log.info("REQUEST:\r\n" + new String(this.requestDataBytes));
    }

    static class Output
    implements LSOutput {
        OutputStream bs = null;
        Writer cs = null;
        String sId = null;
        String enc = "UTF-8";

        public OutputStream getByteStream() {
            return this.bs;
        }

        public void setByteStream(OutputStream byteStream) {
            this.bs = byteStream;
        }

        public Writer getCharacterStream() {
            return this.cs;
        }

        public void setCharacterStream(Writer characterStream) {
            this.cs = characterStream;
        }

        public String getSystemId() {
            return this.sId;
        }

        public void setSystemId(String systemId) {
            this.sId = systemId;
        }

        public String getEncoding() {
            return this.enc;
        }

        public void setEncoding(String encoding) {
            this.enc = encoding;
        }
    }
}

