/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.frameworks.webdavclient.commands;

import org.exoplatform.frameworks.webdavclient.Log;
import org.exoplatform.frameworks.webdavclient.WebDavContext;
import org.exoplatform.frameworks.webdavclient.commands.DavCommand;
import org.exoplatform.frameworks.webdavclient.documents.DocumentApi;
import org.exoplatform.frameworks.webdavclient.documents.DocumentManager;
import org.exoplatform.frameworks.webdavclient.documents.Multistatus;
import org.exoplatform.frameworks.webdavclient.request.PropertyList;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class MultistatusCommand
extends DavCommand {
    protected PropertyList propList = new PropertyList();
    protected String xmlName = "propfind";
    protected DocumentApi multistatusDocument = null;

    public MultistatusCommand(WebDavContext context) throws Exception {
        super(context);
    }

    public void requireAllProperties() {
        this.propList.clearProperies();
    }

    public void setRequiredProperty(String propertyName) {
        this.propList.setProperty(propertyName);
    }

    public Element toXml(Document xmlDocument) {
        Element propFindEl = xmlDocument.createElementNS("DAV:", "A:" + this.xmlName);
        xmlDocument.appendChild(propFindEl);
        propFindEl.appendChild(this.propList.toXml(xmlDocument));
        return propFindEl;
    }

    public void finalExecute() {
        try {
            if (this.client.getReplyCode() != 207) {
                return;
            }
        }
        catch (Exception exc) {
            Log.info("Unhandled exception. " + exc.getMessage(), exc);
        }
        this.multistatusDocument = DocumentManager.getResponseDocument(this.client.getResponseStream());
    }

    public Multistatus getMultistatus() {
        return (Multistatus)this.multistatusDocument;
    }
}

