/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.frameworks.jcr.cli;

import java.util.Iterator;
import java.util.Set;
import java.util.TreeMap;
import org.exoplatform.frameworks.jcr.cli.AbstractCliCommand;
import org.exoplatform.frameworks.jcr.cli.CliAppContext;

public class HelpCommand
extends AbstractCliCommand {
    private TreeMap<String, String> map = new TreeMap();
    private final int WORD_LENGTH = 15;

    public HelpCommand() {
        this.map.put("addnode", "<name>, <type> add node as child node of current node");
        this.map.put("mkdir", "<name>, <type> add node as child node of current node");
        this.map.put("login", "<workspace name> login to workspace");
        this.map.put("getitem", "<absPath> or <relPath> or <..> change the current item");
        this.map.put("cd", "<absPath> or <relPath> or < ..> change the current item, node names should not contain spaces");
        this.map.put("getnode", "<relPath> change the current node");
        this.map.put("cdn", "<relPath> change the current node");
        this.map.put("getproperty", "<relPath> change the current property");
        this.map.put("cdp", "<relPath> change the current property");
        this.map.put("getnodes", "<> get the list of nodes");
        this.map.put("lsn", "<> get the list of nodes");
        this.map.put("getproperties", "<> get the list of properties");
        this.map.put("lsp", "<> get the list of properties");
        this.map.put("ls", "<> get the list of the nodes and properties");
        this.map.put("setproperty", "<name>, <value>, <type> set the property");
        this.map.put("setp", "<name>, <value>, <type> set the property");
        this.map.put("getcontextinfo", "<> show the info of the current context");
        this.map.put("info", "<> show the info of the current context");
        this.map.put("remove", "<> remove the current item and go to parent item");
        this.map.put("rem", "<> remove the current item and go to parent item");
        this.map.put("copynode", "<srcAbsPath>, <destAbsPath> copy the node at srcAbsPath to the new location at destAbsPath");
        this.map.put("copy", "<srcAbsPath>, <destAbsPath> copy the node at srcAbsPath to the new location at destAbsPath");
        this.map.put("movenode", "<srcAbsPath>, <destAbsPath> move the node at srcAbsPath to the new location at destAbsPath");
        this.map.put("move", "<srcAbsPath>, <destAbsPath> move the node at srcAbsPath to the new location at destAbsPath");
        this.map.put("|", "<console size> limit the count of lines to output, e.g. |20 will displayed only 20 lines");
    }

    public boolean perform(CliAppContext ctx) {
        String output = "";
        try {
            String findHelpCommand = null;
            try {
                findHelpCommand = ctx.getParameter(0);
            }
            catch (Exception e) {
                // empty catch block
            }
            if (findHelpCommand != null) {
                Set<String> keys = this.map.keySet();
                Iterator<String> iterator = keys.iterator();
                boolean found = false;
                while (iterator.hasNext()) {
                    String currentHelpCommand = iterator.next();
                    if (!findHelpCommand.equals(currentHelpCommand)) continue;
                    String findHelpCommandFormatted = currentHelpCommand;
                    int commandLength = currentHelpCommand.length();
                    if (commandLength < 15) {
                        for (int i = currentHelpCommand.length(); i < 15; ++i) {
                            findHelpCommandFormatted = findHelpCommandFormatted + " ";
                        }
                    }
                    output = output + findHelpCommandFormatted + " - " + this.map.get(findHelpCommand) + "\n";
                    found = true;
                    break;
                }
                if (!found) {
                    output = output + "Can't find help for the: " + findHelpCommand + " command\n";
                }
            } else {
                Set<String> keys = this.map.keySet();
                Iterator<String> iterator = keys.iterator();
                while (iterator.hasNext()) {
                    String currentHelpCommand;
                    String currentHelpCommandFormatted = currentHelpCommand = iterator.next();
                    int commandLength = currentHelpCommand.length();
                    if (commandLength < 15) {
                        for (int i = currentHelpCommand.length(); i < 15; ++i) {
                            currentHelpCommandFormatted = currentHelpCommandFormatted + " ";
                        }
                    }
                    output = output + currentHelpCommandFormatted + " - " + this.map.get(currentHelpCommand) + "\n";
                }
            }
        }
        catch (Exception e) {
            output = "Can't execute command - " + e.getMessage() + "\n";
        }
        ctx.setOutput(output);
        return false;
    }
}

