/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.frameworks.davclient.commands;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.logging.Log;
import org.exoplatform.frameworks.davclient.HttpClient;
import org.exoplatform.frameworks.davclient.ServerLocation;
import org.exoplatform.services.log.ExoLogger;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSOutput;
import org.w3c.dom.ls.LSSerializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DavCommand {
    private static Log log = ExoLogger.getLogger((String)"jcr.DavCommand");
    public static final String AUTH_BASIC = "Basic";
    protected Document xmlDoc = null;
    protected String commandName;
    protected ServerLocation location = null;
    protected String resourcePath;
    protected int depth = 1;
    private int rangeStart = -1;
    private int rangeEnd = -1;
    protected HttpClient client;
    protected byte[] requestDataBytes = null;
    protected byte[] responseDataBytes = null;
    private boolean enableXml = true;

    public DavCommand(ServerLocation location) throws Exception {
        this.location = location;
        this.client = new HttpClient(location.getHost(), location.getPort());
        this.client.setRequestHeader("Connection", "TE");
        this.client.setRequestHeader("TE", "trailers, deflate, gzip, compress");
        this.client.setRequestHeader("Depth", "1");
        this.client.setRequestHeader("Translate", "f");
        this.client.setRequestHeader("Accept-Encoding", "deflate, gzip, x-gzip, compress, x-compress");
    }

    public void setResourcePath(String resourcePath) {
        this.resourcePath = resourcePath;
    }

    public void setDepth(int depth) {
        this.depth = depth;
    }

    public void setRange(int rangeStart) {
        this.rangeStart = rangeStart;
    }

    public void setRange(int rangeStart, int rangeEnd) {
        this.rangeStart = rangeStart;
        this.rangeEnd = rangeEnd;
    }

    public void setRequestDataBuffer(byte[] requestDataBytes) {
        this.requestDataBytes = requestDataBytes;
    }

    public void setXmlEnabled(boolean enableXml) {
        this.enableXml = enableXml;
    }

    public void setLockToken(String lockToken) throws Exception {
        this.client.setRequestHeader("Lock-Token", "<" + lockToken + ">");
    }

    public String getResponseHeader(String headerName) {
        return this.client.getResponseHeader(headerName);
    }

    public ArrayList<String> getResponseHeadersNames() {
        return this.client.getResponseHeadersNames();
    }

    public byte[] getResponseDataBuffer() {
        return this.client.getResponseBytes();
    }

    public int execute() throws Exception {
        if (this.enableXml) {
            this.xmlDoc = this.toXml(DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument());
            if (this.xmlDoc != null) {
                this.serializeXml(this.xmlDoc);
            }
        }
        if (this.requestDataBytes != null) {
            this.client.setRequestBody(this.requestDataBytes);
        }
        this.client.setHttpCommand(this.commandName);
        String path = this.location.getServletPath();
        if (this.resourcePath != null) {
            path = path + this.resourcePath;
        }
        this.client.setRequestPath(path);
        if (this.location.getUserId() != null) {
            String userId = this.location.getUserId();
            String userPass = this.location.getUserPass();
            byte[] encoded = Base64.encodeBase64((byte[])new String(userId + ":" + userPass).getBytes());
            String encodedAuth = new String(encoded);
            this.client.setRequestHeader("Authorization", "Basic " + encodedAuth);
        }
        this.client.setRequestHeader("Depth", String.format("%d", this.depth));
        if (this.rangeStart >= 0) {
            String rangeHeader = "bytes=" + this.rangeStart + "-";
            if (this.rangeEnd >= 0) {
                rangeHeader = rangeHeader + this.rangeEnd;
            }
            this.client.setRequestHeader("Range", rangeHeader);
        }
        this.client.conect();
        int status = this.client.execute();
        this.finalExecute();
        return status;
    }

    public abstract void finalExecute();

    public abstract Document toXml(Document var1);

    public void serializeXml(Document xmlDocument) throws Exception {
        DOMImplementation impl = xmlDocument.getImplementation();
        DOMImplementationLS implLS = (DOMImplementationLS)impl.getFeature("LS", "3.0");
        LSSerializer writer = implLS.createLSSerializer();
        Output out = new Output();
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        out.setByteStream(outStream);
        writer.write(xmlDocument, out);
        this.requestDataBytes = outStream.toByteArray();
    }

    static class Output
    implements LSOutput {
        OutputStream bs = null;
        Writer cs = null;
        String sId = null;
        String enc = "UTF-8";

        public OutputStream getByteStream() {
            return this.bs;
        }

        public void setByteStream(OutputStream byteStream) {
            this.bs = byteStream;
        }

        public Writer getCharacterStream() {
            return this.cs;
        }

        public void setCharacterStream(Writer characterStream) {
            this.cs = characterStream;
        }

        public String getSystemId() {
            return this.sId;
        }

        public void setSystemId(String systemId) {
            this.sId = systemId;
        }

        public String getEncoding() {
            return this.enc;
        }

        public void setEncoding(String encoding) {
            this.enc = encoding;
        }
    }
}

