/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.frameworks.davclient.commands;

import org.apache.commons.logging.Log;
import org.exoplatform.frameworks.davclient.ServerLocation;
import org.exoplatform.frameworks.davclient.commands.DavCommand;
import org.exoplatform.frameworks.davclient.documents.DocumentApi;
import org.exoplatform.frameworks.davclient.documents.DocumentManager;
import org.exoplatform.frameworks.davclient.documents.PropDoc;
import org.exoplatform.frameworks.davclient.properties.LockDiscoveryProp;
import org.exoplatform.frameworks.davclient.properties.PropApi;
import org.exoplatform.services.log.ExoLogger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DavLock
extends DavCommand {
    private static Log log = ExoLogger.getLogger((String)"jcr.DavLock");
    protected DocumentApi propDocument = null;
    protected String lockToken = "";

    public DavLock(ServerLocation location) throws Exception {
        super(location);
        this.commandName = "LOCK";
    }

    public void finalExecute() {
        try {
            if (this.client.getReplyCode() != 200) {
                return;
            }
            this.lockToken = this.client.getResponseHeader("Lock-Token");
            this.lockToken = this.lockToken.substring(1, this.lockToken.length() - 1);
            this.propDocument = DocumentManager.getResponseDocument(this.client.getResponseStream());
        }
        catch (Exception exc) {
            log.info((Object)("Unhandled exception. " + exc.getMessage()));
        }
    }

    public String getLockToken() {
        return this.lockToken;
    }

    public DocumentApi getLockDocument() {
        return this.propDocument;
    }

    public LockDiscoveryProp.ActiveLock getActiveLock() {
        if (!(this.propDocument instanceof PropDoc)) {
            return null;
        }
        PropApi property = ((PropDoc)this.propDocument).getSingleProperty();
        if (!(property instanceof LockDiscoveryProp)) {
            return null;
        }
        return ((LockDiscoveryProp)property).getActiveLock();
    }

    public Document toXml(Document xmlDocument) {
        Element lockInfoEl = xmlDocument.createElementNS("DAV:", "A:lockinfo");
        xmlDocument.appendChild(lockInfoEl);
        Element lockScopeEl = xmlDocument.createElement("A:lockscope");
        lockInfoEl.appendChild(lockScopeEl);
        Element scopeExclusive = xmlDocument.createElement("A:exclusive");
        lockScopeEl.appendChild(scopeExclusive);
        Element lockTypeEl = xmlDocument.createElement("A:locktype");
        lockInfoEl.appendChild(lockTypeEl);
        Element typeWrite = xmlDocument.createElement("A:write");
        lockTypeEl.appendChild(typeWrite);
        Element ownerEl = xmlDocument.createElement("A:owner");
        lockInfoEl.appendChild(ownerEl);
        ownerEl.setTextContent("gavrik-vetal@ukr.net");
        return xmlDocument;
    }
}

