/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.frameworks.ftpclient;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.logging.Log;
import org.exoplatform.services.log.ExoLogger;

public class FtpSlowOutputStream
extends OutputStream {
    private static Log log = ExoLogger.getLogger((String)"exo.ftpclient.FtpSlowOutputStream");
    private OutputStream nativeOutputStream;
    private int bytesPerSec;
    private int blockSize;
    private int writed = 0;

    public FtpSlowOutputStream(OutputStream nativeOutputStream, int bytesPerSec) {
        this.nativeOutputStream = nativeOutputStream;
        this.bytesPerSec = bytesPerSec;
        this.blockSize = bytesPerSec / 10;
    }

    protected void tryWaiting() {
        if (this.writed >= this.blockSize) {
            try {
                Thread.sleep(100L);
            }
            catch (Exception exc) {
                log.info((Object)("Unhandled exception. " + exc.getMessage()), (Throwable)exc);
            }
            this.writed = 0;
        }
    }

    public void write(int dataByte) throws IOException {
        this.tryWaiting();
        this.nativeOutputStream.write(dataByte);
        ++this.writed;
    }

    public void write(byte[] dataBytes) throws IOException {
        this.write(dataBytes, 0, dataBytes.length);
    }

    public void write(byte[] dataBytes, int offset, int len) throws IOException {
        int allWrited = 0;
        int curOffset = offset;
        while (allWrited < len) {
            this.tryWaiting();
            int curBlockSize = this.blockSize - this.writed;
            if (curBlockSize + allWrited > len) {
                curBlockSize = len - allWrited;
            }
            this.nativeOutputStream.write(dataBytes, curOffset, curBlockSize);
            allWrited += curBlockSize;
            this.writed += curBlockSize;
            curOffset += curBlockSize;
        }
    }

    public void flush() throws IOException {
        this.nativeOutputStream.flush();
    }

    public void close() throws IOException {
        this.nativeOutputStream.close();
    }
}

