/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.frameworks.ftpclient.commands;

import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.exoplatform.frameworks.ftpclient.FtpDataTransiver;
import org.exoplatform.frameworks.ftpclient.FtpFileInfo;
import org.exoplatform.frameworks.ftpclient.FtpFileInfoImpl;
import org.exoplatform.frameworks.ftpclient.commands.CmdSyst;
import org.exoplatform.frameworks.ftpclient.commands.FtpCommandImpl;
import org.exoplatform.services.log.ExoLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CmdList
extends FtpCommandImpl {
    private static Log log = ExoLogger.getLogger((String)"exo.ftpclient.CmdList");
    protected String path = "";
    protected byte[] fileData;
    protected ArrayList<FtpFileInfo> files = new ArrayList();

    public CmdList() {
    }

    public CmdList(String path) {
        this.path = path;
    }

    public byte[] getFileData() {
        return this.fileData;
    }

    public ArrayList<FtpFileInfo> getFiles() {
        return this.files;
    }

    @Override
    public int execute() {
        try {
            if (this.clientSession.getSystemType() == null) {
                this.clientSession.executeCommand(new CmdSyst());
            }
            String req = "".equals(this.path) ? "LIST" : String.format("%s %s", "LIST", this.path);
            this.sendCommand(req);
            int reply = this.getReply();
            if (reply == 125 || reply == 150) {
                FtpDataTransiver dataTransiver = this.clientSession.getDataTransiver();
                this.fileData = dataTransiver.receive();
                dataTransiver.close();
                String dd = new String(this.fileData, "windows-1251");
                String[] lines = dd.split("\r\n");
                String systemType = this.clientSession.getSystemType();
                systemType = systemType.substring(systemType.indexOf(" ") + 1);
                for (int i = 0; i < lines.length; ++i) {
                    try {
                        FtpFileInfoImpl fileInfo = new FtpFileInfoImpl();
                        if ("".equals(lines[i])) continue;
                        fileInfo.parseDir(lines[i], systemType);
                        this.files.add(fileInfo);
                        continue;
                    }
                    catch (Exception exc) {
                        log.info((Object)("CAN'T PARSE FILE LINE: [" + lines[i] + "]"));
                    }
                }
                reply = this.getReply();
            }
            return reply;
        }
        catch (Exception exc) {
            log.info((Object)("Unhandled exception. " + exc.getMessage()), (Throwable)exc);
            return -1;
        }
    }
}

