/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.dataflow;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.commons.logging.Log;
import org.exoplatform.services.jcr.datamodel.InternalQPath;
import org.exoplatform.services.jcr.datamodel.ItemData;
import org.exoplatform.services.log.ExoLogger;

public class ItemState
implements Externalizable {
    private static Log log = ExoLogger.getLogger((String)"jcr.ItemState");
    public static final int ADDED = 1;
    public static final int UPDATED = 2;
    public static final int DELETED = 3;
    public static final int UNCHANGED = 4;
    public static final int MIXIN_CHANGED = 8;
    public static final int ORDER_ADDED = 9;
    public static final int ORDER_DELETED = 10;
    protected ItemData data;
    protected int state;
    private transient boolean internalCreated = false;
    protected transient boolean eventFire;
    private transient InternalQPath ancestorToSave;

    public ItemState(ItemData data, int state, boolean eventFire, InternalQPath ancestorToSave) {
        this(data, state, eventFire, ancestorToSave, true);
    }

    public ItemState(ItemData data, int state, boolean eventFire, InternalQPath ancestorToSave, boolean isInternalCreated) {
        this.data = data;
        this.state = state;
        this.eventFire = eventFire;
        this.ancestorToSave = ancestorToSave == null ? data.getQPath() : ancestorToSave;
        this.internalCreated = isInternalCreated;
        if (log.isDebugEnabled()) {
            log.debug((Object)(ItemState.nameFromValue(state) + " " + data.getQPath().getAsString() + ",  " + data.getUUID()));
        }
    }

    public ItemData getData() {
        return this.data;
    }

    public int getState() {
        return this.state;
    }

    public boolean isNode() {
        return this.data.isNode();
    }

    public boolean isOrderAdded() {
        return this.state == 9;
    }

    public boolean isAdded() {
        return this.state == 1;
    }

    public boolean isUpdated() {
        return this.state == 2;
    }

    public boolean isOrderDeleted() {
        return this.state == 10;
    }

    public boolean isDeleted() {
        return this.state == 3;
    }

    public boolean isUnchanged() {
        return this.state == 4;
    }

    public boolean isMixinChanged() {
        return this.state == 8;
    }

    public boolean isOrderable() {
        return this.state == 9 || this.state == 10;
    }

    public boolean isEventFire() {
        return this.eventFire;
    }

    public boolean eraseEventFire() {
        this.eventFire = false;
        return false;
    }

    public boolean isDescendant(InternalQPath relPath) {
        return this.getAncestorToSave().equals(relPath) || this.getAncestorToSave().isDescendantOf(relPath, false);
    }

    public InternalQPath getAncestorToSave() {
        return this.ancestorToSave;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof ItemState) {
            ItemState other = (ItemState)obj;
            return other.getData().equals(this.data) && other.getState() == this.state;
        }
        return false;
    }

    public static ItemState createAddedState(ItemData data) {
        return new ItemState(data, 1, true, null, true);
    }

    public static ItemState createAddedState(ItemData data, boolean isInternalCreated) {
        return new ItemState(data, 1, true, null, isInternalCreated);
    }

    public static ItemState createUpdatedState(ItemData data) {
        return new ItemState(data, 2, true, null);
    }

    public static ItemState createUpdatedState(ItemData data, boolean isInternalCreated) {
        return new ItemState(data, 2, true, null, isInternalCreated);
    }

    public static ItemState createDeletedState(ItemData data) {
        return new ItemState(data, 3, true, null);
    }

    public static ItemState createDeletedState(ItemData data, boolean isInternalCreated) {
        return new ItemState(data, 3, true, null, isInternalCreated);
    }

    public static ItemState createUnchangedState(ItemData data) {
        return new ItemState(data, 4, false, null);
    }

    public static ItemState createUnchangedState(ItemData data, boolean isInternalCreated) {
        return new ItemState(data, 4, false, null, isInternalCreated);
    }

    public static String nameFromValue(int stateValue) {
        switch (stateValue) {
            case 1: {
                return "ADDED";
            }
            case 3: {
                return "DELETED";
            }
            case 2: {
                return "UPDATED";
            }
            case 4: {
                return "UNCHANGED";
            }
            case 8: {
                return "MIXIN_CHANGED";
            }
            case 9: {
                return "ORDER_ADDED";
            }
            case 10: {
                return "ORDER_DELETED";
            }
        }
        return "UNDEFINED STATE";
    }

    public boolean isInternalCreated() {
        return this.internalCreated;
    }

    public ItemState() {
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.state);
        out.writeBoolean(this.eventFire);
        out.writeObject(this.data);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.state = in.readInt();
        this.eventFire = in.readBoolean();
        this.data = (ItemData)in.readObject();
    }
}

