/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.storage.swap;

import java.io.File;
import org.apache.commons.logging.Log;
import org.exoplatform.services.jcr.storage.swap.BinaryValueSwapStorage;
import org.exoplatform.services.jcr.util.io.FSUtil;
import org.exoplatform.services.log.ExoLogger;

public class BinaryValueTempStorage
extends BinaryValueSwapStorage {
    protected static Log log = ExoLogger.getLogger((String)"jcr.BinaryValueTempStorage");
    private static ThreadLocal<BinaryValueTempStorage> instance = new ThreadLocal();
    public static String DEFAULT_ROOT_DIR = "temp/binary";
    public static String DEFAULT_MIN_FILE_SIZE = String.valueOf(0x200000);
    private static String configRootDir = null;
    private static String configMinFileSize = null;
    private static String configCopyLocalFiles = null;

    BinaryValueTempStorage() {
        super(configRootDir != null ? configRootDir : DEFAULT_ROOT_DIR, configMinFileSize != null ? configMinFileSize : DEFAULT_MIN_FILE_SIZE, configCopyLocalFiles);
    }

    public static void configure(String newConfigRootDir, String newConfigMinFileSize, String copyLocalFilesText) {
        if (configRootDir != null) {
            throw new IllegalStateException("BinaryValueTempStorage already configured. It's try to set RootDir: " + newConfigRootDir + ". Currently used: " + configRootDir);
        }
        configRootDir = newConfigRootDir;
        if (configMinFileSize != null) {
            throw new IllegalStateException("BinaryValueTempStorage already configured. It's try to set MinFileSize: " + newConfigMinFileSize + ". Currently used: " + configMinFileSize);
        }
        configMinFileSize = newConfigMinFileSize;
        configCopyLocalFiles = copyLocalFilesText == null ? "false" : copyLocalFilesText;
    }

    public static BinaryValueTempStorage getInstance() {
        if (instance.get() == null) {
            instance.set(new BinaryValueTempStorage());
        }
        return instance.get();
    }

    static {
        DEFAULT_ROOT_DIR = FSUtil.getTempDir() + File.separator + "exo_jcr_binary_temp";
    }
}

