/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.util.io;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import org.apache.commons.logging.Log;
import org.exoplatform.services.jcr.datamodel.ValueData;
import org.exoplatform.services.jcr.util.io.BytesArray;
import org.exoplatform.services.jcr.util.io.LazyFileInputStream;
import org.exoplatform.services.log.ExoLogger;

public class BLOBUtil {
    private static Log log = ExoLogger.getLogger((String)"jcr.BLOBUtil");
    public static final int BLOB_MIN_AVAILABLE = 2048;
    public static final int BLOB_MIN_INMEMORY = 128;
    public static final int BLOB_MIN_SIZE = 0x200000;
    public static final int BLOB_BUFFER_SIZE = 204800;
    public static final int BLOB_BUFFER_SIZE2 = 0x200000;
    public static final int BLOB_BUFFER_SIZE3 = 0x1400000;

    public static int calcBufferSize(int availableBytes) {
        int maxBufferSize;
        long maval = Runtime.getRuntime().maxMemory();
        int n = maxBufferSize = maval >>> 1 > 0x1400000L ? 0x1400000 : 0x200000;
        return availableBytes > 128 ? (availableBytes > 2048 ? (availableBytes > 204800 ? (availableBytes > 0x200000 ? (availableBytes > maxBufferSize ? maxBufferSize : 0x200000) : 102400) : availableBytes) : 1024) : 128;
    }

    public static byte[] allocateBuffer(int availableBytes) {
        return new byte[BLOBUtil.calcBufferSize(availableBytes)];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] wrapByteArrayInputStream(ByteArrayInputStream aStream) {
        boolean unsetAccessible = false;
        Field buff = null;
        try {
            buff = aStream.getClass().getDeclaredField("buf");
            if (!buff.isAccessible()) {
                try {
                    buff.setAccessible(true);
                    unsetAccessible = true;
                }
                catch (SecurityException e) {
                    log.warn((Object)"Can't change field 'buf' accessible status in object of the ByteArrayInputStream class", (Throwable)e);
                }
            }
            byte[] e = (byte[])buff.get(aStream);
            return e;
        }
        catch (NoSuchFieldException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Stream " + aStream + " doesn't contains field with name 'buf'"), (Throwable)e);
            }
        }
        catch (IllegalArgumentException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Check that specified object is an instance of the ByteArrayInputStream class", (Throwable)e);
            }
        }
        catch (IllegalAccessException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Check that field 'buf' is accessible in object of the ByteArrayInputStream class", (Throwable)e);
            }
        }
        finally {
            if (unsetAccessible && buff != null) {
                buff.setAccessible(false);
            }
        }
        return null;
    }

    public static long calcStreamLength(InputStream aStream) throws IOException {
        ByteArrayInputStream bais;
        byte[] buffValue;
        if (aStream instanceof BytesArray) {
            return ((BytesArray)((Object)aStream)).size();
        }
        if (aStream instanceof FileInputStream) {
            FileChannel channel = ((FileInputStream)aStream).getChannel();
            if (channel != null) {
                return channel.size();
            }
        } else if (aStream instanceof LazyFileInputStream) {
            FileChannel channel = ((LazyFileInputStream)aStream).getChannel();
            if (channel != null) {
                return channel.size();
            }
        } else if (aStream instanceof ByteArrayInputStream && (buffValue = BLOBUtil.wrapByteArrayInputStream(bais = (ByteArrayInputStream)aStream)) != null) {
            return buffValue.length;
        }
        return aStream.available();
    }

    public static byte[] readStreamInmemory(InputStream aStream) {
        try {
            if (aStream instanceof BytesArray) {
                byte[] bytes = ((BytesArray)((Object)aStream)).getBytes();
                if (bytes.length <= 128) {
                    return BLOBUtil.copyBytes(bytes);
                }
            } else if (aStream instanceof ByteArrayInputStream) {
                ByteArrayInputStream bais = (ByteArrayInputStream)aStream;
                byte[] bytes = BLOBUtil.wrapByteArrayInputStream(bais);
                if (bytes.length <= 128) {
                    return BLOBUtil.copyBytes(bytes);
                }
            } else {
                byte[] buff = new byte[128];
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                int res = 0;
                while ((res = aStream.read(buff)) > 0) {
                    if (baos.size() > 128) {
                        baos = null;
                        break;
                    }
                    baos.write(buff, 0, res);
                }
                if (baos != null) {
                    return baos.toByteArray();
                }
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("Can't read stream data in in-memory bytes array: " + e.getMessage(), e);
        }
        throw new IllegalStateException("Data could not be rendered as byte array (large data)");
    }

    public static byte[] readValue(ValueData data) throws IOException {
        return data.isByteArray() ? data.getAsByteArray() : BLOBUtil.readStream(data.getAsStream());
    }

    public static byte[] copyBytes(byte[] source) {
        byte[] copyBuff = new byte[source.length];
        System.arraycopy(source, 0, copyBuff, 0, copyBuff.length);
        return copyBuff;
    }

    public static byte[] readStream(InputStream aStream) throws IOException {
        byte[] bytes;
        if (aStream instanceof FileInputStream) {
            return BLOBUtil.readFile((FileInputStream)aStream);
        }
        if (aStream instanceof BytesArray) {
            return BLOBUtil.copyBytes(((BytesArray)((Object)aStream)).getBytes());
        }
        if (aStream instanceof ByteArrayInputStream && (bytes = BLOBUtil.wrapByteArrayInputStream((ByteArrayInputStream)aStream)) != null) {
            return BLOBUtil.copyBytes(bytes);
        }
        return BLOBUtil.readInputStream(aStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readFile(FileInputStream file) throws IOException {
        FileChannel channel = file.getChannel();
        try {
            int size = (int)channel.size();
            if (size <= 0x200000) {
                byte[] byArray = BLOBUtil.readInputStream(file);
                return byArray;
            }
            ByteBuffer fileBuffer = ByteBuffer.allocate(size);
            channel.read(fileBuffer);
            fileBuffer.rewind();
            byte[] buff = new byte[size];
            fileBuffer.get(buff);
            fileBuffer.clear();
            byte[] byArray = buff;
            return byArray;
        }
        finally {
            if (channel != null) {
                channel.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public static long copyFile(FileInputStream source, RandomAccessFile destFile) throws IOException {
        FileChannel sourceChannel = null;
        FileChannel destenationChannel = null;
        try {
            sourceChannel = source.getChannel();
            destenationChannel = destFile.getChannel();
            sourceChannel.transferTo(0L, sourceChannel.size(), destenationChannel);
            long l = destenationChannel.size();
            return l;
        }
        finally {
            if (destenationChannel != null) {
                destenationChannel.close();
            }
            if (sourceChannel != null) {
                sourceChannel.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long copyFile(FileInputStream source, FileOutputStream destenation) throws IOException {
        FileChannel sourceChannel = source.getChannel();
        FileChannel destenationChannel = destenation.getChannel();
        try {
            sourceChannel.transferTo(0L, sourceChannel.size(), destenationChannel);
            long l = sourceChannel.size();
            return l;
        }
        finally {
            destenationChannel.force(true);
            destenationChannel.close();
            sourceChannel.close();
        }
    }

    @Deprecated
    public static long writeFile(byte[] buff, FileOutputStream fileOutput) throws IOException {
        FileChannel channel = fileOutput.getChannel();
        MappedByteBuffer storageBuffer = channel.map(FileChannel.MapMode.READ_WRITE, 0L, buff.length);
        storageBuffer.put(buff, 0, buff.length);
        storageBuffer.force();
        storageBuffer.clear();
        long size = channel.size();
        channel.close();
        return size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long writeFile(InputStream inputStream, FileOutputStream outFile) throws IOException {
        byte[] buffValue;
        if (inputStream instanceof FileInputStream) {
            return BLOBUtil.copyFile((FileInputStream)inputStream, outFile);
        }
        if (inputStream instanceof BytesArray) {
            byte[] buff = ((BytesArray)((Object)inputStream)).getBytes();
            outFile.write(buff);
            return buff.length;
        }
        if (inputStream instanceof LazyFileInputStream) {
            FileChannel sourceChannel = ((LazyFileInputStream)inputStream).getChannel();
            FileChannel destenationChannel = outFile.getChannel();
            try {
                sourceChannel.transferTo(0L, sourceChannel.size(), destenationChannel);
                long l = destenationChannel.size();
                return l;
            }
            finally {
                destenationChannel.force(true);
                destenationChannel.close();
                sourceChannel.close();
            }
        }
        if (inputStream instanceof ByteArrayInputStream && (buffValue = BLOBUtil.wrapByteArrayInputStream((ByteArrayInputStream)inputStream)) != null) {
            outFile.write(buffValue);
            return buffValue.length;
        }
        ReadableByteChannel input = Channels.newChannel(inputStream);
        FileChannel output = outFile.getChannel();
        int available = inputStream.available() + 64;
        int buffSize = BLOBUtil.calcBufferSize(available);
        ByteBuffer storageBuffer = available >= 2048 ? ByteBuffer.allocateDirect(buffSize) : ByteBuffer.allocate(buffSize);
        int res = 0;
        long size = 0L;
        while ((res = input.read(storageBuffer)) >= 0 || res < 0 && !storageBuffer.hasRemaining()) {
            storageBuffer.flip();
            int numWritten = output.write(storageBuffer);
            if (storageBuffer.hasRemaining()) {
                storageBuffer.compact();
            } else {
                storageBuffer.clear();
            }
            size += (long)numWritten;
        }
        output.close();
        input.close();
        storageBuffer.clear();
        return size;
    }

    protected static byte[] readInputStream(InputStream aStream) throws IOException {
        byte[] buff = BLOBUtil.allocateBuffer(aStream.available());
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        int res = 0;
        while ((res = aStream.read(buff)) > 0) {
            baos.write(buff, 0, res);
        }
        return baos.toByteArray();
    }
}

