/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.jcr.NamespaceRegistry;
import javax.jcr.RepositoryException;
import javax.jcr.nodetype.NodeTypeManager;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.jmx.MX4JComponentAdapterFactory;
import org.exoplatform.services.jcr.config.RepositoryConfigurationException;
import org.exoplatform.services.jcr.config.RepositoryEntry;
import org.exoplatform.services.jcr.config.WorkspaceEntry;
import org.exoplatform.services.jcr.core.nodetype.ExtendedNodeTypeManager;
import org.exoplatform.services.jcr.dataflow.DataManager;
import org.exoplatform.services.jcr.datamodel.InternalQName;
import org.exoplatform.services.jcr.impl.WorkspaceContainer;
import org.exoplatform.services.jcr.impl.core.LocationFactory;
import org.exoplatform.services.jcr.impl.core.NamespaceDataPersister;
import org.exoplatform.services.jcr.impl.core.NamespaceRegistryImpl;
import org.exoplatform.services.jcr.impl.core.RepositoryImpl;
import org.exoplatform.services.jcr.impl.core.SessionFactory;
import org.exoplatform.services.jcr.impl.core.WorkspaceInitializer;
import org.exoplatform.services.jcr.impl.core.access.DefaultAccessManagerImpl;
import org.exoplatform.services.jcr.impl.core.lock.LockManager;
import org.exoplatform.services.jcr.impl.core.nodetype.NodeTypeDataPersister;
import org.exoplatform.services.jcr.impl.core.nodetype.NodeTypeManagerImpl;
import org.exoplatform.services.jcr.impl.core.observation.ObservationManagerRegistry;
import org.exoplatform.services.jcr.impl.core.query.QueryManagerFactory;
import org.exoplatform.services.jcr.impl.core.query.SearchManager;
import org.exoplatform.services.jcr.impl.core.value.ValueFactoryImpl;
import org.exoplatform.services.jcr.impl.dataflow.persistent.CacheableWorkspaceDataManager;
import org.exoplatform.services.jcr.impl.dataflow.persistent.LocalWorkspaceDataManagerStub;
import org.exoplatform.services.jcr.impl.dataflow.persistent.WorkspaceStorageCacheImpl;
import org.exoplatform.services.jcr.impl.dataflow.replication.WorkspaceDataReplicator;
import org.exoplatform.services.jcr.impl.storage.value.StandaloneStoragePluginProvider;
import org.exoplatform.services.jcr.impl.util.io.WorkspaceFileCleanerHolder;
import org.exoplatform.services.jcr.util.UUIDGenerator;
import org.picocontainer.PicoContainer;
import org.picocontainer.defaults.ComponentAdapterFactory;

public class RepositoryContainer
extends ExoContainer {
    private RepositoryEntry config;
    private MBeanServer mbeanServer;
    private LocalWorkspaceDataManagerStub systemDataManager = null;

    public RepositoryContainer(ExoContainer parent, RepositoryEntry config) throws RepositoryException, RepositoryConfigurationException {
        super((ComponentAdapterFactory)new MX4JComponentAdapterFactory(), (PicoContainer)parent);
        if (config.getAccessControl() == null) {
            config.setAccessControl("optional");
        }
        this.config = config;
        this.mbeanServer = MBeanServerFactory.createMBeanServer("jcrrep" + this.getName() + "mx");
        this.registerComponents();
    }

    public void start() {
        try {
            this.init();
            this.load();
            this.doStart();
        }
        catch (RepositoryException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        catch (RepositoryConfigurationException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        super.start();
    }

    public MBeanServer getMBeanServer() {
        return this.mbeanServer;
    }

    public String getName() {
        return this.config.getName();
    }

    private void registerComponents() throws RepositoryConfigurationException, RepositoryException {
        this.registerComponentInstance(this.config);
        this.registerWorkspacesComponents();
        this.registerRepositoryComponents();
    }

    private void registerRepositoryComponents() throws RepositoryConfigurationException, RepositoryException {
        this.registerComponentImplementation(UUIDGenerator.class);
        this.registerComponentImplementation(NamespaceDataPersister.class);
        this.registerComponentImplementation(NamespaceRegistryImpl.class);
        this.registerComponentImplementation(WorkspaceFileCleanerHolder.class);
        this.registerComponentImplementation(LocationFactory.class);
        this.registerComponentImplementation(ValueFactoryImpl.class);
        this.registerComponentImplementation(NodeTypeDataPersister.class);
        this.registerComponentImplementation(NodeTypeManagerImpl.class);
        this.registerComponentImplementation(DefaultAccessManagerImpl.class);
        try {
            this.registerComponentImplementation(Class.forName(this.config.getAuthenticationPolicy()));
        }
        catch (ClassNotFoundException e) {
            throw new RepositoryConfigurationException("Class not found for repository authentication policy: " + e);
        }
        RepositoryImpl repository = new RepositoryImpl(this);
        this.registerComponentInstance(repository);
    }

    private void registerWorkspacesComponents() throws RepositoryException, RepositoryConfigurationException {
        List wsEntries = this.config.getWorkspaceEntries();
        Collections.sort(wsEntries, new WorkspaceOrderComparator(this.config.getSystemWorkspaceName()));
        for (int i = 0; i < wsEntries.size(); ++i) {
            this.registerWorkspace((WorkspaceEntry)wsEntries.get(i));
        }
    }

    private void registerWorkspace(WorkspaceEntry wsConfig) throws RepositoryException, RepositoryConfigurationException {
        boolean isSystem = this.config.getSystemWorkspaceName().equals(wsConfig.getName());
        WorkspaceContainer workspaceContainer = new WorkspaceContainer(this, wsConfig);
        this.registerComponentInstance(wsConfig.getName(), (Object)workspaceContainer);
        wsConfig.setUniqueName(this.getName() + "_" + wsConfig.getName());
        workspaceContainer.registerComponentInstance(wsConfig);
        workspaceContainer.registerComponentImplementation(StandaloneStoragePluginProvider.class);
        try {
            workspaceContainer.registerComponentImplementation(Class.forName(wsConfig.getContainer().getType()));
        }
        catch (ClassNotFoundException e) {
            throw new RepositoryConfigurationException("Class not found for workspace data container " + wsConfig.getUniqueName() + ": " + e);
        }
        workspaceContainer.registerComponentImplementation(WorkspaceStorageCacheImpl.class);
        workspaceContainer.registerComponentImplementation(CacheableWorkspaceDataManager.class);
        workspaceContainer.registerComponentImplementation(LocalWorkspaceDataManagerStub.class);
        workspaceContainer.registerComponentImplementation(ObservationManagerRegistry.class);
        workspaceContainer.registerComponentImplementation(LockManager.class);
        if (wsConfig.getQueryHandler() != null) {
            try {
                Class<?> qh = Class.forName(wsConfig.getQueryHandler().getType());
                workspaceContainer.registerComponentImplementation(qh);
            }
            catch (ClassNotFoundException e) {
                throw new RepositoryConfigurationException("Class not found for workspace query handler, container " + wsConfig.getUniqueName() + ": " + e);
            }
            workspaceContainer.registerComponentImplementation(SearchManager.class);
            workspaceContainer.registerComponentImplementation(QueryManagerFactory.class);
        }
        workspaceContainer.registerComponentImplementation(WorkspaceInitializer.class);
        workspaceContainer.registerComponentImplementation(SessionFactory.class);
        workspaceContainer.registerComponentImplementation(WorkspaceFileCleanerHolder.class);
        LocalWorkspaceDataManagerStub wsDataManager = (LocalWorkspaceDataManagerStub)workspaceContainer.getComponentInstanceOfType(LocalWorkspaceDataManagerStub.class);
        if (isSystem) {
            this.systemDataManager = wsDataManager;
            this.registerComponentInstance(this.systemDataManager);
        }
        wsDataManager.setSystemDataManager((DataManager)this.systemDataManager);
        if (this.config.getReplication() != null && this.config.getReplication().isEnabled()) {
            workspaceContainer.registerComponentImplementation(WorkspaceDataReplicator.class);
        }
    }

    public WorkspaceContainer getWorkspaceContainer(String workspaceName) {
        return (WorkspaceContainer)((Object)this.getComponentInstance(workspaceName));
    }

    public ExtendedNodeTypeManager getNodeTypeManager() {
        return (ExtendedNodeTypeManager)this.getComponentInstanceOfType(NodeTypeManager.class);
    }

    public NamespaceRegistry getNamespaceRegistry() {
        return (NamespaceRegistry)this.getComponentInstanceOfType(NamespaceRegistry.class);
    }

    public LocationFactory getLocationFactory() {
        return (LocationFactory)this.getComponentInstanceOfType(LocationFactory.class);
    }

    private void init() throws RepositoryException, RepositoryConfigurationException {
        List wsEntries = this.config.getWorkspaceEntries();
        for (WorkspaceEntry ws : wsEntries) {
            this.initWorkspace(ws);
        }
    }

    private void doStart() throws RepositoryException, RepositoryConfigurationException {
        List wsEntries = this.config.getWorkspaceEntries();
        for (WorkspaceEntry ws : wsEntries) {
            this.startWorkspace(ws);
        }
    }

    void load() throws RepositoryException {
        NamespaceRegistryImpl nsRegistry = (NamespaceRegistryImpl)this.getNamespaceRegistry();
        NodeTypeManagerImpl ntManager = (NodeTypeManagerImpl)this.getNodeTypeManager();
        nsRegistry.loadFromStorage();
        ntManager.loadFromStorage();
    }

    private void initWorkspace(WorkspaceEntry wsConfig) throws RepositoryException {
        WorkspaceContainer workspaceContainer = this.getWorkspaceContainer(wsConfig.getName());
        workspaceContainer.getComponentInstanceOfType(UUIDGenerator.class);
        workspaceContainer.getComponentInstanceOfType(WorkspaceDataReplicator.class);
        WorkspaceInitializer wsInitializer = (WorkspaceInitializer)workspaceContainer.getComponentInstanceOfType(WorkspaceInitializer.class);
        if (wsConfig.getAutoInitializedRootNt() != null) {
            InternalQName rootNodeTypeName = this.getLocationFactory().parseJCRName(wsConfig.getAutoInitializedRootNt()).getInternalName();
            wsInitializer.initWorkspace(rootNodeTypeName);
        }
    }

    private void startWorkspace(WorkspaceEntry wsConfig) throws RepositoryException {
        WorkspaceContainer workspaceContainer = this.getWorkspaceContainer(wsConfig.getName());
        WorkspaceInitializer wsInitializer = (WorkspaceInitializer)workspaceContainer.getComponentInstanceOfType(WorkspaceInitializer.class);
        wsInitializer.startWorkspace();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class WorkspaceOrderComparator
    implements Comparator<WorkspaceEntry> {
        private String sysWs;

        private WorkspaceOrderComparator(String sysWs) {
            this.sysWs = sysWs;
        }

        @Override
        public int compare(WorkspaceEntry o1, WorkspaceEntry o2) {
            String n1 = o1.getName();
            return n1.equals(this.sysWs) ? -1 : 0;
        }
    }
}

