/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.jcr.NamespaceException;
import javax.jcr.NamespaceRegistry;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.logging.Log;
import org.exoplatform.services.jcr.core.NamespaceAccessor;
import org.exoplatform.services.jcr.dataflow.DataManager;
import org.exoplatform.services.jcr.datamodel.IllegalNameException;
import org.exoplatform.services.jcr.impl.core.NamespaceDataPersister;
import org.exoplatform.services.log.ExoLogger;

public class NamespaceRegistryImpl
implements NamespaceRegistry,
NamespaceAccessor {
    public static HashMap<String, String> DEF_NAMESPACES = new HashMap();
    protected static Log log = ExoLogger.getLogger((String)"jcr.NamespaceRegistryImpl");
    private HashMap<String, String> namespaces = DEF_NAMESPACES;
    private NamespaceDataPersister persister = null;
    private static final String[] protectedNamespaces;

    public NamespaceRegistryImpl(DataManager dataManager, NamespaceDataPersister persister) throws RepositoryException {
        this.persister = persister;
    }

    public NamespaceRegistryImpl() throws RepositoryException {
    }

    public String getURI(String prefix) throws NamespaceException {
        String uri = this.namespaces.get(prefix);
        if (uri == null) {
            throw new NamespaceException("Unknown Prefix " + prefix);
        }
        return uri;
    }

    public synchronized void registerNamespace(String prefix, String uri) throws IllegalNameException, NamespaceException, RepositoryException {
        this.validateNamespace(prefix, uri);
        Collection<String> values = this.namespaces.values();
        if (values.contains(uri)) {
            throw new NamespaceException("Re-registration is not supported as may cause integrity problems. (todo issue #46)");
        }
        this.persister.addNamespace(prefix, uri);
        this.persister.saveChanges();
        this.namespaces.put(new String(prefix), new String(uri));
    }

    public synchronized void validateNamespace(String prefix, String uri) throws NamespaceException, RepositoryException {
        if (prefix.indexOf(":") > 0) {
            throw new IllegalNameException("Namespace prefix should not contain ':' " + prefix);
        }
        if (ArrayUtils.contains((Object[])protectedNamespaces, (Object)prefix)) {
            if (uri == null) {
                throw new NamespaceException("Can not remove built-in namespace");
            }
            throw new NamespaceException("Can not change built-in namespace");
        }
        if (prefix.toLowerCase().startsWith("xml")) {
            throw new NamespaceException("Can not re-assign prefix that start with 'xml'");
        }
        if (uri == null) {
            throw new NamespaceException("Can not register NULL URI!");
        }
    }

    public synchronized void unregisterNamespace(String prefix) throws NamespaceException, RepositoryException {
        if (this.namespaces.get(prefix) == null) {
            throw new NamespaceException("Prefix " + prefix + " is not registered");
        }
        for (int i = 0; i < protectedNamespaces.length; ++i) {
            if (!prefix.equals(protectedNamespaces[i])) continue;
            throw new NamespaceException("Prefix " + prefix + " is not protected");
        }
        throw new NamespaceException("Unregistration is not supported as may cause integrity problems. (todo issue #46)");
    }

    public String[] getPrefixes() {
        return this.namespaces.keySet().toArray(new String[this.namespaces.keySet().size()]);
    }

    public String[] getURIs() {
        return this.namespaces.values().toArray(new String[this.namespaces.size()]);
    }

    public String getPrefix(String uri) throws NamespaceException, RepositoryException {
        String[] prefixes = this.getPrefixes();
        for (int i = 0; i < prefixes.length; ++i) {
            if (!this.getURI(prefixes[i]).equals(uri)) continue;
            return prefixes[i];
        }
        throw new NamespaceException("Prefix for " + uri + " not found");
    }

    public Map getURIMap() {
        return this.namespaces;
    }

    public void loadFromStorage() throws RepositoryException {
        try {
            this.namespaces.putAll(this.persister.loadNamespaces());
        }
        catch (PathNotFoundException e) {
            log.info((Object)("Namespaces storage (/jcr:system/exo:namespaces) is not accessible. Default namespaces only will be used. " + (Object)((Object)e)));
            return;
        }
    }

    public String getNamespaceURIByPrefix(String prefix) throws NamespaceException {
        return this.getURI(prefix);
    }

    public String getNamespacePrefixByURI(String uri) throws NamespaceException, RepositoryException {
        return this.getPrefix(uri);
    }

    public String[] getAllNamespacePrefixes() {
        return this.getPrefixes();
    }

    static {
        DEF_NAMESPACES.put("", "");
        DEF_NAMESPACES.put("jcr", "http://www.jcp.org/jcr/1.0");
        DEF_NAMESPACES.put("nt", "http://www.jcp.org/jcr/nt/1.0");
        DEF_NAMESPACES.put("mix", "http://www.jcp.org/jcr/mix/1.0");
        DEF_NAMESPACES.put("xml", "http://www.w3.org/XML/1998/namespace");
        DEF_NAMESPACES.put("sv", "http://www.jcp.org/jcr/sv/1.0");
        DEF_NAMESPACES.put("exo", "http://www.exoplatform.com/jcr/exo/1.0");
        DEF_NAMESPACES.put("xs", "http://www.w3.org/2001/XMLSchema");
        DEF_NAMESPACES.put("fn", "http://www.w3.org/2004/10/xpath-functions");
        protectedNamespaces = new String[]{"jcr", "nt", "mix", "xml", "sv", "exo"};
    }
}

