/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.jcr.Credentials;
import javax.jcr.LoginException;
import javax.jcr.NamespaceRegistry;
import javax.jcr.NoSuchWorkspaceException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.commons.logging.Log;
import org.exoplatform.services.jcr.access.AuthenticationPolicy;
import org.exoplatform.services.jcr.config.RepositoryConfigurationException;
import org.exoplatform.services.jcr.config.RepositoryEntry;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.core.nodetype.ExtendedNodeTypeManager;
import org.exoplatform.services.jcr.datamodel.InternalQName;
import org.exoplatform.services.jcr.impl.RepositoryContainer;
import org.exoplatform.services.jcr.impl.WorkspaceContainer;
import org.exoplatform.services.jcr.impl.core.CredentialsImpl;
import org.exoplatform.services.jcr.impl.core.LocationFactory;
import org.exoplatform.services.jcr.impl.core.SessionFactory;
import org.exoplatform.services.jcr.impl.core.SessionImpl;
import org.exoplatform.services.log.ExoLogger;
import org.picocontainer.ComponentAdapter;

public class RepositoryImpl
implements ManageableRepository {
    protected static Log log = ExoLogger.getLogger((String)"jcr:RepositoryImpl");
    private static HashMap<String, String> descriptors = new HashMap();
    private RepositoryContainer repositoryContainer;
    private String systemWorkspaceName;
    private String name;
    private RepositoryEntry config;
    private AuthenticationPolicy authenticationPolicy;
    private static final CredentialsImpl SYSTEM_CREDENTIALS;

    public RepositoryImpl(RepositoryContainer container) throws RepositoryException, RepositoryConfigurationException {
        this.config = (RepositoryEntry)container.getComponentInstanceOfType(RepositoryEntry.class);
        this.authenticationPolicy = (AuthenticationPolicy)container.getComponentInstanceOfType(AuthenticationPolicy.class);
        this.name = this.config.getName();
        this.systemWorkspaceName = this.config.getSystemWorkspaceName();
        this.repositoryContainer = container;
    }

    public String[] getDescriptorKeys() {
        String[] keys = new String[descriptors.size()];
        Iterator<String> decriptorsList = descriptors.keySet().iterator();
        int i = 0;
        while (decriptorsList.hasNext()) {
            keys[i++] = decriptorsList.next();
        }
        return keys;
    }

    public String getDescriptor(String key) {
        return descriptors.get(key);
    }

    public Session login(Credentials credentials) throws LoginException, NoSuchWorkspaceException, RepositoryException {
        return this.login(credentials, null);
    }

    public Session login(String workspaceName) throws LoginException, NoSuchWorkspaceException, RepositoryException {
        return this.login(null, workspaceName);
    }

    public Session login() throws LoginException, NoSuchWorkspaceException, RepositoryException {
        return this.login(null, null);
    }

    public SessionImpl login(Credentials credentials, String workspaceName) throws LoginException, NoSuchWorkspaceException, RepositoryException {
        if (workspaceName == null && (workspaceName = this.config.getDefaultWorkspaceName()) == null) {
            throw new NoSuchWorkspaceException("Both workspace and default-workspace name are null! ");
        }
        if (!this.isWorkspaceInitialized(workspaceName)) {
            throw new NoSuchWorkspaceException("Workspace '" + workspaceName + "' not found. " + "Probably is not initialized. If so either Initialize it manually or turn on the RepositoryInitializer");
        }
        SessionFactory sessionFactory = this.repositoryContainer.getWorkspaceContainer(workspaceName).getSessionFactory();
        if (credentials != null) {
            return sessionFactory.createSession((CredentialsImpl)this.authenticationPolicy.authenticate(credentials));
        }
        return sessionFactory.createSession((CredentialsImpl)this.authenticationPolicy.authenticate());
    }

    public Session getSystemSession(String workspaceName) throws RepositoryException {
        SessionFactory sessionFactory = this.repositoryContainer.getWorkspaceContainer(workspaceName).getSessionFactory();
        return sessionFactory.createSession(SYSTEM_CREDENTIALS);
    }

    public RepositoryEntry getConfiguration() {
        return this.config;
    }

    public String[] getWorkspaceNames() {
        List adapters = this.repositoryContainer.getComponentAdaptersOfType(WorkspaceContainer.class);
        String[] workspaceNames = new String[adapters.size()];
        for (int i = 0; i < adapters.size(); ++i) {
            ComponentAdapter adapter = (ComponentAdapter)adapters.get(i);
            workspaceNames[i] = new String((String)adapter.getComponentKey());
        }
        return workspaceNames;
    }

    public ExtendedNodeTypeManager getNodeTypeManager() {
        return this.repositoryContainer.getNodeTypeManager();
    }

    public NamespaceRegistry getNamespaceRegistry() {
        return this.repositoryContainer.getNamespaceRegistry();
    }

    public void initWorkspace(String workspaceName, String rootNodeType) throws RepositoryException {
        if (this.isWorkspaceInitialized(workspaceName)) {
            log.warn((Object)("Workspace '" + workspaceName + "' is presumably initialized. Initialization canceled"));
            return;
        }
        InternalQName rootNodeTypeName = this.repositoryContainer.getLocationFactory().parseJCRName(rootNodeType).getInternalName();
        this.repositoryContainer.getWorkspaceContainer(workspaceName).getWorkspaceInitializer().initWorkspace(rootNodeTypeName);
        log.info((Object)("Workspace " + workspaceName + "@" + this.name + " is initialized"));
    }

    public boolean isWorkspaceInitialized(String workspaceName) {
        try {
            return this.repositoryContainer.getWorkspaceContainer(workspaceName).getWorkspaceInitializer().isWorkspaceInitialized();
        }
        catch (Exception e) {
            return false;
        }
    }

    public String getSystemWorkspaceName() {
        return this.systemWorkspaceName;
    }

    public String getName() {
        return this.name;
    }

    public SessionImpl getSystemSession() throws RepositoryException {
        return (SessionImpl)this.getSystemSession(this.systemWorkspaceName);
    }

    public LocationFactory getLocationFactory() {
        return this.repositoryContainer.getLocationFactory();
    }

    static {
        descriptors.put("jcr.specification.version", "1.0");
        descriptors.put("jcr.specification.name", "Content Repository Java Technology API");
        descriptors.put("jcr.repository.vendor", "eXo Platform SARL");
        descriptors.put("jcr.repository.vendor.url", "http://www.exoplatform.com");
        descriptors.put("jcr.repository.name", "eXo Java Content Repository");
        descriptors.put("jcr.repository.version", "1.2");
        descriptors.put("level.1.supported", "true");
        descriptors.put("level.2.supported", "true");
        descriptors.put("option.transactions.supported", "true");
        descriptors.put("option.versioning.supported", "true");
        descriptors.put("option.observation.supported", "true");
        descriptors.put("option.locking.supported", "true");
        descriptors.put("option.query.sql.supported", "true");
        descriptors.put("query.xpath.pos.index", "true");
        descriptors.put("query.xpath.doc.order", "true");
        SYSTEM_CREDENTIALS = new CredentialsImpl("__system", "".toCharArray());
    }
}

