/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core;

import java.util.Collection;
import javax.jcr.RepositoryException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.xa.XAResource;
import org.apache.commons.logging.Log;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.services.jcr.config.WorkspaceEntry;
import org.exoplatform.services.jcr.impl.core.CredentialsImpl;
import org.exoplatform.services.jcr.impl.core.SessionImpl;
import org.exoplatform.services.jcr.impl.core.XASessionImpl;
import org.exoplatform.services.jcr.impl.dataflow.session.TransactionableResourceManager;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.transaction.TransactionService;

public class SessionFactory {
    protected static Log log = ExoLogger.getLogger((String)"jcr.SessionFactory");
    private OrganizationService organizationService;
    private ExoContainer container;
    private TransactionService tService;
    private String workspaceName;
    private TransactionableResourceManager txResourceManager = null;

    public SessionFactory(OrganizationService orgService, TransactionService tService, WorkspaceEntry config, ExoContainerContext containerContext) {
        this.organizationService = orgService;
        this.container = containerContext.getContainer();
        this.workspaceName = config.getName();
        this.tService = tService;
        this.txResourceManager = new TransactionableResourceManager();
    }

    public SessionFactory(OrganizationService orgService, WorkspaceEntry config, ExoContainerContext containerContext) {
        this(orgService, null, config, containerContext);
    }

    SessionImpl createSession(CredentialsImpl credentials) throws RepositoryException {
        try {
            Collection groups = this.organizationService.getGroupHandler().findGroupsOfUser(credentials.getUserID());
        }
        catch (Exception e) {
            log.error((Object)("JCR session create error, user: " + credentials.getUserID() + ". AccessManager failed " + e.getMessage()));
            throw new RepositoryException("AccessManager failed " + e, (Throwable)e);
        }
        if (this.tService == null) {
            return new SessionImpl(this.workspaceName, credentials, this.container);
        }
        XASessionImpl xaSession = new XASessionImpl(this.workspaceName, credentials, this.container, this.tService, this.txResourceManager);
        try {
            this.tService.enlistResource((XAResource)xaSession);
        }
        catch (RollbackException e) {
            throw new RepositoryException((Throwable)e);
        }
        catch (SystemException e) {
            throw new RepositoryException((Throwable)e);
        }
        return xaSession;
    }
}

