/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.AccessControlException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.jcr.AccessDeniedException;
import javax.jcr.Credentials;
import javax.jcr.InvalidItemStateException;
import javax.jcr.InvalidSerializedDataException;
import javax.jcr.Item;
import javax.jcr.ItemExistsException;
import javax.jcr.ItemNotFoundException;
import javax.jcr.LoginException;
import javax.jcr.NamespaceException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.SimpleCredentials;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.Value;
import javax.jcr.ValueFormatException;
import javax.jcr.lock.LockException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.version.VersionException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.logging.Log;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.services.jcr.access.AccessControlList;
import org.exoplatform.services.jcr.access.AccessManager;
import org.exoplatform.services.jcr.access.PermissionType;
import org.exoplatform.services.jcr.config.RepositoryEntry;
import org.exoplatform.services.jcr.core.NamespaceAccessor;
import org.exoplatform.services.jcr.core.nodetype.ExtendedNodeType;
import org.exoplatform.services.jcr.dataflow.ItemDataVisitor;
import org.exoplatform.services.jcr.dataflow.ItemState;
import org.exoplatform.services.jcr.datamodel.ItemData;
import org.exoplatform.services.jcr.datamodel.NodeData;
import org.exoplatform.services.jcr.datamodel.ValueData;
import org.exoplatform.services.jcr.impl.Constants;
import org.exoplatform.services.jcr.impl.core.CredentialsImpl;
import org.exoplatform.services.jcr.impl.core.ItemImpl;
import org.exoplatform.services.jcr.impl.core.JCRPath;
import org.exoplatform.services.jcr.impl.core.LocationFactory;
import org.exoplatform.services.jcr.impl.core.NamespaceRegistryImpl;
import org.exoplatform.services.jcr.impl.core.NodeImpl;
import org.exoplatform.services.jcr.impl.core.PropertyImpl;
import org.exoplatform.services.jcr.impl.core.RepositoryImpl;
import org.exoplatform.services.jcr.impl.core.SessionDataManager;
import org.exoplatform.services.jcr.impl.core.SessionFactory;
import org.exoplatform.services.jcr.impl.core.SessionLifecycleListener;
import org.exoplatform.services.jcr.impl.core.WorkspaceImpl;
import org.exoplatform.services.jcr.impl.core.lock.LockManager;
import org.exoplatform.services.jcr.impl.core.observation.ObservationManagerImpl;
import org.exoplatform.services.jcr.impl.core.observation.ObservationManagerRegistry;
import org.exoplatform.services.jcr.impl.core.value.BinaryValue;
import org.exoplatform.services.jcr.impl.core.value.ValueFactoryImpl;
import org.exoplatform.services.jcr.impl.dataflow.ItemDataMoveVisitor;
import org.exoplatform.services.jcr.impl.dataflow.TransientValueData;
import org.exoplatform.services.jcr.impl.dataflow.persistent.LocalWorkspaceDataManagerStub;
import org.exoplatform.services.jcr.impl.ext.action.SessionActionCatalog;
import org.exoplatform.services.jcr.impl.ext.action.SessionActionInterceptor;
import org.exoplatform.services.jcr.impl.util.StringConverter;
import org.exoplatform.services.jcr.impl.util.io.WorkspaceFileCleanerHolder;
import org.exoplatform.services.jcr.impl.xml.NodeImporter;
import org.exoplatform.services.jcr.impl.xml.SysExportXmlVisior;
import org.exoplatform.services.jcr.impl.xml.XMLWriter;
import org.exoplatform.services.jcr.util.UUIDGenerator;
import org.exoplatform.services.jcr.util.io.BLOBUtil;
import org.exoplatform.services.log.ExoLogger;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class SessionImpl
implements Session,
NamespaceAccessor {
    protected static Log log = ExoLogger.getLogger((String)"jcr.SessionImpl");
    private RepositoryImpl repository;
    private CredentialsImpl credentials;
    private WorkspaceImpl workspace;
    protected SessionDataManager nodesManager;
    private Map<String, String> namespaces;
    private AccessManager accessManager;
    private LocationFactory locationFactory;
    private ValueFactoryImpl valueFactory;
    private ExoContainer container;
    private LocationFactory systemLocationFactory;
    private LockManager lockManager;
    private String workspaceName;
    private boolean live;
    private HashSet<String> lockTokens;
    private List<SessionLifecycleListener> lifecycleListeners;
    private SessionFactory sessionFactory;
    private final String id;
    private SessionActionInterceptor actionHandler;

    SessionImpl(String workspaceName, Credentials credentials, ExoContainer container) throws RepositoryException {
        this.workspaceName = workspaceName;
        this.container = container;
        this.live = true;
        this.id = UUIDGenerator.generate();
        this.lockTokens = new HashSet();
        this.repository = (RepositoryImpl)container.getComponentInstanceOfType(RepositoryImpl.class);
        this.systemLocationFactory = (LocationFactory)container.getComponentInstanceOfType(LocationFactory.class);
        this.accessManager = (AccessManager)container.getComponentInstanceOfType(AccessManager.class);
        this.lockManager = (LockManager)container.getComponentInstanceOfType(LockManager.class);
        this.sessionFactory = (SessionFactory)container.getComponentInstanceOfType(SessionFactory.class);
        RepositoryEntry repositoryConfig = (RepositoryEntry)container.getComponentInstanceOfType(RepositoryEntry.class);
        WorkspaceFileCleanerHolder cleanerHolder = (WorkspaceFileCleanerHolder)container.getComponentInstanceOfType(WorkspaceFileCleanerHolder.class);
        this.credentials = (CredentialsImpl)credentials;
        this.locationFactory = new LocationFactory(this);
        this.valueFactory = new ValueFactoryImpl(this.locationFactory, repositoryConfig, cleanerHolder);
        this.namespaces = new LinkedHashMap<String, String>();
        ObservationManagerRegistry observationManagerRegistry = (ObservationManagerRegistry)container.getComponentInstanceOfType(ObservationManagerRegistry.class);
        ObservationManagerImpl observationManager = observationManagerRegistry.createObservationManager(this);
        LocalWorkspaceDataManagerStub workspaceDataManager = (LocalWorkspaceDataManagerStub)container.getComponentInstanceOfType(LocalWorkspaceDataManagerStub.class);
        this.nodesManager = new SessionDataManager(this, workspaceDataManager);
        this.workspace = new WorkspaceImpl(workspaceName, container, this, observationManager);
        this.lifecycleListeners = new ArrayList<SessionLifecycleListener>();
        this.registerLifecycleListener(observationManager);
        this.registerLifecycleListener(this.lockManager);
        SessionActionCatalog catalog = (SessionActionCatalog)((Object)container.getComponentInstanceOfType(SessionActionCatalog.class));
        this.actionHandler = new SessionActionInterceptor(catalog, container);
    }

    public String getSessionInfo() {
        return this.getUserID() + "@" + this.workspaceName;
    }

    public String getUserID() {
        return this.credentials.getUserID();
    }

    public Object getAttribute(String name) {
        return this.credentials.getAttribute(name);
    }

    public String[] getAttributeNames() {
        return this.credentials.getAttributeNames();
    }

    public void logout() {
        for (int i = 0; i < this.lifecycleListeners.size(); ++i) {
            this.lifecycleListeners.get(i).onCloseSession(this);
        }
        this.live = false;
    }

    public boolean isLive() {
        return this.live;
    }

    public Repository getRepository() {
        return this.repository;
    }

    public Session impersonate(Credentials credentials) throws LoginException, RepositoryException {
        if (credentials instanceof CredentialsImpl) {
            return this.sessionFactory.createSession((CredentialsImpl)credentials);
        }
        if (credentials instanceof SimpleCredentials) {
            String name = ((SimpleCredentials)credentials).getUserID();
            char[] pswd = ((SimpleCredentials)credentials).getPassword();
            CredentialsImpl thisCredentials = new CredentialsImpl(name, pswd);
            return this.sessionFactory.createSession(thisCredentials);
        }
        throw new LoginException("Credentials for the authentication should be CredentialsImpl or SimpleCredentials type");
    }

    public WorkspaceImpl getWorkspace() {
        return this.workspace;
    }

    public Node getRootNode() throws RepositoryException {
        return (Node)this.getItem("/");
    }

    public Node getNodeByUUID(String uuid) throws ItemNotFoundException, RepositoryException {
        ItemImpl item = this.nodesManager.getItemByUUID(uuid, true);
        if (item != null && item.isNode()) {
            Node node = (Node)item;
            node.getUUID();
            return node;
        }
        throw new ItemNotFoundException("Node not found " + uuid + " at " + this.workspaceName);
    }

    public Item getItem(String absPath) throws PathNotFoundException, RepositoryException {
        JCRPath loc = this.locationFactory.parseAbsPath(absPath);
        ItemImpl item = this.nodesManager.getItem(loc.getInternalPath(), true);
        if (item != null) {
            return item;
        }
        throw new PathNotFoundException("Item not found " + absPath + " in workspace " + this.workspaceName);
    }

    public boolean itemExists(String absPath) {
        try {
            if (this.nodesManager.getItem(this.locationFactory.parseAbsPath(absPath).getInternalPath(), true) != null) {
                return true;
            }
        }
        catch (RepositoryException repositoryException) {
            // empty catch block
        }
        return false;
    }

    public void save() throws AccessDeniedException, LockException, ConstraintViolationException, InvalidItemStateException, RepositoryException {
        this.getRootNode().save();
    }

    public void refresh(boolean keepChanges) throws RepositoryException {
        this.getRootNode().refresh(keepChanges);
    }

    public boolean hasPendingChanges() throws RepositoryException {
        return this.nodesManager.hasPendingChanges(Constants.ROOT_PATH);
    }

    public ValueFactoryImpl getValueFactory() throws UnsupportedRepositoryOperationException, RepositoryException {
        return this.valueFactory;
    }

    public String getNamespacePrefix(String uri) throws NamespaceException, RepositoryException {
        int i;
        if (this.namespaces.values().contains(uri)) {
            String[] keys = this.namespaces.keySet().toArray(new String[this.namespaces.size()]);
            for (i = keys.length - 1; i >= 0; --i) {
                String key = keys[i];
                String value = this.namespaces.get(key);
                if (!value.equals(uri)) continue;
                return key;
            }
        }
        String[] prefixes = this.workspace.getNamespaceRegistry().getPrefixes();
        for (i = 0; i < prefixes.length; ++i) {
            try {
                String prefixUri = this.workspace.getNamespaceRegistry().getURI(prefixes[i]);
                if (prefixUri == null || !prefixUri.equals(uri)) continue;
                return prefixes[i];
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        throw new NamespaceException("Prefix for " + uri + " not found");
    }

    public void setNamespacePrefix(String prefix, String uri) throws NamespaceException, RepositoryException {
        ((NamespaceRegistryImpl)this.workspace.getNamespaceRegistry()).validateNamespace(prefix, uri);
        String testPrefix = this.workspace.getNamespaceRegistry().getPrefix(uri);
        if (testPrefix.equals(prefix)) {
            return;
        }
        try {
            this.workspace.getNamespaceRegistry().getURI(prefix);
        }
        catch (NamespaceException e) {
            this.namespaces.put(prefix, uri);
            return;
        }
        throw new NamespaceException("Prefix " + prefix + " is already mapped to other uri");
    }

    public String[] getNamespacePrefixes() throws RepositoryException {
        LinkedList<String> allPrefixes = new LinkedList<String>();
        allPrefixes.addAll(this.namespaces.keySet());
        String[] permanentPrefixes = this.workspace.getNamespaceRegistry().getPrefixes();
        for (int i = 0; i < permanentPrefixes.length; ++i) {
            String permanentPrefix = permanentPrefixes[i];
            String uri = null;
            try {
                uri = this.workspace.getNamespaceRegistry().getURI(permanentPrefix);
                if (allPrefixes.contains(permanentPrefix) || this.namespaces.values().contains(uri)) continue;
                allPrefixes.add(permanentPrefix);
                continue;
            }
            catch (RepositoryException e) {
                e.printStackTrace();
            }
        }
        return allPrefixes.toArray(new String[allPrefixes.size()]);
    }

    public String getNamespaceURI(String prefix) throws NamespaceException, RepositoryException {
        String uri = null;
        uri = this.namespaces.get(prefix);
        if (uri != null) {
            return uri;
        }
        uri = this.workspace.getNamespaceRegistry().getURI(prefix);
        if (this.namespaces.values().contains(uri)) {
            return null;
        }
        if (uri == null) {
            throw new NamespaceException("No namespace '" + uri + "' found");
        }
        return uri;
    }

    public String getNamespaceURIByPrefix(String prefix) throws NamespaceException, RepositoryException {
        return this.getNamespaceURI(prefix);
    }

    public String getNamespacePrefixByURI(String uri) throws NamespaceException, RepositoryException {
        return this.getNamespacePrefix(uri);
    }

    public String[] getAllNamespacePrefixes() throws RepositoryException {
        return this.getNamespacePrefixes();
    }

    public void exportSystemView(String absPath, ContentHandler contentHandler, boolean skipBinary, boolean noRecurse) throws PathNotFoundException, SAXException, RepositoryException {
        SysExportXmlVisior exporter = new SysExportXmlVisior(contentHandler, this, this.getTransientNodesManager(), skipBinary, noRecurse);
        JCRPath srcNodePath = this.getLocationFactory().parseAbsPath(absPath);
        ItemData srcItemData = this.nodesManager.getItemData(srcNodePath.getInternalPath());
        if (srcItemData == null) {
            throw new PathNotFoundException("No node exists at " + absPath);
        }
        exporter.export((NodeData)srcItemData);
    }

    public void exportSystemView(String absPath, OutputStream out, boolean skipBinary, boolean noRecurse) throws IOException, PathNotFoundException, RepositoryException {
        TransformerHandler handler;
        try {
            SAXTransformerFactory saxFact = (SAXTransformerFactory)SAXTransformerFactory.newInstance();
            handler = saxFact.newTransformerHandler();
            handler.setResult(new StreamResult(out));
        }
        catch (TransformerFactoryConfigurationError ex) {
            throw new IOException(ex.getMessage());
        }
        catch (TransformerConfigurationException ex) {
            throw new IOException(ex.getMessage());
        }
        try {
            this.exportSystemView(absPath, handler, skipBinary, noRecurse);
        }
        catch (SAXException ex) {
            throw new RepositoryException("Error on export", (Throwable)ex);
        }
    }

    public void exportDocumentView(String absPath, ContentHandler contentHandler, boolean skipBinary, boolean noRecurse) throws InvalidSerializedDataException, PathNotFoundException, SAXException, RepositoryException {
        JCRPath srcNodePath = this.getLocationFactory().parseAbsPath(absPath);
        NodeImpl srcNode = (NodeImpl)this.nodesManager.getItem(srcNodePath.getInternalPath(), true);
        XMLWriter writer = new XMLWriter(this);
        this.initNodeAsDocView(srcNode, writer, skipBinary, noRecurse);
        this.invokeHandler(writer.getBytes(), contentHandler);
    }

    public void exportDocumentView(String absPath, OutputStream out, boolean skipBinary, boolean noRecurse) throws InvalidSerializedDataException, IOException, PathNotFoundException, RepositoryException {
        SAXTransformerFactory stf = (SAXTransformerFactory)SAXTransformerFactory.newInstance();
        try {
            TransformerHandler th = stf.newTransformerHandler();
            th.setResult(new StreamResult(out));
            th.getTransformer().setParameter("method", "xml");
            th.getTransformer().setParameter("encoding", "UTF-8");
            th.getTransformer().setParameter("indent", "no");
            this.exportDocumentView(absPath, th, skipBinary, noRecurse);
        }
        catch (TransformerException te) {
            throw new RepositoryException((Throwable)te);
        }
        catch (SAXException se) {
            throw new RepositoryException((Throwable)se);
        }
    }

    public void importXML(String parentAbsPath, InputStream in, int uuidBehavior) throws IOException, PathNotFoundException, ItemExistsException, ConstraintViolationException, InvalidSerializedDataException, RepositoryException {
        try {
            NodeImporter importer = (NodeImporter)this.getImportContentHandler(parentAbsPath, uuidBehavior);
            importer.parse(in);
        }
        catch (IOException e) {
            throw new InvalidSerializedDataException("importXML failed", (Throwable)e);
        }
        catch (SAXException e) {
            Throwable rootCause = e.getException();
            if (rootCause == null) {
                rootCause = this.getRootCauseException(e);
            }
            if (rootCause == null) {
                rootCause = e;
            }
            if (rootCause instanceof ItemExistsException) {
                throw new ItemExistsException("importXML failed", rootCause);
            }
            if (rootCause instanceof ConstraintViolationException) {
                throw new ConstraintViolationException("importXML failed", rootCause);
            }
            throw new InvalidSerializedDataException("importXML failed", (Throwable)e);
        }
        catch (ParserConfigurationException e) {
            throw new InvalidSerializedDataException("importXML failed", (Throwable)e);
        }
    }

    public Throwable getRootCauseException(Throwable e) {
        Throwable ex = e;
        while (ex.getCause() != null) {
            ex = ex.getCause();
        }
        return ex;
    }

    public ContentHandler getImportContentHandler(String parentAbsPath, int uuidBehavior) throws PathNotFoundException, ConstraintViolationException, VersionException, RepositoryException {
        NodeImpl node = (NodeImpl)this.getItem(parentAbsPath);
        this.checkNodeImport(node);
        NodeImporter handler = new NodeImporter(node);
        handler.setUuidBehavior(uuidBehavior);
        handler.setSaveType(2);
        return handler;
    }

    private void checkNodeImport(NodeImpl node) throws VersionException, ConstraintViolationException, LockException, RepositoryException {
        if (!node.isCheckedOut()) {
            throw new VersionException("Node " + node.getPath() + " or its nearest ancestor is checked-in");
        }
        if (node.getDefinition().isProtected()) {
            throw new ConstraintViolationException("Can't add protected node " + node.getName() + " to " + node.getParent().getPath());
        }
        if (!node.checkLocking()) {
            throw new LockException("Node " + node.getPath() + " is locked ");
        }
    }

    public void move(String srcAbsPath, String destAbsPath) throws ItemExistsException, PathNotFoundException, VersionException, LockException, RepositoryException {
        JCRPath srcNodePath = this.getLocationFactory().parseAbsPath(srcAbsPath);
        NodeImpl srcNode = (NodeImpl)this.nodesManager.getItem(srcNodePath.getInternalPath(), true);
        JCRPath destNodePath = this.getLocationFactory().parseAbsPath(destAbsPath);
        if (destNodePath.isIndexSetExplicitly()) {
            throw new RepositoryException("The relPath provided must not have an index on its final element. " + destNodePath.getAsString(false));
        }
        NodeImpl destParentNode = (NodeImpl)this.nodesManager.getItem(destNodePath.makeParentPath().getInternalPath(), true);
        if (srcNode == null || destParentNode == null) {
            throw new PathNotFoundException("No node exists at " + srcAbsPath + " or no node exists one level above " + destAbsPath);
        }
        destParentNode.validateChildNode(destNodePath.getName().getInternalName(), ((ExtendedNodeType)srcNode.getPrimaryNodeType()).getQName());
        NodeImpl destNode = (NodeImpl)this.nodesManager.getItem(destNodePath.getInternalPath(), true);
        if (destNode != null && !destNode.getDefinition().allowsSameNameSiblings()) {
            String msg = "A node with this name (" + destAbsPath + ") is already exists. ";
            throw new ItemExistsException(msg);
        }
        if (!srcNode.getParent().isCheckedOut()) {
            throw new VersionException("Parent or source Node or its nearest ancestor is checked-in");
        }
        if (!srcNode.checkLocking()) {
            throw new LockException("Source parent node " + srcNode.getPath() + " is locked ");
        }
        ItemDataMoveVisitor initializer = new ItemDataMoveVisitor((NodeData)destParentNode.getData(), destNodePath.getName().getInternalName(), this.getWorkspace().getNodeTypeManager(), this.getTransientNodesManager(), srcNode.isNodeType(Constants.MIX_REFERENCEABLE));
        srcNode.getData().accept((ItemDataVisitor)initializer);
        this.getTransientNodesManager().getChangesLog().addAll(initializer.getItemDeletedStates(true));
        this.getTransientNodesManager().getChangesLog().addAll(this.getTransientNodesManager().reindexSameNameSiblings(srcNode.nodeData(), this.getTransientNodesManager()));
        List<ItemState> itemStates = initializer.getItemAddStates();
        for (ItemState itemState : itemStates) {
            this.getTransientNodesManager().update(itemState, true);
        }
    }

    public void checkPermission(String absPath, String actions) throws AccessControlException {
        try {
            JCRPath jcrPath = this.locationFactory.parseAbsPath(absPath);
            AccessControlList acl = this.nodesManager.getACL(jcrPath.getInternalPath());
            if (!this.accessManager.hasPermission(acl, actions, this.getUserID())) {
                throw new AccessControlException("Permission denied " + absPath + " : " + actions);
            }
        }
        catch (RepositoryException e) {
            throw new AccessControlException("Could not check permission for " + absPath + " " + (Object)((Object)e));
        }
    }

    public void addLockToken(String lt) {
        this.lockTokens.add(lt);
    }

    public String[] getLockTokens() {
        String[] tokens = new String[this.lockTokens.size()];
        this.lockTokens.toArray(tokens);
        return tokens;
    }

    public void removeLockToken(String lt) {
        this.lockTokens.remove(lt);
    }

    public SessionDataManager getTransientNodesManager() {
        return this.nodesManager;
    }

    public Credentials getCredentials() {
        return this.credentials;
    }

    LocationFactory getSystemLocationFactory() {
        return this.systemLocationFactory;
    }

    public LockManager getLockManager() {
        return this.lockManager;
    }

    void registerLifecycleListener(SessionLifecycleListener listener) {
        this.lifecycleListeners.add(listener);
    }

    boolean hasLockToken(String lt) {
        return this.lockTokens.contains(lt);
    }

    public String getLockToken(String lt) {
        for (String token : this.lockTokens) {
            if (!token.equals(lt)) continue;
            return token;
        }
        return null;
    }

    private void initNodeAsDocView(NodeImpl node, XMLWriter writer, boolean skipBinary, boolean noRecurse) throws RepositoryException {
        String name = node.getName();
        if (name.length() == 0) {
            name = "jcr:root";
        }
        Properties attrs = new Properties();
        for (PropertyImpl prop : node.childProperties()) {
            String[] strPropValues = this.getStrPropValues(prop, skipBinary);
            if (strPropValues == null || strPropValues.length == 0) continue;
            String strValues = "";
            for (int i = 0; i < strPropValues.length; ++i) {
                strValues = strValues + strPropValues[i];
                if (i >= strPropValues.length - 1 || strPropValues[i].length() <= 0) continue;
                strValues = strValues + " ";
            }
            attrs.setProperty(prop.getName(), strValues);
        }
        writer.startElement(node.getLocation().getName(), attrs);
        NodeIterator nodes = node.getNodes();
        while (nodes.hasNext()) {
            NodeImpl child = (NodeImpl)nodes.nextNode();
            if (noRecurse) continue;
            if (child.getLocation().getName().getInternalName().equals((Object)Constants.JCR_XMLTEXT)) {
                try {
                    String val = StringConverter.normalizeString(child.getProperty("jcr:xmlcharacters").getString(), false);
                    writer.writeText(val);
                    continue;
                }
                catch (ValueFormatException e) {
                }
                catch (PathNotFoundException e) {
                    // empty catch block
                }
            }
            this.initNodeAsDocView(child, writer, skipBinary, noRecurse);
        }
        writer.endElement();
    }

    private void invokeHandler(byte[] input, ContentHandler contentHandler) throws SAXException, RepositoryException {
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            SAXParser parser = factory.newSAXParser();
            XMLReader reader = parser.getXMLReader();
            reader.setContentHandler(contentHandler);
            reader.setFeature("http://apache.org/xml/features/allow-java-encodings", true);
            reader.parse(new InputSource(new ByteArrayInputStream(input)));
        }
        catch (SAXException e) {
            e.printStackTrace();
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RepositoryException("Can not invoke content handler", (Throwable)e);
        }
    }

    private String[] getStrPropValues(PropertyImpl prop, boolean skipBinary) throws ValueFormatException, RepositoryException {
        String[] values = new String[prop.getValueArray().length];
        if (values.length == 0) {
            return null;
        }
        if (prop.getType() == 2) {
            if (skipBinary) {
                for (int i = 0; i < values.length; ++i) {
                    values[i] = "";
                }
            } else {
                for (int i = 0; i < values.length; ++i) {
                    try {
                        String b64s;
                        TransientValueData data = ((BinaryValue)prop.getValueArray()[i]).getInternalData();
                        values[i] = b64s = new String(Base64.encodeBase64((byte[])BLOBUtil.readValue((ValueData)data)));
                        continue;
                    }
                    catch (IOException e) {
                        throw new RepositoryException("Can't export value data to string: " + e.getMessage(), (Throwable)e);
                    }
                }
            }
        } else {
            for (int i = 0; i < values.length; ++i) {
                Value val = prop.getValueArray()[i];
                try {
                    if (val == null) continue;
                    values[i] = StringConverter.normalizeString(val.getString(), true);
                    continue;
                }
                catch (ValueFormatException e) {
                    if (e.getMessage().equals("empty value")) continue;
                    throw e;
                }
            }
        }
        return values;
    }

    public LocationFactory getLocationFactory() {
        return this.locationFactory;
    }

    public AccessManager getAccessManager() {
        return this.accessManager;
    }

    public String getId() {
        return this.id;
    }

    public ExoContainer getContainer() throws RepositoryException {
        boolean hasPerm = this.getAccessManager().hasPermission(((NodeImpl)this.getRootNode()).getACL(), PermissionType.ALL, this.getUserID());
        return hasPerm ? this.container : null;
    }

    public SessionActionInterceptor getActionHandler() {
        return this.actionHandler;
    }
}

