/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core;

import java.io.IOException;
import java.io.InputStream;
import java.security.AccessControlException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import javax.jcr.AccessDeniedException;
import javax.jcr.InvalidItemStateException;
import javax.jcr.InvalidSerializedDataException;
import javax.jcr.ItemExistsException;
import javax.jcr.NamespaceRegistry;
import javax.jcr.NoSuchWorkspaceException;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.Workspace;
import javax.jcr.lock.LockException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.nodetype.NodeTypeManager;
import javax.jcr.observation.ObservationManager;
import javax.jcr.query.QueryManager;
import javax.jcr.version.Version;
import javax.jcr.version.VersionException;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.logging.Log;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.services.jcr.core.nodetype.ExtendedNodeType;
import org.exoplatform.services.jcr.dataflow.ItemDataChangesLog;
import org.exoplatform.services.jcr.dataflow.ItemDataConsumer;
import org.exoplatform.services.jcr.dataflow.ItemDataVisitor;
import org.exoplatform.services.jcr.dataflow.ItemState;
import org.exoplatform.services.jcr.datamodel.NodeData;
import org.exoplatform.services.jcr.impl.Constants;
import org.exoplatform.services.jcr.impl.core.JCRPath;
import org.exoplatform.services.jcr.impl.core.NamespaceRegistryImpl;
import org.exoplatform.services.jcr.impl.core.NodeImpl;
import org.exoplatform.services.jcr.impl.core.RepositoryImpl;
import org.exoplatform.services.jcr.impl.core.SessionImpl;
import org.exoplatform.services.jcr.impl.core.nodetype.NodeTypeManagerImpl;
import org.exoplatform.services.jcr.impl.core.query.QueryManagerFactory;
import org.exoplatform.services.jcr.impl.core.query.QueryManagerImpl;
import org.exoplatform.services.jcr.impl.core.version.VersionImpl;
import org.exoplatform.services.jcr.impl.dataflow.ItemDataCloneVisitor;
import org.exoplatform.services.jcr.impl.dataflow.ItemDataCopyVisitor;
import org.exoplatform.services.jcr.impl.dataflow.ItemDataMoveVisitor;
import org.exoplatform.services.jcr.impl.dataflow.MutableItemDataChangesLog;
import org.exoplatform.services.jcr.impl.dataflow.session.SessionChangesLog;
import org.exoplatform.services.jcr.impl.dataflow.session.TransactionableDataManager;
import org.exoplatform.services.jcr.impl.dataflow.version.VersionHistoryDataHelper;
import org.exoplatform.services.jcr.impl.xml.NodeImporter;
import org.exoplatform.services.log.ExoLogger;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class WorkspaceImpl
implements Workspace {
    protected static Log log = ExoLogger.getLogger((String)"jcr.WorkspaceImpl");
    private final SessionImpl session;
    private final NamespaceRegistryImpl namespaceRegistry;
    private final NodeTypeManagerImpl nodeTypeManager;
    private final ObservationManager observationManager;
    private final QueryManagerImpl queryManager;
    private final String name;

    public WorkspaceImpl(String name, ExoContainer container, SessionImpl session, ObservationManager observationManager) throws RepositoryException {
        this.session = session;
        this.name = name;
        this.observationManager = observationManager;
        this.namespaceRegistry = (NamespaceRegistryImpl)container.getComponentInstanceOfType(NamespaceRegistry.class);
        this.nodeTypeManager = ((NodeTypeManagerImpl)container.getComponentInstanceOfType(NodeTypeManager.class)).createWorkspaceNTManager(session);
        QueryManagerFactory qf = (QueryManagerFactory)container.getComponentInstanceOfType(QueryManagerFactory.class);
        this.queryManager = qf == null ? null : qf.getQueryManager(session);
    }

    public String getName() {
        return this.name;
    }

    public ContentHandler getImportContentHandler(String parentAbsPath, int uuidBehavior) throws PathNotFoundException, ConstraintViolationException, VersionException, RepositoryException {
        NodeImporter contentHandler = (NodeImporter)this.session.getImportContentHandler(parentAbsPath, uuidBehavior);
        contentHandler.setSaveType(4);
        return contentHandler;
    }

    public void importXML(String parentAbsPath, InputStream in, int uuidBehavior) throws IOException, PathNotFoundException, ItemExistsException, ConstraintViolationException, InvalidSerializedDataException, RepositoryException {
        try {
            NodeImporter importer = (NodeImporter)this.getImportContentHandler(parentAbsPath, uuidBehavior);
            importer.parse(in);
        }
        catch (IOException e) {
            throw new InvalidSerializedDataException("importXML failed", (Throwable)e);
        }
        catch (SAXException e) {
            Throwable rootCause = e.getException();
            if (rootCause == null) {
                rootCause = this.session.getRootCauseException(e);
            }
            if (rootCause == null) {
                rootCause = e;
            }
            if (rootCause instanceof ItemExistsException) {
                throw new ItemExistsException("importXML failed", rootCause);
            }
            if (rootCause instanceof ConstraintViolationException) {
                throw new ConstraintViolationException("importXML failed", rootCause);
            }
            throw new InvalidSerializedDataException("importXML failed", (Throwable)e);
        }
        catch (ParserConfigurationException e) {
            throw new InvalidSerializedDataException("importXML failed", (Throwable)e);
        }
    }

    public Session getSession() {
        return this.session;
    }

    public String[] getAccessibleWorkspaceNames() throws RepositoryException {
        RepositoryImpl rep = (RepositoryImpl)this.session.getRepository();
        return rep.getWorkspaceNames();
    }

    public void copy(String srcWorkspace, String srcAbsPath, String destAbsPath) throws NoSuchWorkspaceException, ConstraintViolationException, VersionException, AccessDeniedException, PathNotFoundException, ItemExistsException, RepositoryException {
        SessionImpl srcSession = null;
        srcSession = this.getName() != srcWorkspace ? ((RepositoryImpl)this.session.getRepository()).login(this.session.getCredentials(), srcWorkspace) : this.session;
        JCRPath destNodePath = this.session.getLocationFactory().parseAbsPath(destAbsPath);
        if (destNodePath.isIndexSetExplicitly()) {
            throw new RepositoryException("The relPath provided must not have an index on its final element. " + destNodePath.getAsString(false));
        }
        JCRPath srcNodePath = srcSession.getLocationFactory().parseAbsPath(srcAbsPath);
        NodeImpl srcNode = (NodeImpl)srcSession.getTransientNodesManager().getItem(srcNodePath.getInternalPath(), true);
        NodeImpl destParentNode = (NodeImpl)this.session.getTransientNodesManager().getItem(destNodePath.makeParentPath().getInternalPath(), true);
        if (srcNode == null || destParentNode == null) {
            throw new PathNotFoundException("No node exists at " + srcAbsPath + " or no node exists one level above " + destAbsPath);
        }
        try {
            destParentNode.checkPermission("add_node");
        }
        catch (AccessControlException e) {
            throw new AccessDeniedException(e.getMessage());
        }
        destParentNode.validateChildNode(destNodePath.getName().getInternalName(), ((ExtendedNodeType)srcNode.getPrimaryNodeType()).getQName());
        NodeImpl destNode = (NodeImpl)this.session.getTransientNodesManager().getItem(destNodePath.getInternalPath(), true);
        if (destNode != null && !destNode.getDefinition().allowsSameNameSiblings()) {
            String msg = "A node with name (" + destAbsPath + ") is already exists.";
            throw new ItemExistsException(msg);
        }
        if (!srcNode.isCheckedOut()) {
            throw new VersionException("Source parent node " + srcNode.getPath() + " or its nearest ancestor is checked-in");
        }
        if (!srcNode.checkLocking()) {
            throw new LockException("Source parent node " + srcNode.getPath() + " is locked ");
        }
        ItemDataCopyVisitor initializer = new ItemDataCopyVisitor((NodeData)destParentNode.getData(), destNodePath.getName().getInternalName(), this.getNodeTypeManager(), srcSession.getTransientNodesManager(), false);
        srcNode.getData().accept((ItemDataVisitor)initializer);
        ItemDataChangesLog changesLog = new ItemDataChangesLog(initializer.getItemAddStates(), this.session.getId());
        this.session.getTransientNodesManager().getTransactManager().save(changesLog);
    }

    public void copy(String srcPath, String destPath) throws ItemExistsException, VersionException, PathNotFoundException, ItemExistsException, ConstraintViolationException, RepositoryException {
        this.copy(this.getName(), srcPath, destPath);
    }

    public void move(String srcAbsPath, String destAbsPath) throws ConstraintViolationException, VersionException, AccessDeniedException, PathNotFoundException, ItemExistsException, RepositoryException {
        JCRPath destNodePath = this.session.getLocationFactory().parseAbsPath(destAbsPath);
        if (destNodePath.isIndexSetExplicitly()) {
            throw new RepositoryException("The relPath provided must not have an index on its final element. " + destNodePath.getAsString(false));
        }
        JCRPath srcNodePath = this.session.getLocationFactory().parseAbsPath(srcAbsPath);
        NodeImpl srcNode = (NodeImpl)this.session.getTransientNodesManager().getItem(srcNodePath.getInternalPath(), true);
        NodeImpl destParentNode = (NodeImpl)this.session.getTransientNodesManager().getItem(destNodePath.makeParentPath().getInternalPath(), true);
        if (srcNode == null || destParentNode == null) {
            throw new PathNotFoundException("No node exists at " + srcAbsPath + " or no node exists one level above " + destAbsPath);
        }
        try {
            destParentNode.checkPermission("add_node");
            srcNode.checkPermission("remove");
        }
        catch (AccessControlException e) {
            throw new AccessDeniedException(e.getMessage());
        }
        destParentNode.validateChildNode(destNodePath.getName().getInternalName(), ((ExtendedNodeType)srcNode.getPrimaryNodeType()).getQName());
        NodeImpl destNode = (NodeImpl)this.session.getTransientNodesManager().getItem(destNodePath.getInternalPath(), true);
        if (destNode != null && !destNode.getDefinition().allowsSameNameSiblings()) {
            String msg = "A node with name (" + destAbsPath + ") is already exists.";
            throw new ItemExistsException(msg);
        }
        if (!srcNode.isCheckedOut()) {
            throw new VersionException("Source parent node " + srcNode.getPath() + " or its nearest ancestor is checked-in");
        }
        if (!srcNode.checkLocking()) {
            throw new LockException("Source parent node " + srcNode.getPath() + " is     locked ");
        }
        ItemDataMoveVisitor initializer = new ItemDataMoveVisitor((NodeData)destParentNode.getData(), destNodePath.getName().getInternalName(), this.getNodeTypeManager(), this.session.getTransientNodesManager(), srcNode.isNodeType(Constants.MIX_REFERENCEABLE));
        srcNode.getData().accept((ItemDataVisitor)initializer);
        MutableItemDataChangesLog changes = new MutableItemDataChangesLog(this.session.getId());
        changes.addAll(initializer.getItemDeletedStates(true));
        changes.addAll(this.session.getTransientNodesManager().reindexSameNameSiblings(srcNode.nodeData(), (ItemDataConsumer)this.session.getTransientNodesManager().getTransactManager()));
        changes.addAll(initializer.getItemAddStates());
        this.session.getTransientNodesManager().getTransactManager().save(changes);
    }

    public void clone(String srcWorkspace, String srcAbsPath, String destAbsPath, boolean removeExisting) throws NoSuchWorkspaceException, ConstraintViolationException, VersionException, AccessDeniedException, PathNotFoundException, ItemExistsException, RepositoryException {
        if (srcWorkspace.equals(this.getName())) {
            throw new RepositoryException("Source and destination workspace are equals " + this.name);
        }
        JCRPath destNodePath = this.session.getLocationFactory().parseAbsPath(destAbsPath);
        if (destNodePath.isIndexSetExplicitly()) {
            throw new RepositoryException("DestPath should not contain an index " + destAbsPath);
        }
        SessionImpl srcSession = ((RepositoryImpl)this.session.getRepository()).login(this.session.getCredentials(), srcWorkspace);
        JCRPath srcNodePath = srcSession.getLocationFactory().parseAbsPath(srcAbsPath);
        NodeImpl srcNode = (NodeImpl)srcSession.getTransientNodesManager().getItem(srcNodePath.getInternalPath(), true);
        NodeImpl destParentNode = (NodeImpl)this.session.getTransientNodesManager().getItem(destNodePath.makeParentPath().getInternalPath(), true);
        if (srcNode == null || destParentNode == null) {
            throw new PathNotFoundException("No node exists at " + srcAbsPath + " or no node exists one level above " + destAbsPath);
        }
        try {
            destParentNode.checkPermission("add_node");
        }
        catch (AccessControlException e) {
            throw new AccessDeniedException(e.getMessage());
        }
        destParentNode.validateChildNode(destNodePath.getName().getInternalName(), ((ExtendedNodeType)srcNode.getPrimaryNodeType()).getQName());
        NodeImpl destNode = (NodeImpl)this.session.getTransientNodesManager().getItem(destNodePath.getInternalPath(), true);
        if (destNode != null && !destNode.getDefinition().allowsSameNameSiblings()) {
            String msg = "A node with name (" + destAbsPath + ") is already exists.";
            throw new ItemExistsException(msg);
        }
        if (!srcNode.isCheckedOut()) {
            throw new VersionException("Source parent node " + srcNode.getPath() + " or its nearest ancestor is checked-in");
        }
        if (!srcNode.checkLocking()) {
            throw new LockException("Source parent node " + srcNode.getPath() + " is     locked ");
        }
        ItemDataCloneVisitor initializer = new ItemDataCloneVisitor((NodeData)destParentNode.getData(), destNodePath.getName().getInternalName(), this.getNodeTypeManager(), srcSession.getTransientNodesManager(), this.session.getTransientNodesManager(), removeExisting);
        srcNode.getData().accept((ItemDataVisitor)initializer);
        MutableItemDataChangesLog changes = new MutableItemDataChangesLog(this.session.getId());
        if (removeExisting && initializer.getItemDeletedExistingStates(false).size() > 0) {
            changes.addAll(initializer.getItemDeletedExistingStates(true));
        }
        changes.addAll(initializer.getItemAddStates());
        this.session.getTransientNodesManager().getTransactManager().save(changes);
    }

    public QueryManager getQueryManager() throws RepositoryException {
        if (this.queryManager == null) {
            throw new RepositoryException("Query Manager Factory not found. Check configuration.");
        }
        return this.queryManager;
    }

    public NodeTypeManagerImpl getNodeTypeManager() throws RepositoryException {
        return this.nodeTypeManager;
    }

    public NamespaceRegistry getNamespaceRegistry() throws RepositoryException {
        return this.namespaceRegistry;
    }

    public ObservationManager getObservationManager() throws UnsupportedRepositoryOperationException, RepositoryException {
        return this.observationManager;
    }

    public void restore(Version[] versions, boolean removeExisting) throws UnsupportedRepositoryOperationException, VersionException, RepositoryException, InvalidItemStateException {
        this.restoreVersions(versions, removeExisting);
    }

    protected void restoreVersions(Version[] versions, boolean removeExisting) throws UnsupportedRepositoryOperationException, VersionException, RepositoryException, InvalidItemStateException {
        if (this.session.hasPendingChanges()) {
            throw new InvalidItemStateException("Session has pending changes ");
        }
        ArrayList<String> existedUuids = new ArrayList<String>();
        ArrayList<VersionImpl> notExistedVersions = new ArrayList<VersionImpl>();
        LinkedHashMap<VersionImpl, NodeData> existedVersions = new LinkedHashMap<VersionImpl, NodeData>();
        TransactionableDataManager dataManager = this.session.getTransientNodesManager().getTransactManager();
        for (Version v : versions) {
            String versionableUuid = v.getContainingHistory().getVersionableUUID();
            NodeData node = (NodeData)dataManager.getItemData(versionableUuid);
            if (node != null) {
                existedVersions.put((VersionImpl)v, node);
                existedUuids.add(versionableUuid);
                continue;
            }
            NodeData corrNode = null;
            String versionableParentUuid = null;
            if (!v.getSession().getWorkspace().getName().equals(this.session.getWorkspace().getName())) {
                TransactionableDataManager vDataManager = ((SessionImpl)v.getSession()).getTransientNodesManager().getTransactManager();
                corrNode = (NodeData)vDataManager.getItemData(versionableUuid);
                if (corrNode != null) {
                    versionableParentUuid = corrNode.getParentUUID();
                } else {
                    log.warn((Object)("Workspace.restore(). Correspondent node is not found " + versionableUuid));
                }
            }
            if (versionableParentUuid != null && existedUuids.contains(versionableParentUuid)) {
                notExistedVersions.add((VersionImpl)v);
                continue;
            }
            throw new VersionException("No such node (for version, from the array of versions, that corresponds to a missing node in the workspace, there must also be a parent in the array). UUID: " + versionableUuid);
        }
        SessionChangesLog changesLog = new SessionChangesLog(this.session.getId());
        for (VersionImpl v : existedVersions.keySet()) {
            try {
                NodeData node = (NodeData)existedVersions.get(v);
                VersionHistoryDataHelper historyData = v.getContainingHistory().getData();
                changesLog.addAll(v.restoreLog(node, historyData, this.session, removeExisting, changesLog).getAllStates());
            }
            catch (ItemExistsException e) {
                throw new ItemExistsException("Workspace restore. Can't restore a node. " + v.getContainingHistory().getVersionableUUID() + ". " + e.getMessage(), (Throwable)e);
            }
            catch (RepositoryException e) {
                throw new RepositoryException("Workspace restore. Can't restore a node. " + v.getContainingHistory().getVersionableUUID() + ". Repository error: " + e.getMessage(), (Throwable)e);
            }
        }
        for (VersionImpl v : notExistedVersions) {
            String versionableUuid = v.getContainingHistory().getVersionableUUID();
            try {
                NodeData node = null;
                for (ItemState change : changesLog.getAllStates()) {
                    if (!change.isNode() || !change.isAdded() || !((NodeData)change.getData()).getUUID().equals(versionableUuid)) continue;
                    node = (NodeData)change.getData();
                    break;
                }
                if (node != null) {
                    VersionHistoryDataHelper historyData = v.getContainingHistory().getData();
                    changesLog.addAll(v.restoreLog(node, historyData, this.session, removeExisting, changesLog).getAllStates());
                    continue;
                }
                throw new VersionException("No such node restored before (for version, from the array of versions, that corresponds to a missing node in the workspace, there must also be a parent in the array). UUID: " + versionableUuid);
            }
            catch (ItemExistsException e) {
                throw new ItemExistsException("Workspace restore. Can't restore a node not existed before. " + versionableUuid + ". " + e.getMessage(), (Throwable)e);
            }
            catch (RepositoryException e) {
                throw new RepositoryException("Workspace restore. Can't restore a node not existed before. " + versionableUuid + ". Repository error: " + e.getMessage(), (Throwable)e);
            }
        }
        dataManager.save(changesLog);
    }
}

