/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core;

import javax.jcr.Credentials;
import javax.jcr.RepositoryException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.services.jcr.core.XASession;
import org.exoplatform.services.jcr.impl.core.SessionImpl;
import org.exoplatform.services.jcr.impl.dataflow.session.TransactionableResourceManager;
import org.exoplatform.services.transaction.TransactionException;
import org.exoplatform.services.transaction.TransactionService;
import org.objectweb.transaction.jta.ResourceManagerEvent;

public class XASessionImpl
extends SessionImpl
implements XASession,
XAResource,
ResourceManagerEvent {
    private TransactionService tService;
    private int txTimeout;
    private TransactionableResourceManager txResourceManager = null;
    private int startFlags = 0;

    XASessionImpl(String workspaceName, Credentials credentials, ExoContainer container, TransactionService tService, TransactionableResourceManager txResourceManager) throws RepositoryException {
        super(workspaceName, credentials, container);
        this.txTimeout = tService.getDefaultTimeout();
        this.tService = tService;
        this.txResourceManager = txResourceManager;
        this.txResourceManager.join(this);
    }

    public XAResource getXAResource() {
        return this;
    }

    public void delistResource() throws XAException {
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Delist session: " + this.getSessionInfo() + ", " + this));
            }
            this.tService.delistResource((XAResource)this);
        }
        catch (RollbackException e) {
            throw new XAException(e.getMessage());
        }
        catch (SystemException e) {
            throw new XAException(e.getMessage());
        }
    }

    public void enlistResource() throws XAException {
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Enlist session: " + this.getSessionInfo() + ", " + this));
            }
            this.tService.enlistResource((XAResource)this);
        }
        catch (RollbackException e) {
            throw new XAException(e.getMessage());
        }
        catch (SystemException e) {
            throw new XAException(e.getMessage());
        }
    }

    public void commit(Xid xid, boolean onePhase) throws XAException {
        try {
            this.txResourceManager.commit(this);
        }
        catch (TransactionException e) {
            throw new XAException(104);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Commit. Xid:" + xid + ", session: " + this.getSessionInfo() + ", " + this));
        }
    }

    public void end(Xid xid, int flags) throws XAException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("End. Xid:" + xid + ", " + flags + ", session: " + this.getSessionInfo() + ", " + this));
        }
        this.startFlags = flags;
    }

    public void forget(Xid xid) throws XAException {
    }

    public int getTransactionTimeout() throws XAException {
        return this.txTimeout;
    }

    public boolean isSameRM(XAResource resource) throws XAException {
        if (resource instanceof XASessionImpl) {
            XASessionImpl session = (XASessionImpl)resource;
            boolean isSame = this.getUserID().equals(session.getUserID());
            if (log.isDebugEnabled()) {
                log.debug((Object)("isSameRM: " + this.getSessionInfo() + " -- " + session.getSessionInfo() + " : " + isSame + ", " + this + " -- " + session + ", Flags:" + this.startFlags));
            }
            return isSame;
        }
        return false;
    }

    public int prepare(Xid xid) throws XAException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Prepare. Xid:" + xid + ", session: " + this.getSessionInfo() + ", " + this));
        }
        return 0;
    }

    public Xid[] recover(int xid) throws XAException {
        return null;
    }

    public void rollback(Xid xid) throws XAException {
        this.txResourceManager.rollback(this);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Rollback. Xid:" + xid + ", session: " + this.getSessionInfo() + ", " + this));
        }
    }

    public boolean setTransactionTimeout(int seconds) throws XAException {
        try {
            this.tService.setTransactionTimeout(seconds);
        }
        catch (SystemException e) {
            throw new XAException(e.getMessage());
        }
        this.txTimeout = seconds;
        return true;
    }

    public void start(Xid xid, int flags) throws XAException {
        this.txResourceManager.start(this);
        this.startFlags = flags;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Start. Xid:" + xid + ", " + flags + ", session: " + this.getSessionInfo() + ", " + this));
        }
    }

    public void logout() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Logout. Session: " + this.getSessionInfo() + ", " + this));
        }
        this.getTransientNodesManager().getTransactManager().rollback();
        super.logout();
        try {
            this.delistResource();
            this.startFlags = 0;
        }
        catch (XAException e) {
            e.printStackTrace();
        }
    }

    public void enlistConnection(Transaction transaction) throws SystemException {
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Enlist connection. Session: " + this.getSessionInfo() + ", " + this + ", transaction: " + transaction));
            }
            this.enlistResource();
        }
        catch (IllegalStateException e) {
            throw new SystemException(e.getMessage());
        }
        catch (XAException e) {
            throw new SystemException(e.getMessage());
        }
    }
}

