/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.lock;

import javax.jcr.RepositoryException;
import javax.jcr.lock.Lock;
import javax.jcr.lock.LockException;
import org.exoplatform.services.jcr.impl.core.NodeImpl;
import org.exoplatform.services.jcr.impl.core.lock.LockData;
import org.exoplatform.services.jcr.impl.core.lock.LockManager;

public class LockImpl
extends LockData
implements Lock {
    private boolean live;
    private NodeImpl node;
    private LockManager manager;

    LockImpl(LockManager manager, LockData data, boolean live, NodeImpl node) {
        super(data.getNode(), data.isDeep(), data.isSessionScoped());
        this.live = live;
        this.node = node;
        this.manager = manager;
    }

    public String getLockOwner() {
        return this.lockHolder.getSession().getUserID();
    }

    public String getLockToken() {
        return this.node.getSession().getLockToken(this.lockHolder.getInternalUUID());
    }

    public boolean isLive() throws RepositoryException {
        return this.manager.getLock(this.node, false) != null;
    }

    public void refresh() throws LockException, RepositoryException {
        if (this.isLive()) {
            return;
        }
        throw new LockException("Lock is not live");
    }

    void setLive(boolean live) {
        this.live = live;
    }
}

