/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.lock;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.jcr.AccessDeniedException;
import javax.jcr.RepositoryException;
import javax.jcr.lock.Lock;
import org.apache.commons.logging.Log;
import org.exoplatform.services.jcr.impl.core.NodeImpl;
import org.exoplatform.services.jcr.impl.core.SessionImpl;
import org.exoplatform.services.jcr.impl.core.SessionLifecycleListener;
import org.exoplatform.services.jcr.impl.core.lock.LockData;
import org.exoplatform.services.jcr.impl.core.lock.LockImpl;
import org.exoplatform.services.log.ExoLogger;

public class LockManager
implements SessionLifecycleListener {
    private static Log log = ExoLogger.getLogger((String)"jcr.LockManager");
    private Map<String, LockData> locks = new HashMap<String, LockData>();

    public synchronized Lock addLock(NodeImpl lockHolder, boolean deep, boolean sessionScoped) throws RepositoryException {
        LockData data = new LockData(lockHolder, deep, sessionScoped);
        lockHolder.getSession().addLockToken(this.getLockToken(lockHolder));
        this.locks.put(this.getLockToken(lockHolder), data);
        return new LockImpl(this, data, true, lockHolder);
    }

    public synchronized void removeLock(NodeImpl lockHolder) {
        lockHolder.getSession().removeLockToken(this.getLockToken(lockHolder));
        this.locks.remove(this.getLockToken(lockHolder));
    }

    public synchronized LockImpl getLock(NodeImpl node, boolean holdOnly) throws AccessDeniedException, RepositoryException {
        if (!node.hasPermission("read")) {
            throw new AccessDeniedException("Get Lock Access denied " + node.getPath());
        }
        LockData lock = this.locks.get(this.getLockToken(node));
        if (lock == null && !holdOnly) {
            for (LockData lock1 : this.locks.values()) {
                if (!lock1.isDeep() || !node.getLocation().isDescendantOf(lock1.getNode().getLocation(), false)) continue;
                lock = lock1;
                break;
            }
        }
        return this.createLock(node, lock);
    }

    public synchronized LockImpl getChildLock(NodeImpl node) throws AccessDeniedException, RepositoryException {
        if (!node.hasPermission("read")) {
            throw new AccessDeniedException("Get Lock Access denied " + node.getPath());
        }
        LockData lock = null;
        for (LockData lock1 : this.locks.values()) {
            if (!lock1.getNode().getLocation().isDescendantOf(node.getLocation(), false)) continue;
            lock = lock1;
            break;
        }
        return this.createLock(node, lock);
    }

    public synchronized String getLockToken(NodeImpl node) {
        LockData lockData = null;
        for (LockData lock1 : this.locks.values()) {
            if (!lock1.isDeep() || !node.getLocation().isDescendantOf(lock1.getNode().getLocation(), false)) continue;
            if (lockData == null) {
                lockData = lock1;
                continue;
            }
            if (lockData.getNode().getDepth() >= lock1.getNode().getDepth()) continue;
            lockData = lock1;
        }
        if (lockData != null) {
            return lockData.getNode().getInternalUUID();
        }
        return node.getInternalUUID();
    }

    private LockImpl createLock(NodeImpl node, LockData data) {
        if (data == null) {
            return null;
        }
        return new LockImpl(this, data, true, node);
    }

    public void onCloseSession(SessionImpl session) {
        ArrayList<String> remove = new ArrayList<String>();
        for (Map.Entry<String, LockData> lockEntry : this.locks.entrySet()) {
            LockData lock = lockEntry.getValue();
            if (lock.getNode().isValid()) {
                if (!lock.isSessionScoped() || !lock.getNode().getSession().equals(session)) continue;
                remove.add(this.getLockToken(lock.getNode()));
                continue;
            }
            remove.add(lockEntry.getKey());
        }
        for (String lockTocken : remove) {
            this.locks.remove(lockTocken);
        }
    }
}

