/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.observation;

import javax.jcr.RepositoryException;
import javax.jcr.observation.EventIterator;
import javax.jcr.observation.EventListener;
import javax.jcr.observation.EventListenerIterator;
import org.apache.commons.logging.Log;
import org.exoplatform.services.jcr.core.nodetype.ExtendedNodeType;
import org.exoplatform.services.jcr.dataflow.ItemDataChangesLog;
import org.exoplatform.services.jcr.dataflow.ItemState;
import org.exoplatform.services.jcr.dataflow.persistent.ItemsPersistenceListener;
import org.exoplatform.services.jcr.datamodel.InternalQName;
import org.exoplatform.services.jcr.datamodel.InternalQPath;
import org.exoplatform.services.jcr.datamodel.ItemData;
import org.exoplatform.services.jcr.datamodel.NodeData;
import org.exoplatform.services.jcr.impl.core.nodetype.NodeTypeManagerImpl;
import org.exoplatform.services.jcr.impl.core.observation.EventImpl;
import org.exoplatform.services.jcr.impl.core.observation.ListenerCriteria;
import org.exoplatform.services.jcr.impl.core.observation.ObservationManagerRegistry;
import org.exoplatform.services.jcr.impl.dataflow.persistent.WorkspacePersistentDataManager;
import org.exoplatform.services.jcr.impl.util.EntityCollection;
import org.exoplatform.services.log.ExoLogger;

public class ActionLauncher
implements ItemsPersistenceListener {
    public final int SKIP_EVENT = Integer.MIN_VALUE;
    private static Log log = ExoLogger.getLogger((String)"jcr.ActionLauncher");
    private ObservationManagerRegistry observationRegistry;
    private WorkspacePersistentDataManager workspaceDataManager;

    public ActionLauncher(ObservationManagerRegistry registry, WorkspacePersistentDataManager workspaceDataManager) {
        this.observationRegistry = registry;
        this.workspaceDataManager = workspaceDataManager;
        workspaceDataManager.addItemPersistenceListener(this);
    }

    public void onSaveItems(ItemDataChangesLog changesLog) {
        EventListenerIterator eventListeners = this.observationRegistry.getEventListeners();
        while (eventListeners.hasNext()) {
            EventListener listener = eventListeners.nextEventListener();
            ListenerCriteria criteria = this.observationRegistry.getListenerFilter(listener);
            EntityCollection events = new EntityCollection();
            for (ItemState itemState : changesLog.getAllStates()) {
                if (!itemState.isEventFire()) continue;
                ItemData item = itemState.getData();
                try {
                    int eventType = this.eventType(itemState);
                    if (eventType == Integer.MIN_VALUE || !this.isTypeMatch(criteria, eventType) || !this.isPathMatch(criteria, item) || !this.isUUIDMatch(criteria, item) || !this.isNodeTypeMatch(criteria, item) || !this.isSessionMatch(criteria, changesLog.getSessionId())) continue;
                    String path = criteria.getSession().getLocationFactory().createJCRPath(item.getQPath()).getAsString(false);
                    events.add(new EventImpl(eventType, path, criteria.getSession().getUserID()));
                }
                catch (RepositoryException e) {
                    log.error((Object)("Can not fire ActionLauncher.onSaveItems() for " + item.getQPath().getAsString() + " reason: " + (Object)((Object)e)));
                }
            }
            if (events.size() <= 0L) continue;
            listener.onEvent((EventIterator)events);
        }
    }

    private boolean isTypeMatch(ListenerCriteria criteria, int state) {
        return (criteria.getEventTypes() & state) > 0;
    }

    private boolean isSessionMatch(ListenerCriteria criteria, String sessionId) {
        return !criteria.getNoLocal() || !criteria.getSession().getId().equals(sessionId);
    }

    private boolean isPathMatch(ListenerCriteria criteria, ItemData item) {
        if (criteria.getAbsPath() == null) {
            return true;
        }
        try {
            InternalQPath cLoc = criteria.getSession().getLocationFactory().parseAbsPath(criteria.getAbsPath()).getInternalPath();
            InternalQPath itemPath = item.getQPath();
            if (item.isNode()) {
                boolean isAtAbsPathNode = cLoc.equals((Object)itemPath);
                if (isAtAbsPathNode) {
                    return true;
                }
                if (criteria.isDeep()) {
                    return itemPath.isDescendantOf(cLoc, false);
                }
                return false;
            }
            return itemPath.isDescendantOf(cLoc, !criteria.isDeep());
        }
        catch (RepositoryException e) {
            return false;
        }
    }

    private boolean isUUIDMatch(ListenerCriteria criteria, ItemData item) {
        if (criteria.getUuid() == null) {
            return true;
        }
        for (int i = 0; i < criteria.getUuid().length; ++i) {
            if (item.isNode() && criteria.getUuid()[i].equals(item.getUUID())) {
                return true;
            }
            if (item.isNode() || !criteria.getUuid()[i].equals(item.getParentUUID())) continue;
            return true;
        }
        return false;
    }

    private boolean isNodeTypeMatch(ListenerCriteria criteria, ItemData item) throws RepositoryException {
        if (criteria.getNodeTypeName() == null) {
            return true;
        }
        NodeData node = (NodeData)this.workspaceDataManager.getItemData(item.getParentUUID());
        if (node == null) {
            return false;
        }
        NodeTypeManagerImpl ntManager = criteria.getSession().getWorkspace().getNodeTypeManager();
        for (int i = 0; i < criteria.getNodeTypeName().length; ++i) {
            ExtendedNodeType criteriaNT = (ExtendedNodeType)ntManager.getNodeType(criteria.getNodeTypeName()[i]);
            InternalQName[] testQNames = criteriaNT.isMixin() ? node.getMixinTypeNames() : new InternalQName[]{node.getPrimaryTypeName()};
            if (!ntManager.isNodeType(criteriaNT.getQName(), testQNames)) continue;
            return true;
        }
        return false;
    }

    private int eventType(ItemState state) throws RepositoryException {
        if (state.getData().isNode()) {
            if (state.isAdded() || state.isOrderAdded()) {
                return 1;
            }
            if (state.isDeleted() || state.isOrderDeleted()) {
                return 2;
            }
            if (state.isUpdated()) {
                return Integer.MIN_VALUE;
            }
            if (state.isUnchanged()) {
                return Integer.MIN_VALUE;
            }
        } else {
            if (state.isAdded()) {
                return 4;
            }
            if (state.isDeleted()) {
                return 8;
            }
            if (state.isUpdated()) {
                return 16;
            }
            if (state.isUnchanged()) {
                return Integer.MIN_VALUE;
            }
        }
        throw new RepositoryException("Unexpected ItemState for Node " + ItemState.nameFromValue((int)state.getState()) + " " + state.getData().getQPath().getAsString());
    }
}

