/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.observation;

import javax.jcr.RepositoryException;
import javax.jcr.observation.EventListener;
import javax.jcr.observation.EventListenerIterator;
import javax.jcr.observation.ObservationManager;
import org.exoplatform.services.jcr.impl.core.SessionImpl;
import org.exoplatform.services.jcr.impl.core.SessionLifecycleListener;
import org.exoplatform.services.jcr.impl.core.observation.ListenerCriteria;
import org.exoplatform.services.jcr.impl.core.observation.ObservationManagerRegistry;

public class ObservationManagerImpl
implements ObservationManager,
SessionLifecycleListener {
    protected SessionImpl session;
    private ObservationManagerRegistry registry;

    ObservationManagerImpl(ObservationManagerRegistry registry, SessionImpl session) {
        this.session = session;
        this.registry = registry;
    }

    public void addEventListener(EventListener listener, int eventTypes, String absPath, boolean isDeep, String[] uuid, String[] nodeTypeName, boolean noLocal) throws RepositoryException {
        this.registry.addEventListener(listener, new ListenerCriteria(eventTypes, absPath, isDeep, uuid, nodeTypeName, noLocal, this.session));
    }

    public void removeEventListener(EventListener listener) throws RepositoryException {
        this.registry.removeEventListener(listener);
    }

    public EventListenerIterator getRegisteredEventListeners() throws RepositoryException {
        return this.registry.getEventListeners();
    }

    public SessionImpl getSession() {
        return this.session;
    }

    public void onCloseSession(SessionImpl targetSession) {
        if (this.getSession() == targetSession) {
            this.registry.removeSessionEventListeners(targetSession);
        }
    }
}

