/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.query;

import javax.jcr.ItemExistsException;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.lock.LockException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.query.InvalidQueryException;
import javax.jcr.query.QueryResult;
import javax.jcr.version.VersionException;
import org.exoplatform.services.jcr.dataflow.ItemState;
import org.exoplatform.services.jcr.datamodel.InternalQPath;
import org.exoplatform.services.jcr.datamodel.ItemData;
import org.exoplatform.services.jcr.datamodel.NodeData;
import org.exoplatform.services.jcr.impl.Constants;
import org.exoplatform.services.jcr.impl.core.JCRPath;
import org.exoplatform.services.jcr.impl.core.NodeImpl;
import org.exoplatform.services.jcr.impl.core.SessionImpl;
import org.exoplatform.services.jcr.impl.core.query.AbstractQueryImpl;
import org.exoplatform.services.jcr.impl.core.query.ExecutableQuery;
import org.exoplatform.services.jcr.impl.core.query.QueryHandler;
import org.exoplatform.services.jcr.impl.dataflow.TransientNodeData;
import org.exoplatform.services.jcr.impl.dataflow.TransientPropertyData;
import org.exoplatform.services.jcr.impl.dataflow.TransientValueData;

public class QueryImpl
extends AbstractQueryImpl {
    private SessionImpl session;
    private String statement;
    private String language;
    private ExecutableQuery query;
    private Node node;
    private QueryHandler handler;
    private boolean initialized = false;

    public void init(SessionImpl session, QueryHandler handler, String statement, String language) throws InvalidQueryException {
        this.checkNotInitialized();
        this.session = session;
        this.statement = statement;
        this.language = language;
        this.query = handler.createExecutableQuery(session, statement, language);
        this.initialized = true;
    }

    public void init(SessionImpl session, QueryHandler handler, Node node) throws InvalidQueryException, RepositoryException {
        this.checkNotInitialized();
        this.session = session;
        this.node = node;
        this.handler = handler;
        try {
            if (!node.isNodeType("nt:query")) {
                throw new InvalidQueryException("node is not of type nt:query");
            }
            this.statement = node.getProperty("jcr:statement").getString();
            this.language = node.getProperty("jcr:language").getString();
            this.query = handler.createExecutableQuery(session, this.statement, this.language);
        }
        catch (Exception e) {
            throw new RepositoryException(e.getMessage(), (Throwable)e);
        }
        this.initialized = true;
    }

    public QueryResult execute() throws RepositoryException {
        return this.query.execute();
    }

    public String getStatement() {
        return this.statement;
    }

    public String getLanguage() {
        return this.language;
    }

    public String getStoredQueryPath() throws ItemNotFoundException, RepositoryException {
        if (this.node == null) {
            throw new ItemNotFoundException("not a persistent query");
        }
        return this.node.getPath();
    }

    public Node storeAsNode(String absPath) throws ItemExistsException, PathNotFoundException, VersionException, ConstraintViolationException, LockException, UnsupportedRepositoryOperationException, RepositoryException {
        JCRPath path = this.session.getLocationFactory().parseAbsPath(absPath);
        InternalQPath qpath = path.getInternalPath();
        NodeImpl parent = (NodeImpl)this.session.getTransientNodesManager().getItem(qpath.makeParentPath(), false);
        if (parent == null) {
            throw new PathNotFoundException("Parent not found for " + path.getAsString(false));
        }
        parent.validateChildNode(qpath.getName(), Constants.NT_QUERY);
        TransientNodeData queryData = TransientNodeData.createNodeData((NodeData)parent.getData(), qpath.getName(), Constants.NT_QUERY);
        NodeImpl queryNode = (NodeImpl)this.session.getTransientNodesManager().update(ItemState.createAddedState((ItemData)queryData), false);
        queryNode.addAutoCreatedItems(Constants.NT_QUERY);
        TransientValueData value = new TransientValueData(this.language);
        TransientPropertyData jcrLanguage = TransientPropertyData.createPropertyData((NodeData)queryData, Constants.JCR_LANGUAGE, 1, false, value);
        this.session.getTransientNodesManager().update(ItemState.createAddedState((ItemData)jcrLanguage), false);
        value = new TransientValueData(this.statement);
        TransientPropertyData jcrStatement = TransientPropertyData.createPropertyData((NodeData)queryData, Constants.JCR_STATEMENT, 1, false, value);
        this.session.getTransientNodesManager().update(ItemState.createAddedState((ItemData)jcrStatement), false);
        this.node = queryNode;
        return this.node;
    }

    protected void checkNotInitialized() {
        if (this.initialized) {
            throw new IllegalStateException("already initialized");
        }
    }

    protected void checkInitialized() {
        if (!this.initialized) {
            throw new IllegalStateException("not initialized");
        }
    }
}

