/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.query;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.query.InvalidQueryException;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import org.exoplatform.services.jcr.impl.core.SessionImpl;
import org.exoplatform.services.jcr.impl.core.query.SearchManager;
import org.exoplatform.services.log.LogService;

public class QueryManagerImpl
implements QueryManager {
    private static final String[] SUPPORTED_QUERIES = new String[]{"sql", "xpath"};
    private static final List SUPPORTED_QUERIES_LIST = Collections.unmodifiableList(Arrays.asList(SUPPORTED_QUERIES));
    private final SessionImpl session;
    private final SearchManager searchMgr;

    public QueryManagerImpl(SessionImpl session, SearchManager searchMgr, LogService logService) {
        this.session = session;
        this.searchMgr = searchMgr;
    }

    public Query createQuery(String statement, String language) throws InvalidQueryException, RepositoryException {
        return this.searchMgr.createQuery(this.session, statement, language);
    }

    public Query getQuery(Node node) throws InvalidQueryException, RepositoryException {
        return this.searchMgr.createQuery(this.session, node);
    }

    public String[] getSupportedQueryLanguages() throws RepositoryException {
        return SUPPORTED_QUERIES_LIST.toArray(new String[SUPPORTED_QUERIES.length]);
    }
}

