/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.query.lucene;

import java.io.IOException;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import javax.jcr.RepositoryException;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermDocs;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.HitCollector;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Searcher;
import org.apache.lucene.search.Similarity;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.Weight;
import org.exoplatform.services.jcr.datamodel.InternalQName;
import org.exoplatform.services.jcr.datamodel.NodeData;
import org.exoplatform.services.jcr.impl.core.query.lucene.FieldNames;
import org.exoplatform.services.jcr.impl.dataflow.session.WorkspaceStorageDataManagerProxy;

class ChildAxisQuery
extends Query {
    private final WorkspaceStorageDataManagerProxy itemMgr;
    private final Query contextQuery;
    private final String nameTest;
    private final int position;
    private Scorer contextScorer;
    private Scorer nameTestScorer;

    ChildAxisQuery(WorkspaceStorageDataManagerProxy itemMgr, Query context, String nameTest) {
        this(itemMgr, context, nameTest, -2147483647);
    }

    ChildAxisQuery(WorkspaceStorageDataManagerProxy itemMgr, Query context, String nameTest, int position) {
        this.itemMgr = itemMgr;
        this.contextQuery = context;
        this.nameTest = nameTest;
        this.position = position;
    }

    protected Weight createWeight(Searcher searcher) {
        return new ChildAxisWeight(searcher);
    }

    public String toString(String field) {
        return "ChildAxisQuery";
    }

    public static class NodeDatasOrderComparator
    implements Comparator {
        public int compare(Object o1, Object o2) {
            NodeData n1 = (NodeData)o1;
            NodeData n2 = (NodeData)o2;
            return n1.getOrderNumber() - n2.getOrderNumber();
        }
    }

    private class ChildAxisScorer
    extends Scorer {
        private final IndexReader reader;
        private final BitSet hits;
        private List uuids;
        private int nextDoc;

        protected ChildAxisScorer(Similarity similarity, IndexReader reader) {
            super(similarity);
            this.uuids = null;
            this.nextDoc = -1;
            this.reader = reader;
            this.hits = new BitSet(reader.maxDoc());
        }

        public boolean next() throws IOException {
            this.calculateChildren();
            this.nextDoc = this.hits.nextSetBit(this.nextDoc + 1);
            return this.nextDoc > -1;
        }

        public int doc() {
            return this.nextDoc;
        }

        public float score() throws IOException {
            return 1.0f;
        }

        public boolean skipTo(int target) throws IOException {
            this.nextDoc = this.hits.nextSetBit(target);
            return this.nextDoc > -1;
        }

        public Explanation explain(int doc) throws IOException {
            throw new UnsupportedOperationException();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void calculateChildren() throws IOException {
            if (this.uuids == null) {
                this.uuids = new ArrayList();
                ChildAxisQuery.this.contextScorer.score(new HitCollector(){

                    public void collect(int doc, float score) {
                        ChildAxisScorer.this.hits.set(doc);
                    }
                });
                final BitSet nameTestHits = new BitSet();
                if (ChildAxisQuery.this.nameTestScorer != null) {
                    ChildAxisQuery.this.nameTestScorer.score(new HitCollector(){

                        public void collect(int doc, float score) {
                            nameTestHits.set(doc);
                        }
                    });
                }
                int i = this.hits.nextSetBit(0);
                while (i >= 0) {
                    String uuid = this.reader.document(i).get(FieldNames.UUID);
                    this.uuids.add(uuid);
                    i = this.hits.nextSetBit(i + 1);
                }
                this.hits.clear();
                TermDocs docs = this.reader.termDocs();
                try {
                    Iterator it = this.uuids.iterator();
                    while (it.hasNext()) {
                        docs.seek(new Term(FieldNames.PARENT, (String)it.next()));
                        while (docs.next()) {
                            this.hits.set(docs.doc());
                        }
                    }
                }
                finally {
                    docs.close();
                }
                if (ChildAxisQuery.this.nameTestScorer != null) {
                    this.hits.and(nameTestHits);
                }
                if (ChildAxisQuery.this.position != -2147483647) {
                    int i2 = this.hits.nextSetBit(0);
                    while (i2 >= 0) {
                        Document node = this.reader.document(i2);
                        String parentUUID = node.get(FieldNames.PARENT);
                        String uuid = node.get(FieldNames.UUID);
                        try {
                            List c;
                            NodeData entry;
                            NodeData state = (NodeData)ChildAxisQuery.this.itemMgr.getItemData(parentUUID);
                            if (ChildAxisQuery.this.nameTest == null) {
                                List c2;
                                if (ChildAxisQuery.this.position == Integer.MIN_VALUE) {
                                    c2 = this.getOrderedChildNodes(state);
                                    if (c2.size() == 0 || !((NodeData)c2.get(c2.size() - 1)).getUUID().equals(uuid)) {
                                        this.hits.flip(i2);
                                    }
                                } else {
                                    c2 = this.getOrderedChildNodes(state);
                                    if (ChildAxisQuery.this.position < 1 || c2.size() < ChildAxisQuery.this.position || !((NodeData)c2.get(ChildAxisQuery.this.position - 1)).getUUID().equals(uuid)) {
                                        this.hits.flip(i2);
                                    }
                                }
                            } else if (ChildAxisQuery.this.position == Integer.MIN_VALUE) {
                                entry = null;
                                c = this.getOrderedChildNodes(state);
                                for (NodeData d : c) {
                                    if (!d.getUUID().equals(uuid)) continue;
                                    entry = d;
                                }
                                if (entry == null) {
                                    this.hits.flip(i2);
                                } else {
                                    InternalQName name = entry.getQPath().getName();
                                    ArrayList<NodeData> childNodes = new ArrayList<NodeData>();
                                    c = this.getOrderedChildNodes(state);
                                    for (NodeData d : c) {
                                        if (!d.getQPath().getName().equals((Object)name)) continue;
                                        childNodes.add(d);
                                    }
                                    if (childNodes.size() == 0 || !((NodeData)childNodes.get(childNodes.size() - 1)).getUUID().equals(uuid)) {
                                        this.hits.flip(i2);
                                    }
                                }
                            } else {
                                entry = null;
                                c = this.getOrderedChildNodes(state);
                                for (NodeData d : c) {
                                    if (!d.getUUID().equals(uuid)) continue;
                                    entry = d;
                                }
                                if (entry == null) {
                                    this.hits.flip(i2);
                                } else if (entry.getQPath().getIndex() != ChildAxisQuery.this.position) {
                                    this.hits.flip(i2);
                                }
                            }
                        }
                        catch (RepositoryException e) {
                            this.hits.flip(i2);
                        }
                        i2 = this.hits.nextSetBit(i2 + 1);
                    }
                }
            }
        }

        private List getOrderedChildNodes(NodeData node) throws RepositoryException {
            List c = ChildAxisQuery.this.itemMgr.getChildNodesData(node);
            Collections.sort(c, new NodeDatasOrderComparator());
            return c;
        }
    }

    private class ChildAxisWeight
    implements Weight {
        private final Searcher searcher;

        private ChildAxisWeight(Searcher searcher) {
            this.searcher = searcher;
        }

        public Query getQuery() {
            return ChildAxisQuery.this;
        }

        public float getValue() {
            return 1.0f;
        }

        public float sumOfSquaredWeights() throws IOException {
            return 1.0f;
        }

        public void normalize(float norm) {
        }

        public Scorer scorer(IndexReader reader) throws IOException {
            ChildAxisQuery.this.contextScorer = ChildAxisQuery.this.contextQuery.weight(this.searcher).scorer(reader);
            if (ChildAxisQuery.this.nameTest != null) {
                ChildAxisQuery.this.nameTestScorer = new TermQuery(new Term(FieldNames.LABEL, ChildAxisQuery.this.nameTest)).weight(this.searcher).scorer(reader);
            }
            return new ChildAxisScorer(this.searcher.getSimilarity(), reader);
        }

        public Explanation explain(IndexReader reader, int doc) throws IOException {
            return new Explanation();
        }
    }
}

