/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.query.lucene;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import javax.jcr.Item;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import org.apache.commons.logging.Log;
import org.exoplatform.services.jcr.datamodel.InternalQPath;
import org.exoplatform.services.jcr.impl.core.NodeImpl;
import org.exoplatform.services.jcr.impl.core.SessionDataManager;
import org.exoplatform.services.jcr.impl.core.query.lucene.NodeIteratorImpl;
import org.exoplatform.services.jcr.impl.core.query.lucene.ScoreNodeIterator;
import org.exoplatform.services.log.ExoLogger;

class DocOrderNodeIteratorImpl
implements ScoreNodeIterator {
    private static Log log = ExoLogger.getLogger((String)"jcr.DocOrderNodeIteratorImpl");
    private NodeIteratorImpl orderedNodes;
    protected String[] uuids;
    protected Float[] scores;
    protected final SessionDataManager itemMgr;

    DocOrderNodeIteratorImpl(SessionDataManager itemMgr, String[] uuids, Float[] scores) {
        this.itemMgr = itemMgr;
        this.uuids = uuids;
        this.scores = scores;
    }

    public Object next() {
        return this.nextNodeImpl();
    }

    public Node nextNode() {
        return this.nextNodeImpl();
    }

    public NodeImpl nextNodeImpl() {
        this.initOrderedIterator();
        return this.orderedNodes.nextNodeImpl();
    }

    public void remove() {
        throw new UnsupportedOperationException("remove");
    }

    public void skip(long skipNum) {
        this.initOrderedIterator();
        this.orderedNodes.skip(skipNum);
    }

    public long getSize() {
        if (this.orderedNodes != null) {
            return this.orderedNodes.getSize();
        }
        return this.uuids.length;
    }

    public long getPosition() {
        this.initOrderedIterator();
        return this.orderedNodes.getPosition();
    }

    public boolean hasNext() {
        this.initOrderedIterator();
        return this.orderedNodes.hasNext();
    }

    public float getScore() {
        this.initOrderedIterator();
        return this.orderedNodes.getScore();
    }

    private void initOrderedIterator() {
        if (this.orderedNodes != null) {
            return;
        }
        long time = System.currentTimeMillis();
        ScoreNode[] nodes = new ScoreNode[this.uuids.length];
        for (int i = 0; i < this.uuids.length; ++i) {
            nodes[i] = new ScoreNode(this.uuids[i], this.scores[i]);
        }
        final ArrayList invalidUUIDs = new ArrayList(2);
        do {
            if (invalidUUIDs.size() > 0) {
                ScoreNode[] tmp = new ScoreNode[nodes.length - invalidUUIDs.size()];
                int newIdx = 0;
                for (int i = 0; i < nodes.length; ++i) {
                    if (invalidUUIDs.contains(nodes[i].uuid)) continue;
                    tmp[newIdx++] = nodes[i];
                }
                nodes = tmp;
                invalidUUIDs.clear();
            }
            try {
                Arrays.sort(nodes, new Comparator(){

                    public int compare(Object o1, Object o2) {
                        ScoreNode n1 = (ScoreNode)o1;
                        ScoreNode n2 = (ScoreNode)o2;
                        try {
                            int commonDepth;
                            NodeImpl node2;
                            NodeImpl node1;
                            try {
                                node1 = (NodeImpl)DocOrderNodeIteratorImpl.this.itemMgr.getItemByUUID(n1.uuid, true);
                                if (node1 == null) {
                                    throw new RepositoryException("Node not found for " + n1.uuid);
                                }
                            }
                            catch (RepositoryException e) {
                                log.warn((Object)("Node " + n1.uuid + " does not exist anymore: " + (Object)((Object)e)));
                                invalidUUIDs.add(n1.uuid);
                                throw new SortFailedException();
                            }
                            try {
                                node2 = (NodeImpl)DocOrderNodeIteratorImpl.this.itemMgr.getItemByUUID(n2.uuid, true);
                                if (node2 == null) {
                                    throw new RepositoryException("Node not found for " + n2.uuid);
                                }
                            }
                            catch (RepositoryException e) {
                                log.warn((Object)("Node " + n2.uuid + " does not exist anymore: " + (Object)((Object)e)));
                                invalidUUIDs.add(n2.uuid);
                                throw new SortFailedException();
                            }
                            InternalQPath.Entry[] path1 = node1.getLocation().getInternalPath().getEntries();
                            InternalQPath.Entry[] path2 = node2.getLocation().getInternalPath().getEntries();
                            for (commonDepth = 0; path1.length > commonDepth && path2.length > commonDepth && path1[commonDepth].equals((Object)path2[commonDepth]); ++commonDepth) {
                            }
                            if (path1.length - 1 == --commonDepth) {
                                return -1;
                            }
                            if (path2.length - 1 == commonDepth) {
                                return 1;
                            }
                            NodeImpl commonNode = (NodeImpl)node1.getAncestor(commonDepth);
                            node1 = (NodeImpl)node1.getAncestor(commonDepth + 1);
                            node2 = (NodeImpl)node2.getAncestor(commonDepth + 1);
                            NodeIterator it = commonNode.getNodes();
                            while (it.hasNext()) {
                                Node child = it.nextNode();
                                if (child.isSame((Item)node1)) {
                                    return -1;
                                }
                                if (!child.isSame((Item)node2)) continue;
                                return 1;
                            }
                            log.error((Object)"Internal error: unable to determine document order of nodes:");
                            log.error((Object)("\tNode1: " + node1.getPath()));
                            log.error((Object)("\tNode2: " + node2.getPath()));
                        }
                        catch (RepositoryException e) {
                            log.error((Object)("Exception while sorting nodes in document order: " + e.toString()), (Throwable)e);
                        }
                        invalidUUIDs.add(n1.uuid);
                        invalidUUIDs.add(n2.uuid);
                        throw new SortFailedException();
                    }
                });
            }
            catch (SortFailedException e) {
                // empty catch block
            }
        } while (invalidUUIDs.size() > 0);
        if (this.uuids.length != nodes.length) {
            this.uuids = new String[nodes.length];
            this.scores = new Float[nodes.length];
        }
        for (int i = 0; i < nodes.length; ++i) {
            this.uuids[i] = nodes[i].uuid;
            this.scores[i] = nodes[i].score;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("" + this.uuids.length + " node(s) ordered in " + (System.currentTimeMillis() - time) + " ms"));
        }
        this.orderedNodes = new NodeIteratorImpl(this.itemMgr, this.uuids, this.scores);
    }

    private static final class SortFailedException
    extends RuntimeException {
        private SortFailedException() {
        }
    }

    private static final class ScoreNode {
        final String uuid;
        final Float score;

        ScoreNode(String uuid, Float score) {
            this.uuid = uuid;
            this.score = score;
        }
    }
}

