/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.query.lucene;

import java.io.IOException;
import java.io.InputStream;
import java.util.Calendar;
import java.util.List;
import javax.jcr.PropertyType;
import javax.jcr.RepositoryException;
import org.apache.commons.logging.Log;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.exoplatform.services.document.DocumentReaderService;
import org.exoplatform.services.jcr.datamodel.IllegalNameException;
import org.exoplatform.services.jcr.datamodel.IllegalPathException;
import org.exoplatform.services.jcr.datamodel.InternalQName;
import org.exoplatform.services.jcr.datamodel.InternalQPath;
import org.exoplatform.services.jcr.datamodel.NodeData;
import org.exoplatform.services.jcr.datamodel.PropertyData;
import org.exoplatform.services.jcr.datamodel.ValueData;
import org.exoplatform.services.jcr.impl.Constants;
import org.exoplatform.services.jcr.impl.core.LocationFactory;
import org.exoplatform.services.jcr.impl.core.query.lucene.DateField;
import org.exoplatform.services.jcr.impl.core.query.lucene.DoubleField;
import org.exoplatform.services.jcr.impl.core.query.lucene.FieldNames;
import org.exoplatform.services.jcr.impl.core.query.lucene.LongField;
import org.exoplatform.services.jcr.impl.dataflow.persistent.WorkspacePersistentDataManager;
import org.exoplatform.services.jcr.impl.util.DateFormatHelper;
import org.exoplatform.services.jcr.util.io.BLOBUtil;
import org.exoplatform.services.log.ExoLogger;

public class NodeIndexer {
    private static Log log = ExoLogger.getLogger((String)"jcr.NodeIndexer");
    protected final NodeData node;
    protected WorkspacePersistentDataManager dataManager;
    private DocumentReaderService documentReaderService = null;
    protected LocationFactory sysLocationFactory;

    protected NodeIndexer(NodeData node, LocationFactory sysLocationFactory, DocumentReaderService ds, WorkspacePersistentDataManager dataManager) {
        this.node = node;
        this.sysLocationFactory = sysLocationFactory;
        this.documentReaderService = ds;
        this.dataManager = dataManager;
    }

    public static Document createDocument(NodeData node, LocationFactory sysLocationFactory, DocumentReaderService ds, WorkspacePersistentDataManager dataManager) throws RepositoryException {
        if (node != null) {
            NodeIndexer indexer = new NodeIndexer(node, sysLocationFactory, ds, dataManager);
            Document doc = indexer.createDoc();
            return doc;
        }
        return null;
    }

    protected Document createDoc() throws RepositoryException {
        Document doc = new Document();
        doc.add(new Field(FieldNames.UUID, this.node.getUUID(), true, true, false));
        String parentUUID = this.node.getParentUUID();
        if (parentUUID != null) {
            doc.add(new Field(FieldNames.PARENT, parentUUID, true, true, false));
            String label = this.sysLocationFactory.createJCRName(this.node.getQPath().getName()).getAsString();
            doc.add(new Field(FieldNames.LABEL, label, false, true, false));
        } else {
            doc.add(new Field(FieldNames.PARENT, "", true, true, false));
            doc.add(new Field(FieldNames.LABEL, "", false, true, false));
        }
        for (PropertyData prop : this.dataManager.getChildPropertiesData(this.node)) {
            String fieldName = this.sysLocationFactory.createJCRName(prop.getQPath().getName()).getAsString();
            List values = prop.getValues();
            if (values == null) {
                log.warn((Object)("null value found at property " + prop.getQPath().getAsString()));
            }
            for (int i = 0; i < values.size(); ++i) {
                if (log.isDebugEnabled()) {
                    try {
                        log.debug((Object)("Inside NodeIndexer property value " + fieldName + " [" + i + "], type: " + PropertyType.nameFromValue((int)prop.getType())));
                    }
                    catch (IllegalArgumentException e) {
                        if (e.getMessage().indexOf("unknown type") >= 0) {
                            log.debug((Object)("Inside NodeIndexer property value " + fieldName + " [" + i + "], type: " + prop.getType()));
                        }
                        log.warn((Object)("Error of debug log, inside NodeIndexer property " + fieldName + ", [" + i + "]"));
                    }
                }
                this.addValue(doc, (ValueData)values.get(i), fieldName, prop.getType());
            }
            if (values.size() <= 1) continue;
            doc.add(new Field(FieldNames.MVP, fieldName, false, true, false));
        }
        return doc;
    }

    private void addValue(Document doc, ValueData internalValue, String fieldName, int propType) throws RepositoryException {
        switch (propType) {
            case 2: {
                this.addBinaryValue(doc, fieldName, internalValue);
                break;
            }
            case 6: {
                this.addBooleanValue(doc, fieldName, internalValue);
                break;
            }
            case 5: {
                this.addCalendarValue(doc, fieldName, internalValue);
                break;
            }
            case 4: {
                this.addDoubleValue(doc, fieldName, internalValue);
                break;
            }
            case 3: {
                this.addLongValue(doc, fieldName, internalValue);
                break;
            }
            case 9: {
                this.addReferenceValue(doc, fieldName, internalValue);
                break;
            }
            case 8: {
                this.addPathValue(doc, fieldName, internalValue);
                break;
            }
            case 1: {
                this.addStringValue(doc, fieldName, internalValue);
                break;
            }
            case 7: {
                this.addNameValue(doc, fieldName, internalValue);
                break;
            }
            case 100: {
                this.addPermissionValue(doc, fieldName, internalValue);
                break;
            }
            default: {
                throw new IllegalArgumentException("illegal internal value type " + propType);
            }
        }
    }

    protected void addBinaryValue(Document doc, String fieldName, ValueData internalValue) throws RepositoryException {
        String text = "";
        if (this.node.getQPath().getName().equals((Object)Constants.JCR_CONTENT)) {
            for (int i = 0; i < this.dataManager.getChildPropertiesData(this.node).size(); ++i) {
                PropertyData prop = this.dataManager.getChildPropertiesData(this.node).get(i);
                if (!prop.getQPath().getName().equals((Object)Constants.JCR_MIMETYPE)) continue;
                try {
                    List values = prop.getValues();
                    ValueData mimeValue = (ValueData)values.get(0);
                    String mime = new String(mimeValue.getAsByteArray());
                    InputStream is = internalValue.getAsStream();
                    text = this.documentReaderService.getDocumentReader(mime).getContentAsText(is);
                    is.close();
                    continue;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
        if (text != null) {
            doc.add(new Field(FieldNames.FULLTEXT, text, false, true, true));
        }
    }

    protected void addBooleanValue(Document doc, String fieldName, ValueData internalValue) throws RepositoryException {
        try {
            String strValue = new String(BLOBUtil.readValue((ValueData)internalValue));
            doc.add(new Field(FieldNames.PROPERTIES, FieldNames.createNamedValue(fieldName, strValue), false, true, false));
        }
        catch (IOException e) {
            log.error((Object)("Error of add boolean value: " + e.getMessage()), (Throwable)e);
        }
    }

    protected void addCalendarValue(Document doc, String fieldName, ValueData internalValue) throws RepositoryException {
        try {
            Calendar cal = new DateFormatHelper().deserialize(new String(internalValue.getAsByteArray(), "UTF-8"));
            String strValue = DateField.dateToString(cal.getTime());
            doc.add(new Field(FieldNames.PROPERTIES, FieldNames.createNamedValue(fieldName, strValue), false, true, false));
        }
        catch (IOException e) {
            log.error((Object)("Error of add calendar value: " + e.getMessage()), (Throwable)e);
        }
    }

    protected void addDoubleValue(Document doc, String fieldName, ValueData internalValue) throws RepositoryException {
        try {
            String strValue = DoubleField.doubleToString(Double.parseDouble(new String(BLOBUtil.readValue((ValueData)internalValue))));
            doc.add(new Field(FieldNames.PROPERTIES, FieldNames.createNamedValue(fieldName, strValue), false, true, false));
        }
        catch (IOException e) {
            log.error((Object)("Error of add double value: " + e.getMessage()), (Throwable)e);
        }
    }

    protected void addLongValue(Document doc, String fieldName, ValueData internalValue) throws RepositoryException {
        try {
            String strValue = LongField.longToString(Long.parseLong(new String(BLOBUtil.readValue((ValueData)internalValue))));
            doc.add(new Field(FieldNames.PROPERTIES, FieldNames.createNamedValue(fieldName, strValue), false, true, false));
        }
        catch (IOException e) {
            log.error((Object)("Error of add permission value: " + e.getMessage()), (Throwable)e);
        }
    }

    protected void addReferenceValue(Document doc, String fieldName, ValueData internalValue) throws RepositoryException {
        try {
            String strValue = new String(BLOBUtil.readValue((ValueData)internalValue));
            doc.add(new Field(FieldNames.PROPERTIES, FieldNames.createNamedValue(fieldName, strValue), true, true, false));
        }
        catch (IOException e) {
            log.error((Object)("Error of add reference value: " + e.getMessage()), (Throwable)e);
        }
    }

    protected void addPathValue(Document doc, String fieldName, ValueData internalValue) throws RepositoryException {
        try {
            String strQpath = new String(BLOBUtil.readValue((ValueData)internalValue));
            String strValue = this.sysLocationFactory.createJCRPath(InternalQPath.parse((String)strQpath)).getAsString(false);
            doc.add(new Field(FieldNames.PROPERTIES, FieldNames.createNamedValue(fieldName, strValue), false, true, false));
        }
        catch (IllegalPathException e) {
            throw new RepositoryException((Throwable)e);
        }
        catch (IOException e) {
            log.error((Object)("Error of add path value: " + e.getMessage()), (Throwable)e);
        }
    }

    protected void addStringValue(Document doc, String fieldName, ValueData internalValue) throws RepositoryException {
        try {
            String stringValue = new String(BLOBUtil.readValue((ValueData)internalValue));
            doc.add(new Field(FieldNames.PROPERTIES, FieldNames.createNamedValue(fieldName, stringValue), false, true, false));
            doc.add(new Field(FieldNames.FULLTEXT, stringValue, false, true, true));
            int idx = fieldName.indexOf(58);
            fieldName = fieldName.substring(0, idx + 1) + "FULL:" + fieldName.substring(idx + 1);
            doc.add(new Field(fieldName, stringValue, false, true, true));
        }
        catch (IOException e) {
            throw new RepositoryException("Error of add string value: " + e.getMessage(), (Throwable)e);
        }
    }

    protected void addNameValue(Document doc, String fieldName, ValueData internalValue) throws RepositoryException {
        try {
            String strQname = new String(BLOBUtil.readValue((ValueData)internalValue));
            String strValue = this.sysLocationFactory.createJCRName(InternalQName.parse((String)strQname)).getAsString();
            doc.add(new Field(FieldNames.PROPERTIES, FieldNames.createNamedValue(fieldName, strValue), false, true, false));
        }
        catch (IllegalNameException e) {
            throw new RepositoryException((Throwable)e);
        }
        catch (IOException e) {
            log.error((Object)("Error of add name value: " + e.getMessage()), (Throwable)e);
        }
    }

    protected void addPermissionValue(Document doc, String fieldName, ValueData internalValue) throws RepositoryException {
        try {
            String strValue = new String(BLOBUtil.readValue((ValueData)internalValue));
            doc.add(new Field(FieldNames.PROPERTIES, FieldNames.createNamedValue(fieldName, strValue), false, true, false));
        }
        catch (IOException e) {
            log.error((Object)("Error of add permission value: " + e.getMessage()), (Throwable)e);
        }
    }
}

