/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.query.lucene;

import java.io.File;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.InputStream;
import org.apache.lucene.store.OutputStream;
import org.exoplatform.services.jcr.impl.core.query.lucene.AbstractIndex;
import org.exoplatform.services.jcr.impl.core.query.lucene.DocNumberCache;
import org.exoplatform.services.jcr.impl.core.query.lucene.FSDirectory;
import org.exoplatform.services.jcr.impl.core.query.lucene.IndexListener;
import org.exoplatform.services.jcr.impl.core.query.lucene.ReadOnlyIndexReader;
import org.exoplatform.services.log.ExoLogger;

class PersistentIndex
extends AbstractIndex {
    private static Log log = ExoLogger.getLogger((String)"jcr.PersistentIndex");
    private static final String WRITE_LOCK = "write.lock";
    private static final String COMMIT_LOCK = "commit.lock";
    private final String name;
    private boolean lockEncountered = false;
    private IndexListener listener;

    PersistentIndex(String name, File indexDir, boolean create, Analyzer analyzer, DocNumberCache cache) throws IOException {
        super(analyzer, FSDirectory.getDirectory(indexDir, create), cache);
        File commitLock;
        this.name = name;
        File writeLock = new File(indexDir, WRITE_LOCK);
        if (writeLock.exists()) {
            this.lockEncountered = true;
            log.warn((Object)"Removing write lock on search index.");
            if (!writeLock.delete()) {
                log.error((Object)"Unable to remove write lock on search index.");
            }
        }
        if ((commitLock = new File(indexDir, COMMIT_LOCK)).exists()) {
            this.lockEncountered = true;
            log.warn((Object)"Removing commit lock on search index.");
            if (!commitLock.delete()) {
                log.error((Object)"Unable to remove write lock on search index.");
            }
        }
    }

    int removeDocument(Term idTerm) throws IOException {
        int num = super.removeDocument(idTerm);
        if (num > 0 && this.listener != null) {
            this.listener.documentDeleted(idTerm);
        }
        return num;
    }

    boolean getLockEncountered() {
        return this.lockEncountered;
    }

    void mergeIndex(AbstractIndex index) throws IOException {
        index.commit();
        this.getIndexWriter().addIndexes(new Directory[]{index.getDirectory()});
        this.invalidateSharedReader();
    }

    void addIndexes(IndexReader[] readers) throws IOException {
        this.getIndexWriter().addIndexes(readers);
        this.getIndexWriter().optimize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void copyIndex(AbstractIndex index) throws IOException {
        index.commit(true);
        byte[] buffer = new byte[1024];
        Directory dir = index.getDirectory();
        Directory dest = this.getDirectory();
        String[] files = dir.list();
        for (int i = 0; i < files.length; ++i) {
            InputStream in = dir.openFile(files[i]);
            try {
                OutputStream out = dest.createFile(files[i]);
                try {
                    int num;
                    for (long remaining = in.length(); remaining > 0L; remaining -= (long)num) {
                        num = (int)Math.min(remaining, (long)buffer.length);
                        in.readBytes(buffer, 0, num);
                        out.writeBytes(buffer, num);
                    }
                    continue;
                }
                finally {
                    out.close();
                }
            }
            finally {
                in.close();
            }
        }
    }

    synchronized ReadOnlyIndexReader getReadOnlyIndexReader(IndexListener listener) throws IOException {
        ReadOnlyIndexReader reader = this.getReadOnlyIndexReader();
        this.listener = listener;
        return reader;
    }

    synchronized void resetListener() {
        this.listener = null;
    }

    int getNumDocuments() throws IOException {
        return this.getIndexReader().numDocs();
    }

    String getName() {
        return this.name;
    }
}

