/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.query.lucene;

import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.query.QueryResult;
import javax.jcr.query.RowIterator;
import org.apache.commons.logging.Log;
import org.exoplatform.services.jcr.datamodel.InternalQName;
import org.exoplatform.services.jcr.impl.core.SessionImpl;
import org.exoplatform.services.jcr.impl.core.query.lucene.DocOrderNodeIteratorImpl;
import org.exoplatform.services.jcr.impl.core.query.lucene.NodeIteratorImpl;
import org.exoplatform.services.jcr.impl.core.query.lucene.RowIteratorImpl;
import org.exoplatform.services.jcr.impl.core.query.lucene.ScoreNodeIterator;
import org.exoplatform.services.log.ExoLogger;

class QueryResultImpl
implements QueryResult {
    private static Log log = ExoLogger.getLogger((String)"jcr.QueryResultImpl");
    private final String[] uuids;
    private final Float[] scores;
    private final InternalQName[] selectProps;
    private final SessionImpl session;
    private final boolean docOrder;

    public QueryResultImpl(SessionImpl session, String[] uuids, Float[] scores, InternalQName[] selectProps, boolean docOrder) {
        this.uuids = uuids;
        this.scores = scores;
        this.selectProps = selectProps;
        this.docOrder = docOrder;
        this.session = session;
    }

    public String[] getColumnNames() throws RepositoryException {
        String[] propNames = new String[this.selectProps.length];
        for (int i = 0; i < this.selectProps.length; ++i) {
            propNames[i] = this.session.getLocationFactory().createJCRName(this.selectProps[i]).getAsString();
        }
        return propNames;
    }

    public NodeIterator getNodes() throws RepositoryException {
        return this.getNodeIterator();
    }

    public RowIterator getRows() throws RepositoryException {
        return new RowIteratorImpl(this.getNodeIterator(), this.selectProps, this.session);
    }

    private ScoreNodeIterator getNodeIterator() {
        log.debug((Object)("getNodeIterator() " + this.docOrder + " " + this.uuids.length + " " + this.scores.length));
        if (this.docOrder) {
            return new DocOrderNodeIteratorImpl(this.session.getTransientNodesManager(), this.uuids, this.scores);
        }
        return new NodeIteratorImpl(this.session.getTransientNodesManager(), this.uuids, this.scores);
    }
}

