/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.query.lucene;

import java.io.IOException;
import java.util.BitSet;
import java.util.Map;
import java.util.WeakHashMap;
import org.apache.commons.collections.map.LRUMap;
import org.apache.commons.logging.Log;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermDocs;
import org.apache.lucene.index.TermEnum;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Searcher;
import org.apache.lucene.search.Similarity;
import org.apache.lucene.search.Weight;
import org.exoplatform.services.log.ExoLogger;

public class RangeQuery
extends Query {
    private static Log log = ExoLogger.getLogger((String)"jcr.RangeQuery");
    private static final Map cache = new WeakHashMap();
    private Term lowerTerm;
    private Term upperTerm;
    private boolean inclusive;

    public RangeQuery(Term lowerTerm, Term upperTerm, boolean inclusive) {
        if (lowerTerm == null && upperTerm == null) {
            throw new IllegalArgumentException("At least one term must be non-null");
        }
        if (lowerTerm != null && upperTerm != null && lowerTerm.field() != upperTerm.field()) {
            throw new IllegalArgumentException("Both terms must be for the same field");
        }
        this.lowerTerm = lowerTerm != null ? lowerTerm : new Term(upperTerm.field(), "");
        this.upperTerm = upperTerm;
        this.inclusive = inclusive;
    }

    public Query rewrite(IndexReader reader) throws IOException {
        org.apache.lucene.search.RangeQuery stdRangeQueryImpl = new org.apache.lucene.search.RangeQuery(this.lowerTerm, this.upperTerm, this.inclusive);
        try {
            return stdRangeQueryImpl.rewrite(reader);
        }
        catch (BooleanQuery.TooManyClauses e) {
            log.debug((Object)"Too many terms to enumerate, using custom RangeQuery");
            return this;
        }
    }

    protected Weight createWeight(Searcher searcher) {
        return new RangeQueryWeight(searcher);
    }

    public String toString(String field) {
        StringBuffer buffer = new StringBuffer();
        if (!this.getField().equals(field)) {
            buffer.append(this.getField());
            buffer.append(":");
        }
        buffer.append(this.inclusive ? "[" : "{");
        buffer.append(this.lowerTerm != null ? this.lowerTerm.text() : "null");
        buffer.append(" TO ");
        buffer.append(this.upperTerm != null ? this.upperTerm.text() : "null");
        buffer.append(this.inclusive ? "]" : "}");
        if (this.getBoost() != 1.0f) {
            buffer.append("^");
            buffer.append(Float.toString(this.getBoost()));
        }
        return buffer.toString();
    }

    private String getField() {
        return this.lowerTerm != null ? this.lowerTerm.field() : this.upperTerm.field();
    }

    private final class RangeQueryScorer
    extends Scorer {
        private final IndexReader reader;
        private final BitSet hits;
        private boolean hitsCalculated;
        private int nextDoc;
        private final String cacheKey;
        private final Map resultMap;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        RangeQueryScorer(Similarity similarity, IndexReader reader) {
            super(similarity);
            this.hitsCalculated = false;
            this.nextDoc = -1;
            this.reader = reader;
            StringBuffer key = new StringBuffer();
            key.append(RangeQuery.this.lowerTerm != null ? RangeQuery.this.lowerTerm.field() : RangeQuery.this.upperTerm.field());
            key.append('\uffff');
            key.append(RangeQuery.this.lowerTerm != null ? RangeQuery.this.lowerTerm.text() : "");
            key.append('\uffff');
            key.append(RangeQuery.this.upperTerm != null ? RangeQuery.this.upperTerm.text() : "");
            key.append('\uffff');
            key.append(RangeQuery.this.inclusive);
            this.cacheKey = key.toString();
            Map map = cache;
            synchronized (map) {
                Map m = (Map)cache.get(reader);
                if (m == null) {
                    m = new LRUMap(10);
                    cache.put(reader, m);
                }
                this.resultMap = m;
            }
            map = this.resultMap;
            synchronized (map) {
                BitSet result = (BitSet)this.resultMap.get(this.cacheKey);
                if (result == null) {
                    result = new BitSet(reader.maxDoc());
                } else {
                    this.hitsCalculated = true;
                }
                this.hits = result;
            }
        }

        public boolean next() throws IOException {
            this.calculateHits();
            this.nextDoc = this.hits.nextSetBit(this.nextDoc + 1);
            return this.nextDoc > -1;
        }

        public int doc() {
            return this.nextDoc;
        }

        public float score() {
            return 1.0f;
        }

        public boolean skipTo(int target) {
            this.nextDoc = this.hits.nextSetBit(target);
            return this.nextDoc > -1;
        }

        public Explanation explain(int doc) {
            return new Explanation();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void calculateHits() throws IOException {
            if (this.hitsCalculated) {
                return;
            }
            TermEnum enumerator = this.reader.terms(RangeQuery.this.lowerTerm);
            try {
                boolean checkLower = false;
                if (!RangeQuery.this.inclusive) {
                    checkLower = true;
                }
                String testField = RangeQuery.this.getField();
                TermDocs docs = this.reader.termDocs();
                try {
                    Term term;
                    while ((term = enumerator.term()) != null && term.field() == testField) {
                        if (!checkLower || term.text().compareTo(RangeQuery.this.lowerTerm.text()) > 0) {
                            int compare;
                            checkLower = false;
                            if (RangeQuery.this.upperTerm == null || (compare = RangeQuery.this.upperTerm.text().compareTo(term.text())) >= 0 && (RangeQuery.this.inclusive || compare != 0)) {
                                docs.seek(enumerator);
                                while (docs.next()) {
                                    this.hits.set(docs.doc());
                                }
                            }
                        } else if (enumerator.next()) continue;
                        break;
                    }
                }
                finally {
                    docs.close();
                }
            }
            finally {
                enumerator.close();
            }
            this.hitsCalculated = true;
            Map map = this.resultMap;
            synchronized (map) {
                this.resultMap.put(this.cacheKey, this.hits);
                return;
            }
        }
    }

    private class RangeQueryWeight
    implements Weight {
        private final Searcher searcher;

        RangeQueryWeight(Searcher searcher) {
            this.searcher = searcher;
        }

        public Query getQuery() {
            return RangeQuery.this;
        }

        public float getValue() {
            return 1.0f;
        }

        public float sumOfSquaredWeights() throws IOException {
            return 1.0f;
        }

        public void normalize(float norm) {
        }

        public Scorer scorer(IndexReader reader) throws IOException {
            return new RangeQueryScorer(this.searcher.getSimilarity(), reader);
        }

        public Explanation explain(IndexReader reader, int doc) throws IOException {
            return new Explanation();
        }
    }
}

