/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.query.lucene;

import java.io.IOException;
import java.util.BitSet;
import org.apache.lucene.index.FilterIndexReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermDocs;
import org.apache.lucene.index.TermPositions;
import org.exoplatform.services.jcr.impl.core.query.lucene.CachingIndexReader;
import org.exoplatform.services.jcr.impl.core.query.lucene.DocId;
import org.exoplatform.services.jcr.impl.core.query.lucene.SharedIndexReader;

class ReadOnlyIndexReader
extends FilterIndexReader {
    private final SharedIndexReader reader;
    private final BitSet deleted;

    public ReadOnlyIndexReader(SharedIndexReader reader, BitSet deleted) {
        super((IndexReader)reader);
        this.reader = reader;
        this.deleted = deleted;
        reader.addClient((Object)this);
    }

    public DocId getParent(int n) throws IOException {
        return this.getBase().getParent(n, this.deleted);
    }

    public SharedIndexReader getBase() {
        return (SharedIndexReader)this.in;
    }

    public boolean isDeleted(int n) {
        return this.deleted.get(n);
    }

    public boolean hasDeletions() {
        return !this.deleted.isEmpty();
    }

    public int numDocs() {
        return this.maxDoc() - this.deleted.cardinality();
    }

    protected final void doDelete(int docNum) {
        throw new UnsupportedOperationException("IndexReader is read-only");
    }

    protected final void doUndeleteAll() {
        throw new UnsupportedOperationException("IndexReader is read-only");
    }

    protected final void doCommit() {
        throw new UnsupportedOperationException("IndexReader is read-only");
    }

    protected void doClose() throws IOException {
        this.reader.removeClient((Object)this);
    }

    public TermDocs termDocs(Term term) throws IOException {
        Object td = this.reader.termDocs(term);
        if (td != CachingIndexReader.EMPTY) {
            td = new FilteredTermDocs((TermDocs)td);
        }
        return td;
    }

    public TermDocs termDocs() throws IOException {
        return new FilteredTermDocs(super.termDocs());
    }

    public TermPositions termPositions() throws IOException {
        return new FilteredTermPositions(super.termPositions());
    }

    private final class FilteredTermPositions
    extends FilteredTermDocs
    implements TermPositions {
        public FilteredTermPositions(TermPositions in) {
            super((TermDocs)in);
        }

        public int nextPosition() throws IOException {
            return ((TermPositions)this.in).nextPosition();
        }
    }

    private class FilteredTermDocs
    extends FilterIndexReader.FilterTermDocs {
        public FilteredTermDocs(TermDocs in) {
            super(in);
        }

        public boolean next() throws IOException {
            boolean hasNext = super.next();
            while (hasNext && ReadOnlyIndexReader.this.deleted.get(super.doc())) {
                hasNext = super.next();
            }
            return hasNext;
        }

        public int read(int[] docs, int[] freqs) throws IOException {
            int count;
            for (count = 0; count < docs.length && this.next(); ++count) {
                docs[count] = this.doc();
                freqs[count] = this.freq();
            }
            return count;
        }

        public boolean skipTo(int i) throws IOException {
            boolean exists = super.skipTo(i);
            while (exists && ReadOnlyIndexReader.this.deleted.get(this.doc())) {
                exists = this.next();
            }
            return exists;
        }
    }
}

