/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.query.lucene;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.exoplatform.services.jcr.impl.core.query.lucene.MultiIndex;
import org.exoplatform.services.log.ExoLogger;

class RedoLog {
    private static Log log = ExoLogger.getLogger((String)"jcr.RedoLog");
    private final ActionCollector ENTRY_COUNTER = new ActionCollector(){

        public void collect(MultiIndex.Action a) {
            RedoLog.this.entryCount++;
        }
    };
    private final File logFile;
    private int entryCount = 0;
    private Writer out;

    RedoLog(File log) throws IOException {
        this.logFile = log;
        if (!log.exists()) {
            log.getParentFile().mkdirs();
            log.createNewFile();
        }
        this.read(this.ENTRY_COUNTER);
    }

    boolean hasEntries() {
        return this.entryCount > 0;
    }

    int getSize() {
        return this.entryCount;
    }

    List getActions() throws IOException {
        final ArrayList actions = new ArrayList();
        this.read(new ActionCollector(){

            public void collect(MultiIndex.Action a) {
                actions.add(a);
            }
        });
        return actions;
    }

    void append(MultiIndex.Action action) throws IOException {
        this.initOut();
        this.out.write(action.toString() + "\n");
        ++this.entryCount;
    }

    void flush() throws IOException {
        if (this.out != null) {
            this.out.flush();
        }
    }

    void clear() throws IOException {
        if (this.out != null) {
            this.out.close();
            this.out = null;
        }
        new FileOutputStream(this.logFile).close();
        this.entryCount = 0;
    }

    private void initOut() throws IOException {
        if (this.out == null) {
            FileOutputStream os = new FileOutputStream(this.logFile, true);
            this.out = new BufferedWriter(new OutputStreamWriter(os));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void read(ActionCollector collector) throws IOException {
        FileInputStream in = new FileInputStream(this.logFile);
        try {
            String line;
            BufferedReader reader = new BufferedReader(new InputStreamReader(in));
            while ((line = reader.readLine()) != null) {
                try {
                    collector.collect(MultiIndex.Action.fromString(line));
                }
                catch (IllegalArgumentException e) {
                    log.warn((Object)("Malformed redo entry: " + e.getMessage()));
                }
            }
        }
        finally {
            if (in != null) {
                try {
                    ((InputStream)in).close();
                }
                catch (IOException e) {
                    log.warn((Object)("Exception while closing redo log: " + e.toString()));
                }
            }
        }
    }

    static interface ActionCollector {
        public void collect(MultiIndex.Action var1);
    }
}

