/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.value;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Calendar;
import javax.jcr.RepositoryException;
import javax.jcr.ValueFormatException;
import org.exoplatform.commons.utils.ISO8601;
import org.exoplatform.services.jcr.impl.core.value.BaseValue;
import org.exoplatform.services.jcr.impl.dataflow.TransientValueData;

public class DateValue
extends BaseValue {
    public static final int TYPE = 5;

    public DateValue(Calendar date) throws IOException {
        super(5, new TransientValueData(date));
    }

    DateValue(TransientValueData data) throws IOException {
        super(5, data);
    }

    protected String getInternalString() throws ValueFormatException, RepositoryException {
        Calendar date = this.getInternalCalendar();
        if (date != null) {
            return ISO8601.format((Calendar)date);
        }
        throw new ValueFormatException("empty value");
    }

    public long getLong() throws ValueFormatException, IllegalStateException, RepositoryException {
        Calendar date = this.getInternalCalendar();
        if (date != null) {
            return date.getTimeInMillis();
        }
        throw new ValueFormatException("empty value");
    }

    public boolean getBoolean() throws ValueFormatException, IllegalStateException, RepositoryException {
        throw new ValueFormatException("cannot convert date to boolean");
    }

    public double getDouble() throws ValueFormatException, IllegalStateException, RepositoryException {
        Calendar date = this.getInternalCalendar();
        if (date != null) {
            long ms = date.getTimeInMillis();
            if ((double)ms <= Double.MAX_VALUE) {
                return ms;
            }
            throw new ValueFormatException("conversion from date to double failed: inconvertible types");
        }
        throw new ValueFormatException("empty value");
    }

    public long getLength() {
        try {
            return this.getInternalString().length();
        }
        catch (Throwable e) {
            return super.getLength();
        }
    }

    public InputStream getStream() throws ValueFormatException, RepositoryException {
        try {
            if (this.data == null) {
                String inernalString = this.getInternalString();
                this.data = new BaseValue.LocalTransientValueData(true);
                this.data.stream = new ByteArrayInputStream(inernalString.getBytes("UTF-8"));
            }
            return this.data.getAsStream();
        }
        catch (UnsupportedEncodingException e) {
            throw new RepositoryException("UTF-8 not supported on this platform", (Throwable)e);
        }
        catch (IOException e) {
            throw new RepositoryException((Throwable)e);
        }
    }
}

