/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.version;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.TreeSet;
import javax.jcr.ItemNotFoundException;
import javax.jcr.MergeException;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.util.TraversingItemVisitor;
import org.exoplatform.services.jcr.datamodel.NodeData;
import org.exoplatform.services.jcr.impl.core.ItemImpl;
import org.exoplatform.services.jcr.impl.core.JCRPath;
import org.exoplatform.services.jcr.impl.core.NodeImpl;
import org.exoplatform.services.jcr.impl.core.PropertyImpl;
import org.exoplatform.services.jcr.impl.core.SessionImpl;
import org.exoplatform.services.jcr.impl.core.version.VersionImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MergeVisitor
extends TraversingItemVisitor {
    private static int NONE = -1;
    private static int LEAVE = 0;
    private static int FAIL = 1;
    private static int UPDATE = 2;
    private boolean bestEffort;
    private Map<String, String> failed;
    private Set<VersionableState> versionableStates;
    private SessionImpl destSession;
    private NodeImpl destNode;
    protected Stack<NodeImpl> parents;
    private List<ItemImpl> cleanupList = new ArrayList<ItemImpl>();

    public MergeVisitor(NodeImpl node, Map<String, String> failed, boolean bestEffort) {
        this.destSession = node.getSession();
        this.failed = failed;
        this.bestEffort = bestEffort;
        this.versionableStates = new TreeSet<VersionableState>(new VersionableStateComparator());
        this.parents = new Stack();
        this.parents.push(node);
    }

    protected void toLog(String message) {
        System.err.println(message);
    }

    private void cleanItemCache(ItemImpl item) throws RepositoryException {
        this.cleanupList.add(item);
    }

    protected void entering(Node node, int level) throws RepositoryException {
        try {
            this.destNode = ((NodeImpl)node).getCorrespondingNode(this.destSession);
            this.cleanItemCache(this.destNode);
        }
        catch (ItemNotFoundException e) {
            return;
        }
        if (this.destNode.isNodeType("mix:versionable")) {
            VersionImpl srcBase = (VersionImpl)node.getBaseVersion();
            VersionImpl destBase = (VersionImpl)this.destNode.getBaseVersion();
            if (this.destNode.isCheckedOut()) {
                if (destBase.getName().equals(srcBase.getName()) || destBase.isSuccessorOrSameOf(srcBase)) {
                    this.addNode(this.destNode, level);
                    this.versionableStates.add(new VersionableState(this.destNode.getLocation(), LEAVE));
                } else {
                    this.addNode(this.destNode, level);
                    if (!this.bestEffort) {
                        throw new MergeException("Merging of node " + node.getPath() + " failed");
                    }
                    this.failed.put(this.destNode.getUUID(), srcBase.getUUID());
                    this.versionableStates.add(new VersionableState(this.destNode.getLocation(), FAIL));
                }
            } else if (srcBase.isSuccessorOrSameOf(destBase)) {
                this.addNode((NodeImpl)node, level);
                this.versionableStates.add(new VersionableState(this.destNode.getLocation(), UPDATE));
            } else if (destBase.getName().equals(srcBase.getName()) || destBase.isSuccessorOrSameOf(srcBase)) {
                this.addNode(this.destNode, level);
                this.versionableStates.add(new VersionableState(this.destNode.getLocation(), LEAVE));
            } else {
                this.addNode(this.destNode, level);
                if (!this.bestEffort) {
                    throw new MergeException("Merging of node " + node.getPath() + " failed");
                }
                this.failed.put(this.destNode.getUUID(), srcBase.getUUID());
                this.versionableStates.add(new VersionableState(this.destNode.getLocation(), FAIL));
            }
        } else {
            int nearestState = this.getNearestVersionableState(this.destNode);
            if (nearestState == NONE || nearestState == UPDATE) {
                this.addNode((NodeImpl)node, level);
            } else {
                this.addNode(this.destNode, level);
            }
        }
    }

    protected void entering(Property property, int level) throws RepositoryException {
        PropertyImpl propImpl = (PropertyImpl)property;
        int nvs = this.getNearestVersionableState(propImpl);
        if (nvs == UPDATE || nvs == NONE) {
            this.addProperty(propImpl);
        } else {
            this.addProperty((PropertyImpl)this.destNode.getProperty(property.getName()));
        }
    }

    protected void leaving(Property property, int level) throws RepositoryException {
    }

    protected void leaving(Node node, int level) throws RepositoryException {
        this.parents.pop();
    }

    private void addNode(NodeImpl node, int level) throws RepositoryException {
        if (level != 0) {
            NodeData nodeData = (NodeData)node.getData();
            NodeImpl existingNode = null;
            String uuid = null;
            try {
                existingNode = (NodeImpl)this.destSession.getTransientNodesManager().getItem(node.getLocation().getInternalPath(), true);
                uuid = existingNode.getInternalUUID();
            }
            catch (PathNotFoundException e) {
                uuid = nodeData.getUUID();
            }
            throw new RepositoryException("createChildNodeInmemory");
        }
    }

    private void addProperty(PropertyImpl prop) throws RepositoryException {
        throw new RepositoryException("createChildPropertyInmemory");
    }

    private int getNearestVersionableState(ItemImpl item) throws RepositoryException {
        JCRPath path = item.getLocation();
        NodeImpl targetNode = this.curParent();
        if (item.isNode()) {
            targetNode = (NodeImpl)item;
        }
        if (!targetNode.isNodeType("mix:versionable")) {
            return UPDATE;
        }
        for (VersionableState state : this.versionableStates) {
            if (!path.isDescendantOf(state.path, false)) continue;
            return state.result;
        }
        return NONE;
    }

    protected NodeImpl curParent() {
        return this.parents.peek();
    }

    public List<ItemImpl> getCleanupList() {
        return this.cleanupList;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class VersionableStateComparator
    implements Comparator<VersionableState> {
        private VersionableStateComparator() {
        }

        @Override
        public int compare(VersionableState nc1, VersionableState nc2) {
            return nc1.path.getAsString(true).compareTo(nc2.path.getAsString(true));
        }
    }

    private class VersionableState {
        private int result;
        private JCRPath path;

        private VersionableState(JCRPath path, int result) {
            this.path = path;
            this.result = result;
        }
    }
}

