/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.version;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.jcr.AccessDeniedException;
import javax.jcr.InvalidItemStateException;
import javax.jcr.ItemNotFoundException;
import javax.jcr.PathNotFoundException;
import javax.jcr.ReferentialIntegrityException;
import javax.jcr.RepositoryException;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.version.Version;
import javax.jcr.version.VersionException;
import javax.jcr.version.VersionHistory;
import javax.jcr.version.VersionIterator;
import org.exoplatform.services.jcr.dataflow.ItemDataConsumer;
import org.exoplatform.services.jcr.dataflow.ItemDataVisitor;
import org.exoplatform.services.jcr.dataflow.ItemState;
import org.exoplatform.services.jcr.datamodel.InternalQName;
import org.exoplatform.services.jcr.datamodel.InternalQPath;
import org.exoplatform.services.jcr.datamodel.ItemData;
import org.exoplatform.services.jcr.datamodel.NodeData;
import org.exoplatform.services.jcr.datamodel.PropertyData;
import org.exoplatform.services.jcr.datamodel.ValueData;
import org.exoplatform.services.jcr.impl.Constants;
import org.exoplatform.services.jcr.impl.core.JCRName;
import org.exoplatform.services.jcr.impl.core.JCRPath;
import org.exoplatform.services.jcr.impl.core.SessionImpl;
import org.exoplatform.services.jcr.impl.core.nodetype.NodeTypeManagerImpl;
import org.exoplatform.services.jcr.impl.core.version.FrozenNodeInitializer;
import org.exoplatform.services.jcr.impl.core.version.VersionImpl;
import org.exoplatform.services.jcr.impl.core.version.VersionStorageDescendantNode;
import org.exoplatform.services.jcr.impl.dataflow.ItemDataRemoveVisitor;
import org.exoplatform.services.jcr.impl.dataflow.MutableItemDataChangesLog;
import org.exoplatform.services.jcr.impl.dataflow.TransientNodeData;
import org.exoplatform.services.jcr.impl.dataflow.TransientPropertyData;
import org.exoplatform.services.jcr.impl.dataflow.TransientValueData;
import org.exoplatform.services.jcr.impl.dataflow.session.SessionChangesLog;
import org.exoplatform.services.jcr.impl.dataflow.version.VersionHistoryDataHelper;
import org.exoplatform.services.jcr.impl.util.EntityCollection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VersionHistoryImpl
extends VersionStorageDescendantNode
implements VersionHistory {
    public VersionHistoryImpl(NodeData data, SessionImpl session) throws PathNotFoundException, RepositoryException {
        super(data, session);
        if (!this.isNodeType(Constants.NT_VERSIONHISTORY)) {
            throw new RepositoryException("Node " + this.getLocation().getAsString(true) + " is not nt:versionHistory type");
        }
    }

    @Override
    public void loadData(ItemData vhData) throws RepositoryException, InvalidItemStateException, ConstraintViolationException {
        super.loadData((ItemData)new VersionHistoryDataHelper((NodeData)vhData, (ItemDataConsumer)this.session.getTransientNodesManager().getTransactManager(), this.session.getWorkspace().getNodeTypeManager()));
    }

    public VersionHistoryDataHelper getData() {
        return (VersionHistoryDataHelper)super.getData();
    }

    public String getVersionableUUID() throws RepositoryException {
        this.checkValid();
        PropertyData versionableUuid = (PropertyData)this.dataManager.getItemData(InternalQPath.makeChildPath((InternalQPath)this.getLocation().getInternalPath(), (InternalQName)Constants.JCR_VERSIONABLEUUID));
        if (versionableUuid != null) {
            try {
                return new String(((ValueData)versionableUuid.getValues().get(0)).getAsByteArray());
            }
            catch (IllegalStateException e) {
                log.error((Object)("jcr:versionableUuid, error of read " + e + ". Version history " + this.getPath()), (Throwable)e);
            }
            catch (IOException e) {
                log.error((Object)("jcr:versionableUuid, error of read " + e + ". Version history " + this.getPath()), (Throwable)e);
            }
        }
        throw new ItemNotFoundException("A property jcr:versionableUuid is not found. Version history " + this.getPath());
    }

    public Version getRootVersion() throws RepositoryException {
        this.checkValid();
        InternalQPath versionPath = InternalQPath.makeChildPath((InternalQPath)this.getData().getQPath(), (InternalQName)Constants.JCR_ROOTVERSION);
        VersionImpl version = (VersionImpl)this.dataManager.getItem(versionPath, true);
        if (version == null) {
            throw new VersionException("There are no root version in the version history " + this.getPath());
        }
        return version;
    }

    public VersionIterator getAllVersions() throws RepositoryException {
        this.checkValid();
        List<NodeData> versionsDataList = this.getData().getAllVersionsData();
        EntityCollection versions = new EntityCollection();
        for (NodeData vd : versionsDataList) {
            versions.add(new VersionImpl(vd, this.session));
        }
        return versions;
    }

    public Version getVersion(String versionName) throws VersionException, RepositoryException {
        this.checkValid();
        JCRName jcrVersionName = this.locationFactory.parseJCRName(versionName);
        InternalQName versionQName = jcrVersionName.getInternalName();
        InternalQPath versionPath = InternalQPath.makeChildPath((InternalQPath)this.getData().getQPath(), (InternalQName)versionQName);
        VersionImpl version = (VersionImpl)this.dataManager.getItem(versionPath, true);
        if (version == null) {
            throw new VersionException("There are no version with name '" + versionName + "' in the version history " + this.getPath());
        }
        return version;
    }

    public Version getVersionByLabel(String label) throws RepositoryException {
        this.checkValid();
        NodeData versionData = this.getVersionDataByLabel(label);
        if (versionData == null) {
            throw new RepositoryException("There are no label '" + label + "' in the version history " + this.getPath());
        }
        VersionImpl version = (VersionImpl)this.dataManager.getItemByUUID(versionData.getUUID(), true);
        if (version == null) {
            throw new VersionException("There are no version with label '" + label + "' in the version history " + this.getPath());
        }
        return version;
    }

    public boolean hasVersionLabel(String label) throws RepositoryException {
        this.checkValid();
        return this.getVersionDataByLabel(label) != null;
    }

    public boolean hasVersionLabel(Version version, String label) throws VersionException, RepositoryException {
        this.checkValid();
        NodeData versionData = this.getVersionDataByLabel(label);
        return versionData != null && version.getUUID().equals(versionData.getUUID());
    }

    public String[] getVersionLabels() throws RepositoryException {
        this.checkValid();
        List<PropertyData> versionLabels = this.getData().getVersionLabels();
        String[] labelsStrs = new String[versionLabels.size()];
        for (int i = 0; i < versionLabels.size(); ++i) {
            labelsStrs[i] = this.locationFactory.createJCRName(versionLabels.get(i).getQPath().getName()).getAsString();
        }
        return labelsStrs;
    }

    protected List<String> getVersionLabelsList(Version version) throws VersionException, RepositoryException {
        if (!this.isVersionBelongToThis(version)) {
            throw new VersionException("There are no version '" + version.getPath() + "' in the version history " + this.getPath());
        }
        List<PropertyData> labelsList = this.getData().getVersionLabels();
        ArrayList<String> vlabels = new ArrayList<String>();
        try {
            for (PropertyData prop : labelsList) {
                String versionUuid = new String(((ValueData)prop.getValues().get(0)).getAsByteArray());
                if (!versionUuid.equals(((VersionImpl)version).getInternalUUID())) continue;
                vlabels.add(this.locationFactory.createJCRName(prop.getQPath().getName()).getAsString());
            }
        }
        catch (IOException e) {
            throw new RepositoryException("Get version " + version.getPath() + " labels error " + e, (Throwable)e);
        }
        return vlabels;
    }

    public String[] getVersionLabels(Version version) throws VersionException, RepositoryException {
        this.checkValid();
        List<String> vlabels = this.getVersionLabelsList(version);
        String[] res = new String[vlabels.size()];
        for (int i = 0; i < vlabels.size(); ++i) {
            res[i] = vlabels.get(i);
        }
        return res;
    }

    public void removeVersion(String versionName) throws ReferentialIntegrityException, AccessDeniedException, UnsupportedRepositoryOperationException, VersionException, RepositoryException {
        VersionImpl version = (VersionImpl)this.getVersion(versionName);
        List<PropertyData> refs = this.dataManager.getReferencesData(version.getInternalUUID());
        if (refs.size() > 0) {
            throw new ReferentialIntegrityException("There are Reference property pointed to this Version " + refs.get(0).getQPath().getAsString());
        }
        MutableItemDataChangesLog changes = new MutableItemDataChangesLog(this.session.getId());
        try {
            for (PropertyData vlabel : this.getData().getVersionLabels()) {
                String versionUuid = new String(((ValueData)vlabel.getValues().get(0)).getAsByteArray());
                if (!versionUuid.equals(version.getInternalUUID())) continue;
                changes.add(ItemState.createDeletedState((ItemData)vlabel));
            }
        }
        catch (IOException e) {
            throw new RepositoryException("Get version " + version.getPath() + " labels error " + e, (Throwable)e);
        }
        InternalQPath qpath = InternalQPath.makeChildPath((InternalQPath)version.getInternalPath(), (InternalQName)Constants.JCR_SUCCESSORS);
        PropertyData successorsData = (PropertyData)this.dataManager.getItemData(qpath);
        qpath = InternalQPath.makeChildPath((InternalQPath)version.getInternalPath(), (InternalQName)Constants.JCR_PREDECESSORS);
        PropertyData predecessorsData = (PropertyData)this.dataManager.getItemData(qpath);
        try {
            for (ValueData pvalue : predecessorsData.getValues()) {
                String puuid = new String(pvalue.getAsByteArray());
                VersionImpl predecessor = (VersionImpl)this.dataManager.getItemByUUID(puuid, false);
                if (predecessor != null) {
                    for (ValueData svalue : successorsData.getValues()) {
                        predecessor.removeAddSuccessor(version.getInternalUUID(), new String(svalue.getAsByteArray()), changes);
                    }
                    continue;
                }
                throw new RepositoryException("A predecessor (" + puuid + ") of the version " + version.getPath() + " is not found.");
            }
        }
        catch (IOException e) {
            throw new RepositoryException("Get predecessor " + version.getPath() + " error " + e, (Throwable)e);
        }
        try {
            for (ValueData svalue : successorsData.getValues()) {
                String suuid = new String(svalue.getAsByteArray());
                VersionImpl successor = (VersionImpl)this.dataManager.getItemByUUID(suuid, false);
                if (successor != null) {
                    for (ValueData pvalue : predecessorsData.getValues()) {
                        successor.removeAddPredecessor(version.getInternalUUID(), new String(pvalue.getAsByteArray()), changes);
                    }
                    continue;
                }
                throw new RepositoryException("A successor (" + suuid + ") of the version " + version.getPath() + " is not found.");
            }
        }
        catch (IOException e) {
            throw new RepositoryException("Get successor " + version.getPath() + " error " + e, (Throwable)e);
        }
        ItemDataRemoveVisitor removeVisitor = new ItemDataRemoveVisitor((ItemDataConsumer)this.dataManager.getTransactManager());
        version.getData().accept((ItemDataVisitor)removeVisitor);
        changes.addAll(removeVisitor.getRemovedStates());
        this.dataManager.getTransactManager().save(changes);
    }

    protected NodeData getVersionData(String versionName) throws VersionException, RepositoryException {
        JCRPath jcrPath = this.locationFactory.createJCRPath(this.getLocation(), versionName);
        NodeData version = this.getData().getVersionData(jcrPath.getName().getInternalName());
        if (version == null) {
            throw new VersionException("Version is not found " + jcrPath.getAsString(false));
        }
        return version;
    }

    protected NodeData getVersionLabelsData() throws VersionException, RepositoryException {
        NodeData labels = this.getData().getVersionLabelsData();
        if (labels == null) {
            throw new VersionException("Mandatory node jcr:versionLabels is not found for version history " + this.getPath());
        }
        return labels;
    }

    protected NodeData getVersionDataByLabel(String labelName) throws VersionException, RepositoryException {
        JCRName jcrLabelName = this.locationFactory.parseJCRName(labelName);
        InternalQName labelQName = jcrLabelName.getInternalName();
        return this.getData().getVersionDataByLabel(labelQName);
    }

    protected NodeData getVersionDataByUUID(String versionUuid) throws VersionException, RepositoryException {
        NodeData version = (NodeData)this.dataManager.getItemData(versionUuid);
        if (version == null) {
            throw new VersionException("Version is not found, uuid: " + versionUuid);
        }
        return version;
    }

    public void addVersionLabel(String versionName, String label, boolean moveLabel) throws VersionException, RepositoryException {
        this.checkValid();
        JCRName jcrLabelName = this.locationFactory.parseJCRName(label);
        InternalQName labelQName = jcrLabelName.getInternalName();
        NodeData labels = this.getVersionLabelsData();
        List<PropertyData> labelsList = this.dataManager.getChildPropertiesData(labels);
        for (PropertyData prop : labelsList) {
            if (!prop.getQPath().getName().equals((Object)labelQName)) continue;
            if (moveLabel) {
                this.removeVersionLabel(label);
                break;
            }
            throw new VersionException("Label " + label + " is already exists and moveLabel=false");
        }
        NodeData versionData = this.getVersionData(versionName);
        SessionChangesLog changesLog = new SessionChangesLog(this.session.getId());
        TransientPropertyData labelData = TransientPropertyData.createPropertyData(labels, labelQName, 9, false, new TransientValueData(versionData.getUUID()));
        changesLog.add(ItemState.createAddedState((ItemData)labelData));
        this.dataManager.getTransactManager().save(changesLog);
    }

    public void removeVersionLabel(String labelName) throws VersionException, RepositoryException {
        this.checkValid();
        JCRName jcrLabelName = this.locationFactory.parseJCRName(labelName);
        InternalQName labelQName = jcrLabelName.getInternalName();
        InternalQPath vlpath = InternalQPath.makeChildPath((InternalQPath)this.getData().getVersionLabelsData().getQPath(), (InternalQName)labelQName);
        PropertyData vldata = (PropertyData)this.dataManager.getItemData(vlpath);
        if (vldata == null) {
            throw new VersionException("Label not found " + labelName);
        }
        MutableItemDataChangesLog changes = new MutableItemDataChangesLog(this.session.getId());
        changes.add(ItemState.createDeletedState((ItemData)vldata));
        this.dataManager.getTransactManager().save(changes);
    }

    public void addVersion(NodeData versionableNodeData, String uuid, SessionChangesLog changesLog) throws RepositoryException {
        TransientNodeData versionData = TransientNodeData.createNodeData(this.nodeData(), new InternalQName(null, this.nextVersionName()), Constants.NT_VERSION, uuid);
        changesLog.add(ItemState.createAddedState((ItemData)versionData));
        TransientPropertyData propData = TransientPropertyData.createPropertyData((NodeData)versionData, Constants.JCR_PRIMARYTYPE, 7, false, new TransientValueData(Constants.NT_VERSION));
        changesLog.add(ItemState.createAddedState((ItemData)propData));
        propData = TransientPropertyData.createPropertyData((NodeData)versionData, Constants.JCR_MIXINTYPES, 7, true, new TransientValueData(Constants.MIX_REFERENCEABLE));
        changesLog.add(ItemState.createAddedState((ItemData)propData));
        propData = TransientPropertyData.createPropertyData((NodeData)versionData, Constants.JCR_UUID, 1, false, new TransientValueData(uuid));
        changesLog.add(ItemState.createAddedState((ItemData)propData));
        propData = TransientPropertyData.createPropertyData((NodeData)versionData, Constants.JCR_CREATED, 5, false, new TransientValueData(this.session.getTransientNodesManager().getWorkspaceDataManager().getCurrentTime()));
        changesLog.add(ItemState.createAddedState((ItemData)propData));
        InternalQPath predecessorsPath = InternalQPath.makeChildPath((InternalQPath)versionableNodeData.getQPath(), (InternalQName)Constants.JCR_PREDECESSORS);
        List predecessors = ((PropertyData)this.dataManager.getItemData(predecessorsPath)).getValues();
        for (ValueData predecessorValue : predecessors) {
            String predecessorUuid;
            try {
                predecessorUuid = new String(predecessorValue.getAsByteArray());
            }
            catch (IOException e) {
                throw new RepositoryException((Throwable)e);
            }
            VersionImpl predecessor = (VersionImpl)this.dataManager.getItemByUUID(predecessorUuid, true);
            predecessor.addSuccessor(versionData.getUUID(), changesLog);
        }
        propData = TransientPropertyData.createPropertyData((NodeData)versionData, Constants.JCR_PREDECESSORS, 9, true, predecessors);
        changesLog.add(ItemState.createAddedState((ItemData)propData));
        TransientNodeData frozenData = TransientNodeData.createNodeData((NodeData)versionData, Constants.JCR_FROZENNODE, Constants.NT_FROZENNODE);
        changesLog.add(ItemState.createAddedState((ItemData)frozenData));
        propData = TransientPropertyData.createPropertyData((NodeData)frozenData, Constants.JCR_PRIMARYTYPE, 7, false, new TransientValueData(Constants.NT_FROZENNODE));
        changesLog.add(ItemState.createAddedState((ItemData)propData));
        propData = TransientPropertyData.createPropertyData((NodeData)frozenData, Constants.JCR_MIXINTYPES, 7, true, new TransientValueData(Constants.MIX_REFERENCEABLE));
        changesLog.add(ItemState.createAddedState((ItemData)propData));
        propData = TransientPropertyData.createPropertyData((NodeData)frozenData, Constants.JCR_UUID, 1, false, new TransientValueData(frozenData.getUUID()));
        changesLog.add(ItemState.createAddedState((ItemData)propData));
        NodeTypeManagerImpl ntManager = this.session.getWorkspace().getNodeTypeManager();
        FrozenNodeInitializer visitor = new FrozenNodeInitializer((NodeData)frozenData, this.session.getTransientNodesManager(), ntManager, changesLog);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Before frozen visitor: " + changesLog.dump()));
        }
        versionableNodeData.accept((ItemDataVisitor)visitor);
    }

    public boolean isVersionBelongToThis(Version version) {
        return ((VersionImpl)version).getLocation().isDescendantOf(this.getLocation(), false);
    }

    private String nextVersionName() throws RepositoryException {
        int vn = 0;
        VersionIterator allVersions = this.getAllVersions();
        while (allVersions.hasNext()) {
            Version v = allVersions.nextVersion();
            try {
                int vi = Integer.parseInt(v.getName());
                if (vi <= vn) continue;
                vn = vi;
            }
            catch (NumberFormatException e) {}
        }
        return vn > 0 ? String.valueOf(vn + 1) : "1";
    }
}

