/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.version;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.version.Version;
import javax.jcr.version.VersionException;
import org.exoplatform.services.jcr.dataflow.ItemDataVisitor;
import org.exoplatform.services.jcr.dataflow.ItemState;
import org.exoplatform.services.jcr.datamodel.InternalQName;
import org.exoplatform.services.jcr.datamodel.InternalQPath;
import org.exoplatform.services.jcr.datamodel.ItemData;
import org.exoplatform.services.jcr.datamodel.NodeData;
import org.exoplatform.services.jcr.datamodel.PropertyData;
import org.exoplatform.services.jcr.datamodel.Uuid;
import org.exoplatform.services.jcr.datamodel.ValueData;
import org.exoplatform.services.jcr.impl.Constants;
import org.exoplatform.services.jcr.impl.core.NodeImpl;
import org.exoplatform.services.jcr.impl.core.SessionImpl;
import org.exoplatform.services.jcr.impl.core.version.ItemDataRestoreVisitor;
import org.exoplatform.services.jcr.impl.core.version.VersionHistoryImpl;
import org.exoplatform.services.jcr.impl.core.version.VersionStorageDescendantNode;
import org.exoplatform.services.jcr.impl.dataflow.MutableItemDataChangesLog;
import org.exoplatform.services.jcr.impl.dataflow.TransientPropertyData;
import org.exoplatform.services.jcr.impl.dataflow.TransientValueData;
import org.exoplatform.services.jcr.impl.dataflow.session.SessionChangesLog;
import org.exoplatform.services.jcr.impl.dataflow.session.TransactionableDataManager;
import org.exoplatform.services.jcr.impl.dataflow.version.VersionHistoryDataHelper;

public class VersionImpl
extends VersionStorageDescendantNode
implements Version {
    public VersionImpl(NodeData data, SessionImpl session) throws PathNotFoundException, RepositoryException {
        super(data, session);
        if (!this.isNodeType(Constants.NT_VERSION)) {
            throw new RepositoryException("Node " + this.getLocation().getAsString(true) + " is not nt:version type");
        }
    }

    public VersionHistoryImpl getContainingHistory() throws RepositoryException {
        this.checkValid();
        VersionHistoryImpl vhistory = (VersionHistoryImpl)this.dataManager.getItem(this.getInternalPath().makeParentPath(), true);
        if (vhistory == null) {
            throw new VersionException("Version history item is not found for version " + this.getPath());
        }
        return vhistory;
    }

    public Calendar getCreated() throws RepositoryException {
        this.checkValid();
        InternalQPath createdPath = InternalQPath.makeChildPath((InternalQPath)this.getData().getQPath(), (InternalQName)Constants.JCR_CREATED);
        PropertyData pdata = (PropertyData)this.dataManager.getItemData(createdPath);
        if (pdata == null) {
            throw new VersionException("jcr:created property is not found for version " + this.getPath());
        }
        Value created = this.session.getValueFactory().loadValue((TransientValueData)pdata.getValues().get(0), pdata.getType());
        return created.getDate();
    }

    public Version[] getSuccessors() throws RepositoryException {
        this.checkValid();
        InternalQPath successorsPath = InternalQPath.makeChildPath((InternalQPath)this.getData().getQPath(), (InternalQName)Constants.JCR_SUCCESSORS);
        PropertyData successorsData = (PropertyData)this.dataManager.getItemData(successorsPath);
        if (successorsData == null) {
            return new Version[0];
        }
        List successorsValues = successorsData.getValues();
        Version[] successors = new Version[successorsValues.size()];
        try {
            for (int i = 0; i < successorsValues.size(); ++i) {
                String vuuid = new String(((ValueData)successorsValues.get(i)).getAsByteArray());
                VersionImpl version = (VersionImpl)this.dataManager.getItemByUUID(vuuid, false);
                if (version == null) {
                    throw new RepositoryException("Successor version is not found " + vuuid + ", this version " + this.getPath());
                }
                successors[i] = version;
            }
        }
        catch (IOException e) {
            throw new RepositoryException("Successor value read error " + e, (Throwable)e);
        }
        return successors;
    }

    public Version[] getPredecessors() throws RepositoryException {
        this.checkValid();
        InternalQPath predecessorsPath = InternalQPath.makeChildPath((InternalQPath)this.getData().getQPath(), (InternalQName)Constants.JCR_PREDECESSORS);
        PropertyData predecessorsData = (PropertyData)this.dataManager.getItemData(predecessorsPath);
        if (predecessorsData == null) {
            return new Version[0];
        }
        List predecessorsValues = predecessorsData.getValues();
        Version[] predecessors = new Version[predecessorsValues.size()];
        try {
            for (int i = 0; i < predecessorsValues.size(); ++i) {
                String vuuid = new String(((ValueData)predecessorsValues.get(i)).getAsByteArray());
                VersionImpl version = (VersionImpl)this.dataManager.getItemByUUID(vuuid, false);
                if (version == null) {
                    throw new RepositoryException("Predecessor version is not found " + vuuid + ", this version " + this.getPath());
                }
                predecessors[i] = version;
            }
        }
        catch (IOException e) {
            throw new RepositoryException("Predecessor value read error " + e, (Throwable)e);
        }
        return predecessors;
    }

    public void addSuccessor(String successorUuid, MutableItemDataChangesLog changesLog) throws RepositoryException {
        TransientValueData successorRef = new TransientValueData(new Uuid(successorUuid));
        InternalQPath successorsPath = InternalQPath.makeChildPath((InternalQPath)this.getInternalPath(), (InternalQName)Constants.JCR_SUCCESSORS);
        TransientPropertyData successorsProp = (TransientPropertyData)this.dataManager.getItemData(successorsPath);
        if (successorsProp == null) {
            ArrayList<ValueData> successors = new ArrayList<ValueData>();
            successors.add(successorRef);
            successorsProp = TransientPropertyData.createPropertyData(this.nodeData(), Constants.JCR_SUCCESSORS, 9, true, successors);
            changesLog.add(ItemState.createAddedState((ItemData)successorsProp));
        } else {
            TransientPropertyData newSuccessorsProp = successorsProp.clone();
            newSuccessorsProp.getValues().add(successorRef);
            changesLog.add(ItemState.createUpdatedState((ItemData)newSuccessorsProp));
        }
    }

    public void addPredecessor(String predeccessorUuid, MutableItemDataChangesLog changesLog) throws RepositoryException {
        TransientValueData predeccessorRef = new TransientValueData(new Uuid(predeccessorUuid));
        InternalQPath predeccessorssPath = InternalQPath.makeChildPath((InternalQPath)this.getInternalPath(), (InternalQName)Constants.JCR_PREDECESSORS);
        TransientPropertyData predeccessorsProp = (TransientPropertyData)this.dataManager.getItemData(predeccessorssPath);
        if (predeccessorsProp == null) {
            ArrayList<ValueData> predeccessors = new ArrayList<ValueData>();
            predeccessors.add(predeccessorRef);
            predeccessorsProp = TransientPropertyData.createPropertyData(this.nodeData(), Constants.JCR_PREDECESSORS, 9, true, predeccessors);
            changesLog.add(ItemState.createAddedState((ItemData)predeccessorsProp));
        } else {
            TransientPropertyData newPredeccessorsProp = predeccessorsProp.clone();
            newPredeccessorsProp.getValues().add(predeccessorRef);
            changesLog.add(ItemState.createUpdatedState((ItemData)newPredeccessorsProp));
        }
    }

    void removeSuccessor(String successorUuid, MutableItemDataChangesLog changesLog) throws RepositoryException {
        ArrayList<ValueData> newSuccessors;
        InternalQPath successorsPath = InternalQPath.makeChildPath((InternalQPath)this.getInternalPath(), (InternalQName)Constants.JCR_SUCCESSORS);
        PropertyData successorsProp = (PropertyData)this.dataManager.getItemData(successorsPath);
        if (successorsProp != null) {
            newSuccessors = new ArrayList<ValueData>();
            try {
                for (ValueData sdata : successorsProp.getValues()) {
                    if (successorUuid.equals(new String(sdata.getAsByteArray()))) continue;
                    newSuccessors.add(sdata);
                }
            }
            catch (IOException e) {
                throw new RepositoryException("A jcr:successors property read error " + e, (Throwable)e);
            }
        } else {
            throw new RepositoryException("A jcr:successors property is not found, version " + this.getPath());
        }
        TransientPropertyData newSuccessorsProp = new TransientPropertyData(InternalQPath.makeChildPath((InternalQPath)this.nodeData().getQPath(), (InternalQName)Constants.JCR_SUCCESSORS, (int)successorsProp.getQPath().getIndex()), successorsProp.getUUID(), successorsProp.getPersistedVersion(), 9, this.nodeData().getUUID(), true);
        newSuccessorsProp.setValues(newSuccessors);
        changesLog.add(ItemState.createUpdatedState((ItemData)newSuccessorsProp));
    }

    void removeAddSuccessor(String removedSuccessorUuid, String addedSuccessorUuid, MutableItemDataChangesLog changesLog) throws RepositoryException {
        ArrayList<ValueData> newSuccessors;
        InternalQPath successorsPath = InternalQPath.makeChildPath((InternalQPath)this.getInternalPath(), (InternalQName)Constants.JCR_SUCCESSORS);
        PropertyData successorsProp = (PropertyData)this.dataManager.getItemData(successorsPath);
        if (successorsProp != null) {
            newSuccessors = new ArrayList<ValueData>();
            try {
                for (ValueData sdata : successorsProp.getValues()) {
                    if (removedSuccessorUuid.equals(new String(sdata.getAsByteArray()))) continue;
                    newSuccessors.add(sdata);
                }
            }
            catch (IOException e) {
                throw new RepositoryException("A jcr:successors property read error " + e, (Throwable)e);
            }
        } else {
            throw new RepositoryException("A jcr:successors property is not found, version " + this.getPath());
        }
        newSuccessors.add(new TransientValueData(new Uuid(addedSuccessorUuid)));
        TransientPropertyData newSuccessorsProp = new TransientPropertyData(InternalQPath.makeChildPath((InternalQPath)this.nodeData().getQPath(), (InternalQName)Constants.JCR_SUCCESSORS, (int)successorsProp.getQPath().getIndex()), successorsProp.getUUID(), successorsProp.getPersistedVersion(), 9, this.nodeData().getUUID(), true);
        newSuccessorsProp.setValues(newSuccessors);
        changesLog.add(ItemState.createUpdatedState((ItemData)newSuccessorsProp));
    }

    void removePredecessor(String predecessorUuid, MutableItemDataChangesLog changesLog) throws RepositoryException {
        ArrayList<ValueData> newPredeccessors;
        InternalQPath predeccessorsPath = InternalQPath.makeChildPath((InternalQPath)this.getInternalPath(), (InternalQName)Constants.JCR_PREDECESSORS);
        PropertyData predeccessorsProp = (PropertyData)this.dataManager.getItemData(predeccessorsPath);
        if (predeccessorsProp != null) {
            newPredeccessors = new ArrayList<ValueData>();
            try {
                for (ValueData sdata : predeccessorsProp.getValues()) {
                    if (predecessorUuid.equals(new String(sdata.getAsByteArray()))) continue;
                    newPredeccessors.add(sdata);
                }
            }
            catch (IOException e) {
                throw new RepositoryException("A jcr:predecessors property read error " + e, (Throwable)e);
            }
        } else {
            throw new RepositoryException("A jcr:predecessors property is not found, version " + this.getPath());
        }
        TransientPropertyData newPredecessorsProp = new TransientPropertyData(InternalQPath.makeChildPath((InternalQPath)this.nodeData().getQPath(), (InternalQName)Constants.JCR_PREDECESSORS, (int)predeccessorsProp.getQPath().getIndex()), predeccessorsProp.getUUID(), predeccessorsProp.getPersistedVersion(), 9, this.nodeData().getUUID(), true);
        newPredecessorsProp.setValues(newPredeccessors);
        changesLog.add(ItemState.createUpdatedState((ItemData)newPredecessorsProp));
    }

    void removeAddPredecessor(String removedPredecessorUuid, String addedPredecessorUuid, MutableItemDataChangesLog changesLog) throws RepositoryException {
        ArrayList<ValueData> newPredeccessors;
        InternalQPath predeccessorsPath = InternalQPath.makeChildPath((InternalQPath)this.getInternalPath(), (InternalQName)Constants.JCR_PREDECESSORS);
        PropertyData predeccessorsProp = (PropertyData)this.dataManager.getItemData(predeccessorsPath);
        if (predeccessorsProp != null) {
            newPredeccessors = new ArrayList<ValueData>();
            try {
                for (ValueData sdata : predeccessorsProp.getValues()) {
                    if (removedPredecessorUuid.equals(new String(sdata.getAsByteArray()))) continue;
                    newPredeccessors.add(sdata);
                }
            }
            catch (IOException e) {
                throw new RepositoryException("A jcr:predecessors property read error " + e, (Throwable)e);
            }
        } else {
            throw new RepositoryException("A jcr:predecessors property is not found, version " + this.getPath());
        }
        newPredeccessors.add(new TransientValueData(new Uuid(addedPredecessorUuid)));
        TransientPropertyData newPredecessorsProp = new TransientPropertyData(InternalQPath.makeChildPath((InternalQPath)this.nodeData().getQPath(), (InternalQName)Constants.JCR_PREDECESSORS, (int)predeccessorsProp.getQPath().getIndex()), predeccessorsProp.getUUID(), predeccessorsProp.getPersistedVersion(), 9, this.nodeData().getUUID(), true);
        newPredecessorsProp.setValues(newPredeccessors);
        changesLog.add(ItemState.createUpdatedState((ItemData)newPredecessorsProp));
    }

    public SessionChangesLog restoreLog(NodeData nodeData, VersionHistoryDataHelper historyData, SessionImpl restoreSession, boolean removeExisting, SessionChangesLog delegatedLog) throws RepositoryException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Restore: " + nodeData.getQPath().getAsString() + ", removeExisting=" + removeExisting));
        }
        TransactionableDataManager dmanager = restoreSession.getTransientNodesManager().getTransactManager();
        NodeData parentData = (NodeData)dmanager.getItemData(nodeData.getParentUUID());
        InternalQPath frozenPath = InternalQPath.makeChildPath((InternalQPath)this.getData().getQPath(), (InternalQName)Constants.JCR_FROZENNODE);
        NodeData frozenData = (NodeData)dmanager.getItemData(frozenPath);
        ItemDataRestoreVisitor restoreVisitor = new ItemDataRestoreVisitor(parentData, nodeData.getQPath().getName(), (NodeData)historyData, restoreSession, removeExisting, delegatedLog);
        frozenData.accept((ItemDataVisitor)restoreVisitor);
        return restoreVisitor.getRestoreChanges();
    }

    public void restore(NodeImpl node, boolean removeExisting) throws RepositoryException {
        SessionImpl restoreSession = node.getSession();
        NodeData nodeData = (NodeData)node.getData();
        VersionHistoryDataHelper historyData = node.getVersionHistory().getData();
        SessionChangesLog changesLog = this.restoreLog(nodeData, historyData, restoreSession, removeExisting, null);
        restoreSession.getTransientNodesManager().getTransactManager().save(changesLog);
    }

    public boolean isSuccessorOrSameOf(VersionImpl anotherVersion) throws RepositoryException {
        Version[] prds = this.getPredecessors();
        for (int i = 0; i < prds.length; ++i) {
            if (!prds[i].getUUID().equals(anotherVersion.getUUID()) && !((VersionImpl)prds[i]).isSuccessorOrSameOf(anotherVersion)) continue;
            return true;
        }
        return false;
    }
}

