/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.dataflow;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.jcr.ItemExistsException;
import javax.jcr.RepositoryException;
import org.exoplatform.services.jcr.dataflow.ItemState;
import org.exoplatform.services.jcr.datamodel.InternalQName;
import org.exoplatform.services.jcr.datamodel.ItemData;
import org.exoplatform.services.jcr.datamodel.NodeData;
import org.exoplatform.services.jcr.datamodel.PropertyData;
import org.exoplatform.services.jcr.impl.Constants;
import org.exoplatform.services.jcr.impl.core.ItemImpl;
import org.exoplatform.services.jcr.impl.core.SessionDataManager;
import org.exoplatform.services.jcr.impl.core.nodetype.NodeTypeManagerImpl;
import org.exoplatform.services.jcr.impl.dataflow.ItemDataCopyVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ItemDataCloneVisitor
extends ItemDataCopyVisitor {
    private boolean removeExisting;
    protected List<ItemState> itemDeletedExistingStates = new ArrayList<ItemState>();
    protected final SessionDataManager dstDataManager;
    private boolean deletedExistingPropery = false;

    public ItemDataCloneVisitor(NodeData parent, InternalQName dstNodeName, NodeTypeManagerImpl nodeTypeManager, SessionDataManager srcDataManager, SessionDataManager dstDataManager, boolean removeExisting) {
        super(parent, dstNodeName, nodeTypeManager, srcDataManager, false);
        this.dstDataManager = dstDataManager;
        this.removeExisting = removeExisting;
    }

    @Override
    protected void entering(NodeData node, int level) throws RepositoryException {
        boolean isMixReferenceable = this.ntManager.isNodeType(Constants.MIX_REFERENCEABLE, node.getPrimaryTypeName(), node.getMixinTypeNames());
        this.deletedExistingPropery = false;
        if (isMixReferenceable) {
            String uuid = node.getUUID();
            ItemImpl relItem = this.dstDataManager.getItemByUUID(uuid, true);
            if (relItem != null) {
                if (this.removeExisting) {
                    this.deletedExistingPropery = true;
                    this.itemDeletedExistingStates.add(new ItemState(relItem.getData(), 3, true, this.dstDataManager.getItemByUUID(relItem.getParentUUID(), true).getInternalPath(), level != 0));
                } else {
                    throw new ItemExistsException("Item exists uuid = " + uuid + " name " + relItem.getName());
                }
            }
            this.keepUUIDs = true;
        }
        super.entering(node, level);
        this.keepUUIDs = false;
    }

    public List<ItemState> getItemDeletedExistingStates(boolean isInverse) {
        if (isInverse) {
            Collections.reverse(this.itemDeletedExistingStates);
        }
        return this.itemDeletedExistingStates;
    }

    private boolean itemInItemStateList(List<ItemState> list, String itemId, int state) {
        boolean retval = false;
        for (ItemState itemState : list) {
            if (itemState.getState() != state || !itemState.getData().getUUID().equals(itemId)) continue;
            retval = true;
            break;
        }
        return retval;
    }

    @Override
    protected void entering(PropertyData property, int level) throws RepositoryException {
        if (this.deletedExistingPropery && this.removeExisting && this.itemInItemStateList(this.itemDeletedExistingStates, property.getParentUUID(), 3)) {
            ItemData dstParentNodeData = this.dstDataManager.getItemByUUID(property.getParentUUID(), true).getData();
            List<PropertyData> dstChildProperties = this.dstDataManager.getChildPropertiesData((NodeData)dstParentNodeData);
            PropertyData dstProperty = null;
            for (PropertyData propertyData : dstChildProperties) {
                if (!propertyData.getQPath().getName().equals((Object)property.getQPath().getName())) continue;
                dstProperty = propertyData;
                break;
            }
            if (dstProperty != null) {
                this.itemDeletedExistingStates.add(new ItemState((ItemData)dstProperty, 3, true, this.dstDataManager.getItemByUUID(dstProperty.getParentUUID(), true).getInternalPath(), level != 0));
            } else {
                throw new RepositoryException("Destination propery " + property.getQPath().getAsString() + " not found. ");
            }
        }
        super.entering(property, level);
    }
}

