/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.dataflow;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Externalizable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.Calendar;
import org.exoplatform.services.jcr.access.AccessControlEntry;
import org.exoplatform.services.jcr.datamodel.InternalQName;
import org.exoplatform.services.jcr.datamodel.InternalQPath;
import org.exoplatform.services.jcr.datamodel.Uuid;
import org.exoplatform.services.jcr.impl.dataflow.AbstractValueData;
import org.exoplatform.services.jcr.impl.util.DateFormatHelper;
import org.exoplatform.services.jcr.impl.util.io.FileCleaner;

public class TransientValueData
extends AbstractValueData
implements Externalizable {
    protected byte[] data;
    protected InputStream tmpStream;
    protected InputStream lockStream;
    protected File spoolFile;
    protected FileCleaner fileCleaner;
    protected int maxBufferSize;
    protected File tempDirectory;
    protected boolean spooled = false;
    private final boolean deleteSpoolFile;

    protected static byte[] stringToBytes(String value) {
        try {
            return value.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("FATAL ERROR Charset UTF-8 is not supported!");
        }
    }

    private TransientValueData(byte[] value, int orderNumber) {
        super(orderNumber);
        this.data = value;
        this.deleteSpoolFile = true;
    }

    private TransientValueData(InputStream stream, int orderNumber) {
        super(orderNumber);
        this.tmpStream = stream;
        this.deleteSpoolFile = true;
    }

    public TransientValueData(int orderNumber, byte[] bytes, InputStream stream, File spoolFile, FileCleaner fileCleaner, int maxBufferSize, File tempDirectory, boolean deleteSpoolFile) {
        super(orderNumber);
        this.data = bytes;
        this.tmpStream = stream;
        this.spoolFile = spoolFile;
        this.fileCleaner = fileCleaner;
        this.maxBufferSize = maxBufferSize;
        this.tempDirectory = tempDirectory;
        this.deleteSpoolFile = deleteSpoolFile;
        if (spoolFile != null) {
            this.spooled = true;
        }
    }

    public TransientValueData(InputStream stream) {
        this(stream, 0);
    }

    public TransientValueData(String value) {
        this(TransientValueData.stringToBytes(value), 0);
    }

    public TransientValueData(boolean value) {
        this(Boolean.valueOf(value).toString().getBytes(), 0);
    }

    public TransientValueData(Calendar value) {
        this(new DateFormatHelper().serialize(value), 0);
    }

    public TransientValueData(double value) {
        this(Double.valueOf(value).toString().getBytes(), 0);
    }

    public TransientValueData(long value) {
        this(Long.valueOf(value).toString().getBytes(), 0);
    }

    public TransientValueData(InternalQName value) {
        this(value.getAsString().getBytes(), 0);
    }

    public TransientValueData(InternalQPath value) {
        this(value.getAsString().getBytes(), 0);
    }

    public TransientValueData(Uuid value) {
        this(value.getString().getBytes(), 0);
    }

    public TransientValueData(AccessControlEntry value) {
        this(value.getAsString().getBytes(), 0);
    }

    public byte[] getAsByteArray() throws IOException {
        this.spoolInputStream();
        if (this.data != null) {
            byte[] bytes = new byte[this.data.length];
            System.arraycopy(this.data, 0, bytes, 0, this.data.length);
            return bytes;
        }
        return this.fileToByteArray();
    }

    public InputStream getAsStream() throws IOException {
        this.spoolInputStream();
        if (this.data != null) {
            return new ByteArrayInputStream(this.data);
        }
        if (this.spoolFile != null) {
            return new FileInputStream(this.spoolFile);
        }
        throw new NullPointerException("Null Stream data ");
    }

    public long getLength() {
        try {
            this.spoolInputStream();
        }
        catch (IOException e) {
            e.printStackTrace();
            return -1L;
        }
        if (this.data == null) {
            return this.spoolFile.length();
        }
        return this.data.length;
    }

    public boolean isByteArray() {
        try {
            this.spoolInputStream();
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        return this.data != null;
    }

    public TransientValueData createTransientCopy() {
        if (this.isByteArray()) {
            byte[] newBytes = new byte[this.data.length];
            System.arraycopy(this.data, 0, newBytes, 0, newBytes.length);
            return new TransientValueData(newBytes, this.orderNumber);
        }
        return this;
    }

    public File getSpoolFile() {
        try {
            this.spoolInputStream();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        return this.spoolFile;
    }

    public String getString() throws IOException {
        return new String(this.getAsByteArray(), "UTF-8");
    }

    public void setFileCleaner(FileCleaner cleaner) {
        this.fileCleaner = cleaner;
    }

    public void setTempDirectory(File tempDirectory) {
        this.tempDirectory = tempDirectory;
    }

    public void setMaxBufferSize(int maxBufferSize) {
        this.maxBufferSize = maxBufferSize;
    }

    protected void finalize() throws Throwable {
        if (this.spoolFile != null) {
            if (this.lockStream != null) {
                this.lockStream.close();
                this.lockStream = null;
            }
            if (this.deleteSpoolFile && this.spoolFile.exists() && !this.spoolFile.delete()) {
                if (this.fileCleaner != null) {
                    log.info((Object)("Could not remove file. Add to fileCleaner " + this.spoolFile));
                    this.fileCleaner.addFile(this.spoolFile);
                } else {
                    log.warn((Object)("Could not remove temporary file on finalize " + this.spoolFile.getAbsolutePath()));
                }
            }
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof TransientValueData) {
            TransientValueData other = (TransientValueData)obj;
            if (this.isByteArray() != other.isByteArray()) {
                return false;
            }
            try {
                if (this.isByteArray()) {
                    return Arrays.equals(this.getAsByteArray(), other.getAsByteArray());
                }
                return this.getSpoolFile().equals(other.getSpoolFile());
            }
            catch (IOException e) {
                e.printStackTrace();
                return false;
            }
        }
        return false;
    }

    private boolean toBufferOnly() {
        return this.fileCleaner == null;
    }

    private void spoolInputStream() throws IOException {
        if (this.spooled || this.tmpStream == null) {
            return;
        }
        this.spoolFile = File.createTempFile("jcrvd", null, this.tempDirectory);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        FileOutputStream fos = new FileOutputStream(this.spoolFile);
        byte[] buffer = new byte[8192];
        int total = 0;
        try {
            int len;
            while ((len = this.tmpStream.read(buffer)) > 0) {
                if (!this.toBufferOnly()) {
                    fos.write(buffer, 0, len);
                }
                if ((total += len) < this.maxBufferSize || this.toBufferOnly()) {
                    baos.write(buffer, 0, len);
                    continue;
                }
                baos = null;
            }
            fos.close();
            if (baos != null) {
                this.spoolFile.delete();
                this.spoolFile = null;
                this.data = baos.toByteArray();
                baos.close();
            } else {
                this.data = null;
            }
            this.tmpStream = null;
            this.spooled = true;
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public void lock() {
        if (this.lockStream == null && this.spoolFile != null) {
            try {
                this.lockStream = new FileInputStream(this.spoolFile);
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
        }
    }

    private byte[] fileToByteArray() throws IOException {
        int len;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte[] buffer = new byte[8192];
        int total = 0;
        FileInputStream stream = new FileInputStream(this.spoolFile);
        while ((len = stream.read(buffer)) > 0) {
            out.write(buffer, 0, len);
            if ((total += len) <= this.maxBufferSize) continue;
            log.warn((Object)("Potential lack of memory due to call getAsByteArray() on stream data exceeded " + total + " bytes"));
        }
        out.close();
        return out.toByteArray();
    }

    public TransientValueData() {
        super(0);
        this.deleteSpoolFile = true;
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        if (this.isByteArray()) {
            out.writeInt(1);
            int f = this.data.length;
            out.writeInt(f);
            out.write(this.data);
        } else {
            out.writeInt(2);
        }
        out.writeInt(this.orderNumber);
        out.writeInt(this.maxBufferSize);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int type = in.readInt();
        if (type == 1) {
            this.data = new byte[in.readInt()];
            for (int i = 0; i < this.data.length; ++i) {
                this.data[i] = in.readByte();
            }
        }
        this.orderNumber = in.readInt();
        this.maxBufferSize = in.readInt();
    }

    public void setStream(InputStream in) {
        this.tmpStream = in;
    }
}

