/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.dataflow.persistent;

import java.util.Calendar;
import java.util.List;
import javax.jcr.InvalidItemStateException;
import javax.jcr.RepositoryException;
import org.apache.commons.logging.Log;
import org.exoplatform.services.jcr.access.AccessControlList;
import org.exoplatform.services.jcr.dataflow.ItemDataChangesLog;
import org.exoplatform.services.jcr.dataflow.ItemDataConsumer;
import org.exoplatform.services.jcr.dataflow.SharedDataManager;
import org.exoplatform.services.jcr.datamodel.InternalQPath;
import org.exoplatform.services.jcr.datamodel.ItemData;
import org.exoplatform.services.jcr.datamodel.NodeData;
import org.exoplatform.services.jcr.datamodel.PropertyData;
import org.exoplatform.services.jcr.impl.dataflow.persistent.CacheableWorkspaceDataManager;
import org.exoplatform.services.log.ExoLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ACLInheritanceSupportedWorkspaceDataManager
implements ItemDataConsumer,
SharedDataManager {
    private static Log log = ExoLogger.getLogger((String)"jcr.ACLInheritanceSupportedWorkspaceDataManager");
    private final CacheableWorkspaceDataManager persistentManager;

    public ACLInheritanceSupportedWorkspaceDataManager(CacheableWorkspaceDataManager persistentManager) {
        this.persistentManager = persistentManager;
    }

    public AccessControlList getACL(InternalQPath qpath) throws RepositoryException {
        AccessControlList acl = this.persistentManager.getACL(qpath);
        if (acl == null) {
            NodeData data = this.getNearestACAncestor(qpath);
            if (data == null) {
                throw new RepositoryException("FATAL: Node Data not found for ACL:  " + qpath);
            }
            acl = data.getACL();
        }
        return acl;
    }

    private NodeData getNearestACAncestor(InternalQPath qpath) throws RepositoryException {
        ItemData item = this.persistentManager.getItemData(qpath);
        if (item == null || !item.isNode()) {
            return this.getNearestACAncestor(qpath.makeParentPath());
        }
        if (((NodeData)item).getACL() != null) {
            return (NodeData)item;
        }
        return this.getNearestACAncestor(qpath.makeParentPath());
    }

    private ItemData initACL(ItemData data) throws RepositoryException {
        if (data != null && data.isNode()) {
            boolean haveParent;
            NodeData nData = (NodeData)data;
            boolean bl = haveParent = data.getQPath().getDepth() > 1;
            if (nData.getACL() == null && haveParent) {
                ((NodeData)data).setACL(this.persistentManager.getACL(data.getQPath().makeParentPath()));
            }
            if (nData.getACL() != null && nData.getACL().getOwner() == null && haveParent) {
                AccessControlList parentACL = this.persistentManager.getACL(nData.getQPath().makeParentPath());
                if (parentACL != null) {
                    nData.getACL().setOwner(parentACL.getOwner());
                } else {
                    log.warn((Object)("!!!!Parent path " + nData.getQPath().makeParentPath() + " ACL == null;!!!!"));
                }
            }
        }
        return data;
    }

    public List<NodeData> getChildNodesData(NodeData nodeData) throws RepositoryException {
        List<NodeData> nodes = this.persistentManager.getChildNodesData(nodeData);
        for (NodeData node : nodes) {
            this.initACL((ItemData)node);
        }
        return nodes;
    }

    public ItemData getItemData(InternalQPath qpath) throws RepositoryException {
        return this.initACL(this.persistentManager.getItemData(qpath));
    }

    public ItemData getItemData(String uuid) throws RepositoryException {
        return this.initACL(this.persistentManager.getItemData(uuid));
    }

    public List<PropertyData> getChildPropertiesData(NodeData parent) throws RepositoryException {
        return this.persistentManager.getChildPropertiesData(parent);
    }

    public List<PropertyData> getReferencesData(String uuid) throws RepositoryException {
        return this.persistentManager.getReferencesData(uuid);
    }

    public void save(ItemDataChangesLog changes) throws InvalidItemStateException, UnsupportedOperationException, RepositoryException {
        this.persistentManager.save(changes);
    }

    public Calendar getCurrentTime() {
        return this.persistentManager.getCurrentTime();
    }
}

