/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.dataflow.persistent;

import java.util.List;
import javax.jcr.RepositoryException;
import org.exoplatform.services.jcr.dataflow.persistent.ItemsPersistenceListener;
import org.exoplatform.services.jcr.dataflow.persistent.WorkspaceStorageCache;
import org.exoplatform.services.jcr.datamodel.InternalQPath;
import org.exoplatform.services.jcr.datamodel.ItemData;
import org.exoplatform.services.jcr.datamodel.NodeData;
import org.exoplatform.services.jcr.datamodel.PropertyData;
import org.exoplatform.services.jcr.impl.dataflow.persistent.WorkspacePersistentDataManager;
import org.exoplatform.services.jcr.impl.dataflow.persistent.WorkspaceStorageCacheImpl;
import org.exoplatform.services.jcr.storage.WorkspaceDataContainer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CacheableWorkspaceDataManager
extends WorkspacePersistentDataManager {
    protected WorkspaceStorageCache cache = null;

    public CacheableWorkspaceDataManager(WorkspaceDataContainer dataContainer, WorkspaceStorageCacheImpl cache) {
        super(dataContainer);
        this.cache = cache;
        this.addItemPersistenceListener((ItemsPersistenceListener)cache);
    }

    @Override
    public ItemData getItemData(String uuid) throws RepositoryException {
        ItemData data = this.getCachedItemData(uuid);
        if (data == null) {
            return this.getPersistedItemData(uuid);
        }
        return data;
    }

    @Override
    public ItemData getItemData(InternalQPath qpath) throws RepositoryException {
        ItemData data = this.getCachedItemData(qpath);
        if (data == null) {
            data = this.getPersistedItemData(qpath);
        }
        return data;
    }

    @Override
    public List<NodeData> getChildNodesData(NodeData nodeData) throws RepositoryException {
        return this.getChildNodesData(nodeData, false);
    }

    @Override
    public List<PropertyData> getChildPropertiesData(NodeData nodeData) throws RepositoryException {
        return this.getChildPropertiesData(nodeData, false);
    }

    protected List<NodeData> getChildNodesData(NodeData nodeData, boolean forcePersistentRead) throws RepositoryException {
        List childNodes = null;
        if (!forcePersistentRead && this.cache.isEnabled() && (childNodes = this.cache.getChildNodes(nodeData)) != null) {
            return childNodes;
        }
        childNodes = super.getChildNodesData(nodeData);
        if (this.cache.isEnabled()) {
            NodeData parentData = (NodeData)this.cache.get(nodeData.getUUID());
            if (parentData == null) {
                parentData = (NodeData)super.getItemData(nodeData.getUUID());
            }
            this.cache.addChildNodes(parentData, childNodes);
        }
        return childNodes;
    }

    protected List<PropertyData> getChildPropertiesData(NodeData nodeData, boolean forcePersistentRead) throws RepositoryException {
        List childProperties = null;
        if (!forcePersistentRead && this.cache.isEnabled() && (childProperties = this.cache.getChildProperties(nodeData)) != null) {
            return childProperties;
        }
        childProperties = super.getChildPropertiesData(nodeData);
        if (this.cache.isEnabled()) {
            NodeData parentData = (NodeData)this.cache.get(nodeData.getUUID());
            if (parentData == null) {
                parentData = (NodeData)super.getItemData(nodeData.getUUID());
            }
            this.cache.addChildProperties(parentData, childProperties);
        }
        return childProperties;
    }

    @Override
    public List<PropertyData> getReferencesData(String uuid) throws RepositoryException {
        return super.getReferencesData(uuid);
    }

    public WorkspaceStorageCache getCache() {
        return this.cache;
    }

    protected ItemData getCachedItemData(InternalQPath qpath) throws RepositoryException {
        return this.cache.get(qpath);
    }

    protected ItemData getPersistedItemData(InternalQPath qpath) throws RepositoryException {
        ItemData data = null;
        data = super.getItemData(qpath);
        if (data != null && this.cache.isEnabled()) {
            this.cache.put(data);
        }
        return data;
    }

    protected ItemData getCachedItemData(String uuid) throws RepositoryException {
        return this.cache.get(uuid);
    }

    protected ItemData getPersistedItemData(String uuid) throws RepositoryException {
        ItemData data = super.getItemData(uuid);
        if (data != null && this.cache.isEnabled()) {
            this.cache.put(data);
        }
        return data;
    }
}

